/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.stats;

import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import java.io.IOException;
import java.util.List;
import javax.persistence.Query;

public class EGStatAnnuelleProducteur
extends AbstractExcelGenerator {
    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<Integer> annees = this.getAllAnnees(em);
        List<Producteur> producteurs = this.getAllProducteurs(em);
        et.addSheet("Statistiques producteur", 1 + annees.size(), 20);
        et.setColumnWidth(0, 40);
        et.addRow("Statistiques producteur par ann\u00e9e", et.titre);
        et.addRow();
        et.addRow();
        et.setCell(0, "Nom du producteur", et.grasGaucheNonWrappeBordure);
        int i = 0;
        while (i < annees.size()) {
            et.setCell(i + 1, "" + annees.get(i), et.grasCentreBordure);
            ++i;
        }
        for (Producteur producteur : producteurs) {
            et.addRow();
            et.setCell(0, producteur.nom, et.grasGaucheNonWrappeBordure);
            int i2 = 0;
            while (i2 < annees.size()) {
                int mnt = this.getMontant(producteur, annees.get(i2), em);
                et.setCellPrix(i2 + 1, mnt, et.prixCentreBordure);
                ++i2;
            }
        }
    }

    private List<Integer> getAllAnnees(RdbLink em) {
        Query q = em.createQuery("select distinct(EXTRACT(YEAR d.dateLiv))   from ModeleContratDate d order by EXTRACT(YEAR d.dateLiv)");
        List ps = q.getResultList();
        return ps;
    }

    private List<Producteur> getAllProducteurs(RdbLink em) {
        Query q = em.createQuery("select p from Producteur p order by p.nom");
        List ps = q.getResultList();
        return ps;
    }

    private int getMontant(Producteur producteur, Integer annee, RdbLink em) {
        Query q = em.createQuery("select sum(c.qte*c.modeleContratProduit.prix) from ContratCell c  WHERE EXTRACT(YEAR c.modeleContratDate.dateLiv)=:an and c.modeleContratDate.modeleContrat.producteur = :p");
        q.setParameter("an", (Object)annee);
        q.setParameter("p", (Object)producteur);
        return SQLUtils.toInt(q.getSingleResult());
    }

    @Override
    public String getFileName(RdbLink em) {
        return "stat-producteur-";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "Montant livr\u00e9 par chaque producteur, une colonne par ann\u00e9e civile";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGStatAnnuelleProducteur().test();
    }
}

