/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel.stats;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.collections.G2D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.gestioncontratsigne.ContratSigneDTO;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.gestioncotisation.BilanAdhesionDTO;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import java.util.List;
import javax.persistence.TypedQuery;

public class EGStatPeriodeContratAdherent
extends AbstractExcelGenerator {
    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<PeriodeCotisationDTO> periodes = new GestionCotisationService().getAll();
        CollectionUtils.sort(periodes, e -> e.dateDebut, false);
        for (PeriodeCotisationDTO periode : periodes) {
            this.fillTab(em, et, periode);
        }
        this.fillTab(em, et, null);
    }

    private void fillTab(RdbLink em, ExcelGeneratorTool et, PeriodeCotisationDTO periode) {
        String nomPeriode = periode == null ? "CONTRATS SANS PERIODE DE COTISATION" : periode.nom;
        Long idPeriode = periode == null ? null : periode.id;
        List<Contrat> cs = this.getContrat(em, idPeriode);
        G2D<ModeleContrat, Utilisateur, Contrat> c1 = new G2D<ModeleContrat, Utilisateur, Contrat>();
        c1.fill(cs);
        c1.groupByLig(e -> e.modeleContrat);
        c1.groupByCol(e -> e.utilisateur);
        c1.sortCol(e -> e.nom, true);
        c1.sortCol(e -> e.prenom, true);
        c1.sortLig(e -> e.nom, true);
        c1.compute();
        List ligs = c1.getLigs();
        List cols = c1.getCols();
        int nbCol = cols.size() + 2;
        et.addSheet(nomPeriode, nbCol, 25);
        et.setColumnWidth(0, 50);
        et.setColumnWidth(1, 15);
        et.addRow();
        et.setRowHeigth(2);
        et.createFreezePane(1, 1);
        et.setCell(0, "Nom du contrat", et.grasCentreBordureGray);
        et.setCell(1, "Total", et.grasCentreBordureGray);
        int index = 2;
        for (Utilisateur u : cols) {
            et.setCell(index, String.valueOf(u.nom) + " " + u.prenom, et.grasCentreBordureGray);
            ++index;
        }
        int i = 0;
        while (i < ligs.size()) {
            ModeleContrat mc = (ModeleContrat)ligs.get(i);
            List<List<Contrat>> contrats = c1.getLine(i);
            this.addRow(mc, contrats, et, em);
            ++i;
        }
        et.addRow();
        if (ligs.size() > 0) {
            et.addRow();
            et.setCell(0, "Total des contrats", et.grasCentreBordureGray);
            i = 1;
            while (i < nbCol) {
                et.setCellSumInColUp(i, 2, ligs.size(), et.prixCentreBordureGray);
                ++i;
            }
        }
        et.addRow();
        if (idPeriode != null) {
            PeriodeCotisationUtilisateurDTO pcu;
            BilanAdhesionDTO bilan = new GestionCotisationService().loadBilanAdhesion(idPeriode);
            et.addRow();
            et.setCell(0, "Montant adh\u00e9sion", et.grasCentreBordure);
            if (cols.size() > 0) {
                et.setCellSumInRow(1, 2, cols.size(), et.prixCentreBordure);
            }
            index = 2;
            for (Utilisateur u : cols) {
                pcu = this.findPeriodeCotisationUtilisateurDTO(bilan, u.id);
                if (pcu == null) {
                    et.setCell(index, "NA", et.grasCentreBordure);
                } else {
                    et.setCellPrix(index, pcu.montantAdhesion, et.prixCentreBordure);
                }
                ++index;
            }
            et.addRow();
            et.setCell(0, "Etat adh\u00e9sion", et.grasCentreBordure);
            et.setCell(1, "", et.nonGrasCentreBordure);
            index = 2;
            for (Utilisateur u : cols) {
                pcu = this.findPeriodeCotisationUtilisateurDTO(bilan, u.id);
                if (pcu == null) {
                    et.setCell(index, "NA", et.grasCentreBordure);
                } else {
                    et.setCell(index, "" + (Object)((Object)pcu.etatPaiementAdhesion), et.nonGrasCentreBordure);
                }
                ++index;
            }
        }
    }

    private PeriodeCotisationUtilisateurDTO findPeriodeCotisationUtilisateurDTO(BilanAdhesionDTO bilan, Long idUtilisateur) {
        return bilan.utilisateurDTOs.stream().filter(e -> e.idUtilisateur.equals(idUtilisateur)).findAny().orElse(null);
    }

    private List<Contrat> getContrat(RdbLink em, Long idPeriodeCotisation) {
        if (idPeriodeCotisation != null) {
            TypedQuery<Contrat> q = em.createQuery("select c from Contrat c  where c.modeleContrat.periodeCotisation.id = :id ", Contrat.class);
            q.setParameter("id", (Object)idPeriodeCotisation);
            return q.getResultList();
        }
        TypedQuery<Contrat> q = em.createQuery("select c from Contrat c  where c.modeleContrat.periodeCotisation is NULL ", Contrat.class);
        return q.getResultList();
    }

    private void addRow(ModeleContrat mc, List<List<Contrat>> contrats, ExcelGeneratorTool et, RdbLink em) {
        et.addRow();
        et.setCell(0, mc.nom, et.grasCentreBordure);
        if (contrats.size() > 0) {
            et.setCellSumInRow(1, 2, contrats.size(), et.prixCentreBordure);
        }
        int index = 2;
        for (List<Contrat> cs : contrats) {
            Contrat c = this.getContrat(cs);
            if (c == null) {
                et.setCellPrix(index, 0, et.prixCentreBordure);
            } else {
                ContratSigneDTO dto = new GestionContratSigneService().createContratSigneInfo(em, c);
                int montant = dto.mntCommande;
                et.setCellPrix(index, montant, et.prixCentreBordure);
            }
            ++index;
        }
    }

    private Contrat getContrat(List<Contrat> cs) {
        if (cs.size() == 0) {
            return null;
        }
        if (cs.size() == 1) {
            return cs.get(0);
        }
        throw new AmapjRuntimeException("cs size = " + cs.size());
    }

    @Override
    public String getFileName(RdbLink em) {
        return "cotisation-contrat-adherent";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        return "Montant des contrats et de l'adh\u00e9sion pour chaque amapien, avec une feuille par p\u00e9riode de cotisation";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLSX;
    }
}

