/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.pdf;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.cotisation.PeriodeCotisationUtilisateur;
import fr.amapj.model.models.editionspe.AbstractEditionSpeJson;
import fr.amapj.model.models.editionspe.AbstractPdfEditionSpeJson;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.adhesion.BulletinAdhesionJson;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import fr.amapj.service.engine.generator.pdf.TestablePdfGenerator;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.editionspe.EditionSpeService;
import java.util.List;
import java.util.function.Supplier;
import javax.persistence.Query;

public class PGBulletinAdhesion
extends TestablePdfGenerator {
    private Long idPeriode;
    private Long idPeriodeUtilisateur;
    private Long idUtilisateur;
    private Mode mode;
    private Supplier<GenericUtils.Ret<Integer>> montantSupplier;
    private int montant;

    public static PGBulletinAdhesion allBulletinPeriode(Long idPeriode) {
        return new PGBulletinAdhesion(Mode.ALL_BULLETIN_PERIODE, idPeriode, null, null, null, null);
    }

    public static PGBulletinAdhesion oneBulletinCreated(Long idPeriode, Long idPeriodeUtilisateur) {
        return new PGBulletinAdhesion(Mode.ONE_BULLETIN_CREATED, idPeriode, idPeriodeUtilisateur, null, null, null);
    }

    public static PGBulletinAdhesion oneBulletinNotCreated(Long idPeriode, Long idUtilisateur, Supplier<GenericUtils.Ret<Integer>> montantSupplier) {
        return new PGBulletinAdhesion(Mode.ONE_BULLETIN_NOT_CREATED, idPeriode, null, idUtilisateur, null, montantSupplier);
    }

    public static PGBulletinAdhesion testMode(BulletinAdhesionJson forTest) {
        return new PGBulletinAdhesion(Mode.ALL_BULLETIN_PERIODE, null, null, null, forTest, null);
    }

    private PGBulletinAdhesion(Mode mode, Long idPeriode, Long idPeriodeUtilisateur, Long idUtilisateur, BulletinAdhesionJson forTest, Supplier<GenericUtils.Ret<Integer>> montantSupplier) {
        super(forTest);
        this.mode = mode;
        this.idPeriode = idPeriode;
        this.idPeriodeUtilisateur = idPeriodeUtilisateur;
        this.idUtilisateur = idUtilisateur;
        this.montantSupplier = montantSupplier;
    }

    @Override
    public String readDataInTestMode(RdbLink em, AbstractEditionSpeJson forTest) {
        BulletinAdhesionJson engJson = (BulletinAdhesionJson)forTest;
        if (engJson.idPeriodeCotisation == null) {
            return "<p>Vous devez selectionner une periode pour pouvoir tester !</p>";
        }
        this.idPeriode = engJson.idPeriodeCotisation;
        return null;
    }

    @Override
    public AbstractPdfEditionSpeJson getEditionInNormalMode(RdbLink em) {
        PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
        EditionSpecifique editionSpecifique = pc.bulletinAdhesion;
        AbstractPdfEditionSpeJson bulletin = (AbstractPdfEditionSpeJson)new EditionSpeService().load(editionSpecifique.id);
        return bulletin;
    }

    @Override
    public void fillPdfFile(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        switch (this.mode) {
            case ALL_BULLETIN_PERIODE: {
                this.performAllBulletins(em, et, htmlContent);
                return;
            }
            case ONE_BULLETIN_CREATED: {
                this.performOneBulletinCreated(em, et, htmlContent);
                return;
            }
            case ONE_BULLETIN_NOT_CREATED: {
                this.performOneBulletinNotCreated(em, et, htmlContent);
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void performOneBulletinCreated(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        PeriodeCotisationUtilisateur pcu = em.find(PeriodeCotisationUtilisateur.class, this.idPeriodeUtilisateur);
        PeriodeCotisation pc = pcu.periodeCotisation;
        Utilisateur u = pcu.utilisateur;
        this.addOneBulletin(em, pc, pcu, u, et, htmlContent);
    }

    private void performOneBulletinNotCreated(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        GenericUtils.Ret<Integer> ret = this.montantSupplier.get();
        if (!ret.isOK()) {
            et.addContent("Il y a une erreur dans la saisie du montant de l'adhesion<br/>");
            et.addContent(ret.msg());
            return;
        }
        this.montant = ret.get();
        PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
        Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
        this.addOneBulletin(em, pc, null, u, et, htmlContent);
    }

    private void performAllBulletins(RdbLink em, PdfGeneratorTool et, String htmlContent) {
        PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
        List<PeriodeCotisationUtilisateur> pcus = this.getAllUtilisateurAvecAdhesion(em, pc);
        int nb = pcus.size();
        int i = 0;
        while (i < nb) {
            PeriodeCotisationUtilisateur pcu = pcus.get(i);
            this.addOneBulletin(em, pc, pcu, pcu.utilisateur, et, htmlContent);
            if (i != nb - 1) {
                et.addSautPage();
            }
            ++i;
        }
        if (nb == 0) {
            et.addContent("<p>Aucun utilisateur n'a adh\u00e9r\u00e9 !! </p>");
        }
    }

    private List<PeriodeCotisationUtilisateur> getAllUtilisateurAvecAdhesion(RdbLink em, PeriodeCotisation p) {
        Query q = em.createQuery("select pu from PeriodeCotisationUtilisateur pu WHERE pu.periodeCotisation=:p  order by pu.utilisateur.nom, pu.utilisateur.prenom");
        q.setParameter("p", (Object)p);
        List us = q.getResultList();
        return us;
    }

    private void addOneBulletin(RdbLink em, PeriodeCotisation pc, PeriodeCotisationUtilisateur pcu, Utilisateur u, PdfGeneratorTool et, String htmlContent) {
        VelocityTools ctx = this.generateContext(em, pc, pcu, u);
        String res = ctx.evaluate(htmlContent);
        et.addContent(res);
    }

    private VelocityTools generateContext(RdbLink em, PeriodeCotisation pc, PeriodeCotisationUtilisateur pcu, Utilisateur u) {
        VelocityTools ctx = new VelocityTools();
        VCBuilder.addAmap(ctx);
        VCBuilder.addDateInfo(ctx);
        VCBuilder.addAmapien(ctx, u);
        VCBuilder.addAdhesion(ctx, pc, pcu, em, this.montant);
        return ctx;
    }

    @Override
    public String getFileNameStandard(RdbLink em) {
        if (this.mode == Mode.ALL_BULLETIN_PERIODE) {
            PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
            return "bulletin-adhesion-" + pc.nom;
        }
        if (this.mode == Mode.ONE_BULLETIN_CREATED) {
            PeriodeCotisationUtilisateur pcu = em.find(PeriodeCotisationUtilisateur.class, this.idPeriodeUtilisateur);
            Utilisateur u = pcu.utilisateur;
            return "bulletin-adhesion-" + pcu.periodeCotisation.nom + "-" + u.nom + " " + u.prenom;
        }
        if (this.mode == Mode.ONE_BULLETIN_NOT_CREATED) {
            PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            return "bulletin-adhesion-" + pc.nom + "-" + u.nom + " " + u.prenom;
        }
        throw new AmapjRuntimeException();
    }

    @Override
    public String getNameToDisplayStandard(RdbLink em) {
        if (this.mode == Mode.ALL_BULLETIN_PERIODE) {
            PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
            return "la liste des bulletins d'adh\u00e9sion pour " + pc.nom;
        }
        if (this.mode == Mode.ONE_BULLETIN_CREATED) {
            PeriodeCotisationUtilisateur pcu = em.find(PeriodeCotisationUtilisateur.class, this.idPeriodeUtilisateur);
            Utilisateur u = pcu.utilisateur;
            return "le bulletin d'adhesion " + pcu.periodeCotisation.nom + " pour " + u.nom + " " + u.prenom;
        }
        if (this.mode == Mode.ONE_BULLETIN_NOT_CREATED) {
            PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.idPeriode);
            Utilisateur u = em.find(Utilisateur.class, this.idUtilisateur);
            return "le bulletin d'adhesion " + pc.nom + " pour " + u.nom + " " + u.prenom;
        }
        throw new AmapjRuntimeException();
    }

    private static enum Mode {
        ALL_BULLETIN_PERIODE,
        ONE_BULLETIN_CREATED,
        ONE_BULLETIN_NOT_CREATED;

    }
}

