/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.zip;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.service.engine.generator.zip.AbstractZipGenerator;
import fr.amapj.service.engine.generator.zip.ZipGeneratorTool;
import fr.amapj.service.services.edgenerator.bin.BGDocEngagementSigne;
import fr.amapj.service.services.edgenerator.excel.docengagement.EGBilanDocEngagementSignOnLine;
import fr.amapj.service.services.edgenerator.pdf.PGEngagement;
import java.util.List;

public class ZGAllDocEngagementModeleContrat
extends AbstractZipGenerator {
    private Long idModeleContrat;

    public ZGAllDocEngagementModeleContrat(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
    }

    @Override
    public void fillZipFile(RdbLink em, ZipGeneratorTool et) {
        et.addFile(em, new EGBilanDocEngagementSignOnLine(this.idModeleContrat));
        em.createQuery("select c from Contrat c where c.modeleContrat.id=:id order by c.utilisateur.nom,c.utilisateur.prenom");
        em.setParameter("id", this.idModeleContrat);
        List<Contrat> cs = em.result().list(Contrat.class);
        for (Contrat c : cs) {
            if (c.docEngagementSigne != null) {
                et.addFile(em, new BGDocEngagementSigne(c.id));
                continue;
            }
            et.addFile(em, new PGEngagement(PGEngagement.PGEngagementMode.UN_CONTRAT, c.modeleContrat.id, c.id, null));
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        return "contrats";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        ModeleContrat mc = em.find(ModeleContrat.class, this.idModeleContrat);
        return "tous les documents d'engagement " + mc.nom;
    }
}

