/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontrat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.amapj.common.GzipUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.extendparam.MiseEnFormeGraphique;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RegleSaisieModeleContrat;
import fr.amapj.model.models.extendedparam.ExtendedParam;

public class ExtPModeleContratService {
    @DbRead
    public MiseEnFormeGraphique loadMiseEnFormeGraphique(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            MiseEnFormeGraphique miseEnFormeGraphique = this.getMiseEnFormeGraphique(mc.miseEnFormeGraphique);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return miseEnFormeGraphique;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void saveMiseEnFormeGraphique(Long idModeleContrat, MiseEnFormeGraphique pm) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            this.setMiseEnFormeGraphique(em, mc, pm);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private MiseEnFormeGraphique getMiseEnFormeGraphique(ExtendedParam extendedParam) {
        if (extendedParam == null) {
            MiseEnFormeGraphique pm = new MiseEnFormeGraphique();
            pm.setDefault();
            return pm;
        }
        MiseEnFormeGraphique res = (MiseEnFormeGraphique)new Gson().fromJson(GzipUtils.uncompress(extendedParam.content), MiseEnFormeGraphique.class);
        res.setDefault();
        return res;
    }

    private void setMiseEnFormeGraphique(RdbLink em, ModeleContrat mc, MiseEnFormeGraphique pm) {
        Gson gson = new Gson();
        String str = gson.toJson((Object)pm);
        MiseEnFormeGraphique def = new MiseEnFormeGraphique();
        def.setDefault();
        String ref = gson.toJson((Object)def);
        if (ref.equals(str)) {
            if (mc.miseEnFormeGraphique != null) {
                em.remove(mc.miseEnFormeGraphique);
            }
            mc.miseEnFormeGraphique = null;
        } else {
            if (mc.miseEnFormeGraphique == null) {
                mc.miseEnFormeGraphique = new ExtendedParam();
                em.persist(mc.miseEnFormeGraphique);
            }
            mc.miseEnFormeGraphique.content = GzipUtils.compress(str);
        }
    }

    @DbRead
    public RegleSaisieModeleContrat loadRegleSaisieModeleContrat(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            RegleSaisieModeleContrat regleSaisieModeleContrat = this.getRegleSaisieModeleContrat(mc.regleSaisieModeleContrat);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return regleSaisieModeleContrat;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void saveRegleSaisieModeleContrat(Long idModeleContrat, RegleSaisieModeleContrat pm) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            this.setRegleSaisieModeleContrat(em, mc, pm);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public RegleSaisieModeleContrat getRegleSaisieModeleContrat(ExtendedParam extendedParam) {
        if (extendedParam == null) {
            RegleSaisieModeleContrat pm = new RegleSaisieModeleContrat();
            return pm;
        }
        RegleSaisieModeleContrat res = (RegleSaisieModeleContrat)this.createGson().fromJson(GzipUtils.uncompress(extendedParam.content), RegleSaisieModeleContrat.class);
        return res;
    }

    private void setRegleSaisieModeleContrat(RdbLink em, ModeleContrat mc, RegleSaisieModeleContrat pm) {
        Gson gson = this.createGson();
        String str = gson.toJson((Object)pm);
        if (pm.regleSaisies.size() == 0) {
            if (mc.regleSaisieModeleContrat != null) {
                em.remove(mc.regleSaisieModeleContrat);
            }
            mc.regleSaisieModeleContrat = null;
        } else {
            if (mc.regleSaisieModeleContrat == null) {
                mc.regleSaisieModeleContrat = new ExtendedParam();
                em.persist(mc.regleSaisieModeleContrat);
            }
            mc.regleSaisieModeleContrat.content = GzipUtils.compress(str);
        }
    }

    @DbWrite
    public void copyExtendedParam(Long idOldContrat, Long idNewContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mcOld = em.find(ModeleContrat.class, idOldContrat);
            ModeleContrat mcNew = em.find(ModeleContrat.class, idNewContrat);
            mcNew.miseEnFormeGraphique = this.duplicateExtendedParam(em, mcOld.miseEnFormeGraphique);
            mcNew.regleSaisieModeleContrat = this.duplicateExtendedParam(em, mcOld.regleSaisieModeleContrat);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private ExtendedParam duplicateExtendedParam(RdbLink em, ExtendedParam epOld) {
        if (epOld == null) {
            return null;
        }
        ExtendedParam ep = new ExtendedParam();
        ep.content = epOld.content;
        em.persist(ep);
        return ep;
    }

    public void suppressExtendedParameters(RdbLink em, ModeleContrat mc) {
        this.remove(em, mc.regleSaisieModeleContrat);
        mc.regleSaisieModeleContrat = null;
        this.remove(em, mc.miseEnFormeGraphique);
        mc.miseEnFormeGraphique = null;
    }

    private void remove(RdbLink em, ExtendedParam ep) {
        if (ep != null) {
            em.remove(ep);
        }
    }

    private Gson createGson() {
        return new GsonBuilder().setDateFormat("dd/MM/yyyy").create();
    }
}

