/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontrat.reglesaisie;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.IdContainer;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RSChampApplication;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.VerifRegleSaisieResultDTO;
import fr.amapj.service.services.mescontrats.ContratColDTO;
import fr.amapj.service.services.mescontrats.ContratDTO;
import fr.amapj.service.services.mescontrats.ContratLigDTO;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class VerifRegleSaisieModeleContratDTO {
    public List<RegleSaisieDTO> regleSaisies = new ArrayList<RegleSaisieDTO>();
    public ContratDTO contratDTO;
    public SaisieContrat.ModeSaisie modeSaisie;

    public VerifRegleSaisieResultDTO performCheck() {
        VerifRegleSaisieResultDTO res = new VerifRegleSaisieResultDTO();
        for (RegleSaisieDTO regleSaisieDTO : this.regleSaisies) {
            this.isValid(regleSaisieDTO, res);
        }
        return res;
    }

    private void isValid(RegleSaisieDTO r, VerifRegleSaisieResultDTO res) {
        if (!this.isApplicable(r)) {
            return;
        }
        List<ContratColDTO> produits = this.computeProduits(r);
        switch (r.contrainteDate) {
            case POUR_CHAQUE_DATE: {
                this.isValidPourChaqueDate(produits, r, res);
                break;
            }
            case POUR_TOUT_CONTRAT: 
            case POUR_UNE_DATE: 
            case POUR_PLUSIEURS_DATES: {
                this.isValidPourUneOuPlusieursDates(produits, r, res);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private boolean isApplicable(RegleSaisieDTO r) {
        switch (this.modeSaisie) {
            case READ_ONLY: 
            case CHEQUE_SEUL: {
                return false;
            }
            case QTE_SEUL: 
            case QTE_CHEQUE_REFERENT: {
                return r.champApplication == RSChampApplication.TOUS;
            }
            case STANDARD: 
            case JOKER: 
            case FOR_TEST: {
                return true;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void isValidPourChaqueDate(List<ContratColDTO> produits, RegleSaisieDTO r, VerifRegleSaisieResultDTO res) {
        SimpleDateFormat df = FormatUtils.getStdDate();
        ArrayList<String> ls = new ArrayList<String>();
        for (ContratLigDTO contratLigDTO : this.contratDTO.contratLigs) {
            this.checkOneRegle(produits, Arrays.asList(contratLigDTO), r, ls, "Date : " + df.format(contratLigDTO.date));
        }
        if (ls.size() != 0) {
            VerifRegleSaisieResultDTO.ResultDTO x = new VerifRegleSaisieResultDTO.ResultDTO();
            x.regleSaisieDTO = r;
            x.msgs = ls;
            res.errors.add(x);
        }
    }

    private void isValidPourUneOuPlusieursDates(List<ContratColDTO> produits, RegleSaisieDTO r, VerifRegleSaisieResultDTO res) {
        ArrayList<String> ls = new ArrayList<String>();
        List<ContratLigDTO> dates = this.computeDates(r);
        this.checkOneRegle(produits, dates, r, ls, "");
        if (ls.size() != 0) {
            VerifRegleSaisieResultDTO.ResultDTO x = new VerifRegleSaisieResultDTO.ResultDTO();
            x.regleSaisieDTO = r;
            x.msgs = ls;
            res.errors.add(x);
        }
    }

    private List<ContratLigDTO> computeDates(RegleSaisieDTO r) {
        switch (r.contrainteDate) {
            case POUR_UNE_DATE: 
            case POUR_PLUSIEURS_DATES: {
                return this.findContratLigDTOs(r.modeleContratDateIds);
            }
            case POUR_TOUT_CONTRAT: {
                return this.contratDTO.contratLigs;
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<ContratLigDTO> findContratLigDTOs(List<IdContainer> modeleContratDateIds) {
        return this.contratDTO.contratLigs.stream().filter(e -> this.isInList(modeleContratDateIds, e.modeleContratDateId)).collect(Collectors.toList());
    }

    private List<ContratColDTO> computeProduits(RegleSaisieDTO r) {
        switch (r.contrainteProduit) {
            case POUR_UN_PRODUIT: 
            case POUR_PLUSIEURS_PRODUITS: {
                return this.findContratColDTOs(r.produitIds);
            }
            case POUR_TOUS_PRODUITS: {
                return this.contratDTO.contratColumns;
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<ContratColDTO> findContratColDTOs(List<IdContainer> produitIds) {
        return this.contratDTO.contratColumns.stream().filter(e -> this.isInList(produitIds, e.produitId)).collect(Collectors.toList());
    }

    private boolean isInList(List<IdContainer> ids, Long id) {
        return ids.stream().anyMatch(e -> e.id.equals(id));
    }

    private void checkOneRegle(List<ContratColDTO> produits, List<ContratLigDTO> dates, RegleSaisieDTO r, List<String> res, String context) {
        int qte = this.getQteTotal(produits, dates);
        boolean ret = this.isValidOperateurVal(r, qte);
        if (!ret) {
            res.add(String.valueOf(context) + " Quantit\u00e9 r\u00e9elle : " + qte);
        }
    }

    private boolean isValidOperateurVal(RegleSaisieDTO r, int qte) {
        switch (r.contrainteOperateur) {
            case EGAL: {
                return qte == r.val;
            }
            case INFERIEUR_OU_EGAL: {
                return qte <= r.val;
            }
            case SUPERIEUR_OU_EGAL: {
                return qte >= r.val;
            }
            case MULTIPLE_DE: {
                return qte % r.val == 0;
            }
        }
        throw new AmapjRuntimeException();
    }

    private int getQteTotal(List<ContratColDTO> colProduits, List<ContratLigDTO> ligDates) {
        int qteTotale = 0;
        int j = 0;
        while (j < colProduits.size()) {
            int cellJindex = colProduits.get((int)j).j;
            int i = 0;
            while (i < ligDates.size()) {
                int cellIindex = ligDates.get((int)i).i;
                qteTotale += this.contratDTO.cell[cellIindex][cellJindex].qte;
                ++i;
            }
            ++j;
        }
        return qteTotale;
    }

    private int getMntTotal(List<ContratColDTO> colProduits, List<ContratLigDTO> ligDates) {
        int mnt = 0;
        int j = 0;
        while (j < colProduits.size()) {
            int cellJindex = colProduits.get((int)j).j;
            int prix = colProduits.get((int)cellJindex).prix;
            int i = 0;
            while (i < ligDates.size()) {
                int cellIindex = ligDates.get((int)i).i;
                mnt += this.contratDTO.cell[cellIindex][cellJindex].qte * prix;
                ++i;
            }
            ++j;
        }
        return mnt;
    }
}

