/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.gestioncontratsigne;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.collections.G2D;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.fichierbase.Produit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class InfoBarrerProduitDTO {
    public List<CellChange> cellChanges = new ArrayList<CellChange>();

    public void addCellChange(DiffState state, ModeleContratDate modeleContratDate, ModeleContratProduit modeleContratProduit) {
        this.cellChanges.add(new CellChange(state, modeleContratDate, modeleContratProduit));
    }

    public String computeStringInfo() {
        G2D<Produit, DiffState, CellChange> c1 = new G2D<Produit, DiffState, CellChange>();
        c1.fill(this.cellChanges);
        c1.groupByLig(e -> e.modeleContratProduit.produit);
        c1.groupByCol(e -> e.state);
        c1.sortLigAdvanced(e -> e.modeleContratProduit.indx, true);
        c1.sortCol(e -> e, true);
        c1.sortCell(e -> e.modeleContratDate.dateLiv, true);
        c1.compute();
        StringBuilder buf = new StringBuilder();
        List produits = c1.getLigs();
        buf.append(String.valueOf(produits.size()) + " produits sont impact\u00e9s : <br/><ul>");
        int i = 0;
        while (i < produits.size()) {
            Produit produit = (Produit)produits.get(i);
            List noMoreDispo = c1.findCellContent(i, DiffState.NO_MORE_DISPO);
            List nowDispo = c1.findCellContent(i, DiffState.NOW_DISPO);
            if (noMoreDispo.size() > 0) {
                List<Date> noMoreDispoDates = CollectionUtils.convert(noMoreDispo, e -> e.modeleContratDate.dateLiv);
                buf.append("<li>" + produit.nom + "," + produit.conditionnement + " n'est plus disponible " + FormatUtils.listeDate(noMoreDispoDates) + "</li>");
            }
            if (nowDispo.size() > 0) {
                List<Date> nowDispoDates = CollectionUtils.convert(nowDispo, e -> e.modeleContratDate.dateLiv);
                buf.append("<li>" + produit.nom + "," + produit.conditionnement + " est maintenant disponible " + FormatUtils.listeDate(nowDispoDates) + "</li>");
            }
            ++i;
        }
        buf.append("</ul>");
        return buf.toString();
    }

    public static class CellChange {
        public DiffState state;
        public ModeleContratDate modeleContratDate;
        public ModeleContratProduit modeleContratProduit;

        public CellChange(DiffState state, ModeleContratDate modeleContratDate, ModeleContratProduit modeleContratProduit) {
            this.state = state;
            this.modeleContratDate = modeleContratDate;
            this.modeleContratProduit = modeleContratProduit;
        }
    }

    public static enum DiffState {
        NO_MORE_DISPO,
        NOW_DISPO;

    }
}

