/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.logview;

import fr.amapj.common.DateUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.saas.LogAccess;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.engine.deamons.DeamonsUtils;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LogDeleteService
implements Job {
    private static final Logger logger = LogManager.getLogger();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        DeamonsUtils.executeAsDeamonInMaster(this.getClass(), e -> this.deleteOldLogFiles(), e -> this.deleteOldLogAccess());
    }

    @DbWrite
    public void deleteOldLogFiles() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            logger.info("Debut de l'effacement des fichiers de logs");
            int nbFile = 0;
            Query q = em.createQuery("select a from LogAccess a where  ( (a.dateOut<=:d1 and a.nbError=0) or (a.dateOut<=:d2 and a.nbError>0) )  and a.logFileName is not null");
            Date now = DateUtils.getDate();
            Date d1 = DateUtils.addDays(now, -30);
            Date d2 = DateUtils.addDays(now, -90);
            q.setParameter("d1", (Object)d1);
            q.setParameter("d2", (Object)d2);
            List ps = q.getResultList();
            for (LogAccess logAccess : ps) {
                this.deleteLogFile(logAccess);
                logAccess.logFileName = null;
                ++nbFile;
            }
            logger.info("Fin de l'effacement des fichiers de logs. " + nbFile + " fichiers effac\u00e9s.");
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void deleteLogFile(LogAccess logAccess) {
        try {
            Path path = Paths.get(AmapJLogManager.getFullFileName(logAccess.logFileName), new String[0]);
            Files.delete(path);
        }
        catch (IOException e) {
            logger.error("Impossible d'effacer le fichier de log : " + StackUtils.asString(e));
        }
    }

    @DbWrite
    public void deleteOldLogAccess() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            logger.info("Debut de l'effacement des LogAccess dans la base master");
            Query q = em.createQuery("select a from LogAccess a where  ( (a.dateOut<=:d1 and a.typLog=:typLog1) or (a.dateOut<=:d2 and a.typLog=:typLog2) )  and a.logFileName is null");
            Date now = DateUtils.getDate();
            Date d1 = DateUtils.addDays(now, -30);
            Date d2 = DateUtils.addDays(now, -90);
            q.setParameter("d1", (Object)d1);
            q.setParameter("typLog1", (Object)TypLog.DEAMON);
            q.setParameter("d2", (Object)d2);
            q.setParameter("typLog2", (Object)TypLog.USER);
            int nb = SQLUtils.deleteAll(em, q);
            logger.info("Fin de l'effacement des LogAcess de logs. " + nb + " lignes effac\u00e9es.");
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void cleanLogFile() {
        NewTransaction.writeInMaster(em -> this.cleanLogFile((RdbLink)em));
    }

    private void cleanLogFile(RdbLink em) {
        Query q = em.createQuery("select a from LogAccess a where a.dateOut is null");
        List ps = q.getResultList();
        Date ref = DateUtils.getDate();
        for (LogAccess logAccess : ps) {
            logAccess.dateOut = ref;
            logAccess.activityTime = 60;
        }
    }
}

