/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.logview;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.param.ChoixOnOff;
import fr.amapj.model.models.saas.LogAccess;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.service.services.logview.LogViewDTO;
import fr.amapj.service.services.logview.StatAccessDTO;
import fr.amapj.service.services.logview.StatInstanceDTO;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogViewService {
    private static final Logger logger = LogManager.getLogger();

    public LogAccessDTO saveAccess(String nom, String prenom, Long idUtilisateur, String ip, String browser, String dbName, TypLog typLog, boolean sudo) {
        return NewTransaction.writeInMasterWithResult(em -> {
            String fileName;
            LogAccess logAccess = new LogAccess();
            logAccess.nom = nom;
            logAccess.prenom = prenom;
            logAccess.idUtilisateur = idUtilisateur;
            logAccess.ip = ip;
            logAccess.browser = browser;
            logAccess.dbName = dbName;
            logAccess.dateIn = DateUtils.getDate();
            logAccess.typLog = typLog;
            logAccess.sudo = sudo ? 1 : 0;
            em.persist(logAccess);
            logAccess.logFileName = fileName = AmapJLogManager.createLogFileName(dbName, logAccess.getId(), logAccess.dateIn, typLog);
            String d = new SimpleDateFormat("dd/MM/yyyy").format(logAccess.dateIn);
            if (typLog == TypLog.USER) {
                logger.info("Authentification r\u00e9ussie pour nom={} prenom={} id={} date={}", (Object)nom, (Object)prenom, (Object)idUtilisateur, (Object)d);
            } else {
                logger.info("D\u00e9marrage du d\u00e9mon nom={}  dbName={} date={}", (Object)nom, (Object)dbName, (Object)d);
            }
            LogAccessDTO dto = this.createLogAccessDTO(logAccess);
            return dto;
        });
    }

    public void endAccess(Long idLogAccess, int nbError) {
        NewTransaction.writeInMaster(em -> {
            int nbSec;
            LogAccess logAccess = em.find(LogAccess.class, idLogAccess);
            logAccess.dateOut = DateUtils.getDate();
            logAccess.activityTime = nbSec = (int)((logAccess.dateOut.getTime() - logAccess.dateIn.getTime()) / 1000L);
            if (logAccess.nbError < nbError) {
                logAccess.nbError = nbError;
            }
        });
    }

    private LogAccessDTO createLogAccessDTO(LogAccess logAccess) {
        LogAccessDTO dto = new LogAccessDTO();
        dto.browser = logAccess.browser;
        dto.dateIn = logAccess.dateIn;
        dto.dateOut = logAccess.dateOut;
        dto.dbName = logAccess.dbName;
        dto.id = logAccess.getId();
        dto.idUtilisateur = logAccess.idUtilisateur;
        dto.ip = logAccess.ip;
        dto.logFileName = logAccess.logFileName;
        dto.nom = logAccess.nom;
        dto.prenom = logAccess.prenom;
        dto.typLog = logAccess.typLog;
        dto.nbError = logAccess.nbError;
        dto.sudo = logAccess.sudo == 0 ? "" : "SUDO";
        return dto;
    }

    @DbRead
    public List<LogAccessDTO> getLogs(LogViewDTO req) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            ArrayList<LogAccessDTO> res = new ArrayList<LogAccessDTO>();
            RdbLink em = RdbLink.get();
            String filter = this.getFilter(req);
            Query q = em.createQuery("select a from LogAccess a " + filter + " order by a.dateIn desc");
            this.updateQuery(req, q);
            List ps = q.getResultList();
            if (ps.size() > 2000) {
                throw new AmapjRuntimeException("Le nombre de lignes est trop important:" + ps.size());
            }
            for (LogAccess p : ps) {
                LogAccessDTO dto = this.createLogAccessDTO(p);
                if (dto.dateOut == null) {
                    dto.nbError = SessionManager.getNbError(dto);
                }
                res.add(dto);
            }
            ArrayList<LogAccessDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String getFilter(LogViewDTO req) {
        ArrayList<String> strs = new ArrayList<String>();
        if (req.nom != null && req.nom.length() > 0) {
            strs.add("a.nom=:nom");
        }
        if (req.dbName != null && req.dbName.length() > 0) {
            strs.add("a.dbName=:dbName");
        }
        if (req.status != null) {
            if (req.status == ChoixOnOff.OFF) {
                strs.add("a.dateOut is not null");
            } else {
                strs.add("a.dateOut is null");
            }
        }
        if (req.typLog != null) {
            strs.add("a.typLog=:typLog");
        }
        if (req.ip != null && req.ip.length() > 0) {
            strs.add("a.ip=:ip");
        }
        if (req.dateMin != null) {
            strs.add("a.dateIn >= :dateMin");
        }
        if (req.dateMax != null) {
            strs.add("a.dateIn <= :dateMax");
        }
        if (req.nbError > 0) {
            strs.add("a.nbError >= :nbError");
        }
        if (strs.size() > 0) {
            return " where " + CollectionUtils.asString(strs, " and ");
        }
        return "";
    }

    private void updateQuery(LogViewDTO req, Query q) {
        if (req.nom != null && req.nom.length() > 0) {
            q.setParameter("nom", (Object)req.nom);
        }
        if (req.dbName != null && req.dbName.length() > 0) {
            q.setParameter("dbName", (Object)req.dbName);
        }
        if (req.typLog != null) {
            q.setParameter("typLog", (Object)req.typLog);
        }
        if (req.ip != null && req.ip.length() > 0) {
            q.setParameter("ip", (Object)req.ip);
        }
        if (req.dateMin != null) {
            q.setParameter("dateMin", (Object)req.dateMin);
        }
        if (req.dateMax != null) {
            q.setParameter("dateMax", (Object)req.dateMax);
        }
        if (req.nbError > 0) {
            q.setParameter("nbError", (Object)req.nbError);
        }
    }

    @DbRead
    public List<StatAccessDTO> getStats() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            ArrayList<StatAccessDTO> res = new ArrayList<StatAccessDTO>();
            RdbLink em = RdbLink.get();
            Query q = em.createNativeQuery("select to_char(l.dateIn,'YYYY-MM-DD') , count(l.id) , count(distinct(l.idUtilisateur,l.dbName)) , sum(l.activityTime) from LogAccess l where l.typLog = 'USER' group by to_char(l.dateIn,'YYYY-MM-DD') order by to_char(l.dateIn,'YYYY-MM-DD') desc");
            List ds = q.getResultList();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (Object[] s : ds) {
                try {
                    StatAccessDTO dto = new StatAccessDTO();
                    dto.date = df.parse((String)s[0]);
                    dto.nbAcces = LongUtils.toInt(s[1]);
                    dto.nbVisiteur = LongUtils.toInt(s[2]);
                    dto.tempsTotal = LongUtils.toInt(s[3]) / 60;
                    res.add(dto);
                }
                catch (ParseException e) {
                    throw new AmapjRuntimeException(e);
                }
            }
            ArrayList<StatAccessDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<StatInstanceDTO> getStatInstance() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            ArrayList<StatInstanceDTO> res = new ArrayList<StatInstanceDTO>();
            RdbLink em = RdbLink.get();
            Date ref1 = DateUtils.getDateWithNoTime();
            ref1 = DateUtils.addDays(ref1, 1);
            Date ref2 = DateUtils.addDays(ref1, -30);
            Date ref3 = DateUtils.addDays(ref1, -60);
            Date ref4 = DateUtils.addDays(ref1, -90);
            Query q = em.createQuery("select l from LogAccess l where l.typLog = :typLog and l.dateIn>:d2");
            q.setParameter("typLog", (Object)TypLog.USER);
            q.setParameter("d2", ref4, TemporalType.TIMESTAMP);
            List c1s = q.getResultList();
            q = em.createQuery("select l from LogAccess l where l.typLog = :typLog and l.dateIn>:d2 and l.nbError >0");
            q.setParameter("typLog", (Object)TypLog.DEAMON);
            q.setParameter("d2", ref2, TemporalType.TIMESTAMP);
            List c2s = q.getResultList();
            ArrayList cs = new ArrayList();
            cs.addAll(c1s);
            cs.addAll(c2s);
            G1D<String, Object> c1 = new G1D<String, Object>();
            c1.fill(cs);
            c1.groupBy(e -> e.dbName);
            c1.compute();
            List dbNames = c1.getKeys();
            int i = 0;
            while (i < dbNames.size()) {
                String dbName = (String)dbNames.get(i);
                List<LogAccess> cells = c1.getCell(i);
                StatInstanceDTO dto = this.creatStatInstanceDTO(dbName, cells, ref1, ref2, ref3, ref4);
                res.add(dto);
                ++i;
            }
            CollectionUtils.sort(res, e -> e.detail[0].nbAccess, false);
            ArrayList<StatInstanceDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private StatInstanceDTO creatStatInstanceDTO(String dbName, List<LogAccess> cells, Date ref1, Date ref2, Date ref3, Date ref4) {
        StatInstanceDTO dto = new StatInstanceDTO();
        dto.nomInstance = dbName;
        dto.detail = new StatInstanceDTO.Detail[3];
        List<LogAccess> users = CollectionUtils.filter(cells, e -> e.typLog == TypLog.USER);
        List<LogAccess> deamons = CollectionUtils.filter(cells, e -> e.typLog == TypLog.DEAMON);
        dto.detail[0] = this.getDetail(this.select(users, ref2, ref1));
        dto.detail[1] = this.getDetail(this.select(users, ref3, ref2));
        dto.detail[2] = this.getDetail(this.select(users, ref4, ref3));
        dto.erreurDemon = CollectionUtils.accumulateInt(deamons, e -> e.nbError);
        dto.erreurUser = CollectionUtils.accumulateInt(users, e -> e.nbError);
        return dto;
    }

    private List<LogAccess> select(List<LogAccess> ls, Date debut, Date fin) {
        return CollectionUtils.filter(ls, e -> this.isIn((LogAccess)e, debut, fin));
    }

    private boolean isIn(LogAccess l, Date debut, Date fin) {
        return l.dateIn.after(debut) && (l.dateIn.before(fin) || l.dateIn.equals(fin));
    }

    private StatInstanceDTO.Detail getDetail(List<LogAccess> ls) {
        StatInstanceDTO.Detail d = new StatInstanceDTO.Detail();
        d.nbAccess = ls.size();
        d.nbVisiteur = CollectionUtils.selectDistinct(ls, e -> e.idUtilisateur).size();
        return d;
    }
}

