/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mailer;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.FileInfoDTO;
import java.io.File;
import java.io.IOException;
import javax.activation.FileTypeMap;
import org.apache.commons.io.FileUtils;

public class MailerAttachement {
    private byte[] data;
    private String name;
    private String mimeType;

    public MailerAttachement(File file) {
        this.mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
        this.name = file.getName();
        try {
            this.data = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new AmapjRuntimeException("", e);
        }
    }

    public MailerAttachement(CoreGenerator generator) {
        CoreGeneratorService excelGeneratorService = new CoreGeneratorService();
        FileInfoDTO fileInfo = excelGeneratorService.getFileInfo(generator);
        this.name = String.valueOf(fileInfo.fileName) + "." + fileInfo.extension;
        this.data = generator.getByteArrayContent();
        this.mimeType = this.computeMimeType(fileInfo.extension);
    }

    private String computeMimeType(String extension) {
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        if (extension.equals("xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (extension.equals("zip")) {
            return "application/zip";
        }
        if (extension.equals("pdf")) {
            return "application/pdf";
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

