/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mailer;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.messagingcenter.miniproxy.TNProxyClient;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import fr.amapj.messagingcenter.miniproxy.model.mailer.RemoteMailerAttachement;
import fr.amapj.messagingcenter.miniproxy.model.mailer.RemoteMailerMessage;
import fr.amapj.messagingcenter.miniproxy.model.mailer.request.SendMailRequest;
import fr.amapj.messagingcenter.miniproxy.model.mailer.response.SendMailResponse;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.service.services.mailer.MailerAttachement;
import fr.amapj.service.services.mailer.MailerCounter;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerStorage;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailerService {
    private static final Logger logger = LogManager.getLogger();
    public static final String HTML_MAIL_HEADER = "<html><head></head><body>";
    public static final String HTML_MAIL_FOOTER = "</body></html>";

    public void sendHtmlMail(MailerMessage mailerMessage) {
        ParametresDTO param = new ParametresService().getParametres();
        if (!MailerCounter.isAllowed(param)) {
            throw new AmapjRuntimeException("Impossible d'envoyer un mail car le quota par jour est d\u00e9pass\u00e9 (quota = " + param.sendingMailNbMax + " )");
        }
        String username = param.getSendingMailUsername();
        if (username == null || username.length() == 0) {
            throw new AmapjRuntimeException("Le service mail n'est pas param\u00e9tr\u00e9 : absence de l'adresse d'envoi");
        }
        RemoteMailerMessage rmm = new RemoteMailerMessage();
        rmm.fromAddress = param.sendingMailUsername;
        rmm.fromPersonalName = param.nomAmap;
        rmm.recipentsTo = mailerMessage.getEmail();
        rmm.recipentsCc = null;
        rmm.recipentsBcc = param.mailCopyTo;
        rmm.title = mailerMessage.getTitle();
        rmm.htmlContent = this.buildHtlmContent(mailerMessage, param);
        for (MailerAttachement ma : mailerMessage.getAttachements()) {
            RemoteMailerAttachement rma = new RemoteMailerAttachement();
            rma.contentType = ma.getMimeType();
            rma.data = ma.getData();
            rma.name = ma.getName();
            rmm.addAttachement(rma);
        }
        AppConfiguration.MailConfig mailTarget = AppConfiguration.getConf().getMailConfig();
        logger.info("D\u00e9but envoi d'un message dest= : " + mailerMessage.getEmail() + " en utilisant le mecanisme " + (Object)((Object)mailTarget));
        try {
            switch (mailTarget) {
                case GMAIL: {
                    this.sendGmail(param, rmm);
                    break;
                }
                case POSTFIX_LOCAL: {
                    this.sendPostFix(param, rmm);
                    break;
                }
                case MESSAGING_CENTER: {
                    this.sendMessagingCenter(param, rmm);
                    break;
                }
                case STORAGE: {
                    this.sendStorage(param, rmm);
                    break;
                }
                case NO_MAIL: {
                    this.sendNoMail();
                    break;
                }
                default: {
                    throw new AmapjRuntimeException();
                }
            }
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            throw new RuntimeException("Le service n'est pas disponible. Merci de r\u00e9essayer plus tard.");
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        logger.info("Message envoy\u00e9 avec succ\u00e9s");
    }

    private void sendGmail(ParametresDTO param, RemoteMailerMessage rmm) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = new MimeMessage(this.getGmailSession(param));
        rmm.fillMessage((Message)message);
        Transport.send((Message)message);
    }

    private Session getGmailSession(ParametresDTO param) {
        final String username = param.getSendingMailUsername();
        final String password = param.getSendingMailPassword();
        if (password == null || password.length() == 0) {
            throw new AmapjRuntimeException("Le service mail n'est pas param\u00e9tr\u00e9 correctement: absence du mot de passe");
        }
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", "smtp.gmail.com");
        props.put("mail.smtp.port", "587");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        return session;
    }

    private void sendPostFix(ParametresDTO param, RemoteMailerMessage rmm) throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", "127.0.0.1");
        Session session = Session.getInstance((Properties)props);
        MimeMessage message = new MimeMessage(session);
        rmm.fillMessage((Message)message);
        Transport.send((Message)message);
    }

    private void sendMessagingCenter(ParametresDTO param, RemoteMailerMessage rmm) throws ServiceNotAvailableException {
        SendMailRequest request = new SendMailRequest();
        request.dbName = DbManager.get().getCurrentDb().getDbName();
        request.message = rmm;
        SendMailResponse response = this.getProxy().sendMail(request);
        if (response.error != null) {
            throw new AmapjRuntimeException(response.error);
        }
    }

    private TNProxyClient getProxy() {
        AppConfiguration conf = AppConfiguration.getConf();
        return new TNProxyClient(conf.getMessagingCenterKey(), conf.getMessagingCenterUrl());
    }

    private void sendNoMail() {
    }

    private void sendStorage(ParametresDTO param, RemoteMailerMessage rmm) {
        MailerStorage.store(rmm);
    }

    private String buildHtlmContent(MailerMessage mailerMessage, ParametresDTO param) {
        StringBuilder sb = new StringBuilder();
        sb.append(HTML_MAIL_HEADER);
        sb.append(mailerMessage.getContent());
        if (param.sendingMailFooter != null && param.sendingMailFooter.length() > 0) {
            sb.append("<br/><br/>");
            sb.append(param.sendingMailFooter);
        }
        sb.append(HTML_MAIL_FOOTER);
        return sb.toString();
    }

    public static void main(String[] args) {
        TestTools.init();
        MailerMessage message = new MailerMessage("essai@gmail.com", "essai", "<h1>This is actual message</h1>");
        new MailerService().sendHtmlMail(message);
    }
}

