/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mescontrats;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.AffichageMontant;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.SaisiePaiementModifiable;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.service.services.mescontrats.DatePaiementDTO;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class InfoPaiementDTO {
    public List<DatePaiementDTO> datePaiements = new ArrayList<DatePaiementDTO>();
    public GestionPaiement gestionPaiement;
    public SaisiePaiementModifiable saisiePaiementModifiable;
    public SaisiePaiementProposition saisiePaiementProposition;
    public int montantChequeMiniCalculProposition;
    public String textPaiement;
    public AffichageMontant affichageMontant;
    public int avoirInitial;
    public String libCheque;
    public List<ProdUtilisateurDTO> referentsRemiseCheque;

    public int getMontantNonModifiable() {
        int mnt = this.avoirInitial;
        for (DatePaiementDTO datePaiementDTO : this.datePaiements) {
            if (datePaiementDTO.isModifiable) continue;
            mnt += datePaiementDTO.montant;
        }
        return mnt;
    }

    public int getNbModifiable() {
        return (int)this.datePaiements.stream().filter(e -> e.isModifiable).count();
    }

    public DatePaiementDTO getLastModifiable() {
        int i = this.datePaiements.size() - 1;
        while (i >= 0) {
            DatePaiementDTO line = this.datePaiements.get(i);
            if (line.isModifiable) {
                return line;
            }
            --i;
        }
        return null;
    }

    public int getMontantPayeBefore(DatePaiementDTO line) {
        int mnt = this.avoirInitial;
        for (DatePaiementDTO datePaiementDTO : this.datePaiements) {
            if (datePaiementDTO == line) {
                return mnt;
            }
            mnt += datePaiementDTO.montant;
        }
        throw new AmapjRuntimeException();
    }

    public int getMontantTotalPaiement() {
        int mnt = this.avoirInitial;
        for (DatePaiementDTO datePaiementDTO : this.datePaiements) {
            mnt += datePaiementDTO.montant;
        }
        return mnt;
    }

    public Date getNextDatePaiement(DatePaiementDTO line) {
        int index = this.datePaiements.indexOf(line);
        if (index < this.datePaiements.size() - 1) {
            return this.datePaiements.get((int)(index + 1)).datePaiement;
        }
        return null;
    }

    public List<DatePaiementDTO> getAllModifiableLineExceptLast() {
        List<DatePaiementDTO> ls = this.datePaiements.stream().filter(e -> e.isModifiable).collect(Collectors.toList());
        ls.remove(ls.size() - 1);
        return ls;
    }

    public boolean isLastLineModifiable(DatePaiementDTO datePaiement) {
        return this.getLastModifiable() == datePaiement;
    }
}

