/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.mespaiements;

import fr.amapj.common.LongUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.mespaiements.DetailPaiementAFournirDTO;
import fr.amapj.service.services.mespaiements.DetailPaiementFourniDTO;
import fr.amapj.service.services.mespaiements.MesPaiementsDTO;
import fr.amapj.service.services.mespaiements.PaiementAFournirDTO;
import fr.amapj.service.services.mespaiements.PaiementFourniDTO;
import fr.amapj.service.services.mespaiements.PaiementHistoriqueDTO;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class MesPaiementsService {
    @DbRead
    public MesPaiementsDTO getMesPaiements(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            MesPaiementsDTO res = new MesPaiementsDTO();
            Utilisateur user = em.find(Utilisateur.class, userId);
            res.paiementAFournir = this.getPaiementAFournir(em, user);
            res.paiementFourni = this.getPaiementFourni(em, user);
            res.paiementHistorique = this.getPaiementHistorique(em, user);
            MesPaiementsDTO mesPaiementsDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return mesPaiementsDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<PaiementAFournirDTO> getPaiementAFournir(RdbLink em, Utilisateur user) {
        ArrayList<PaiementAFournirDTO> res = new ArrayList<PaiementAFournirDTO>();
        Query q = em.createQuery("select c from Contrat c WHERE c.utilisateur=:u AND c.modeleContrat.etat<>:etatContrat AND EXISTS ( select p from Paiement p where p.etat=:etat and p.contrat=c) order by c.modeleContrat.dateRemiseCheque asc , c.modeleContrat.nom , c.modeleContrat.id");
        q.setParameter("etatContrat", (Object)EtatModeleContrat.ARCHIVE);
        q.setParameter("etat", (Object)EtatPaiement.A_FOURNIR);
        q.setParameter("u", (Object)user);
        List cs = q.getResultList();
        for (Contrat contrat : cs) {
            PaiementAFournirDTO dto = new PaiementAFournirDTO();
            dto.dateRemise = contrat.modeleContrat.dateRemiseCheque;
            dto.libCheque = contrat.modeleContrat.libCheque;
            dto.nomContrat = contrat.modeleContrat.nom;
            dto.paiements = this.getPaiementAFournir(em, contrat);
            res.add(dto);
        }
        return res;
    }

    public List<DetailPaiementAFournirDTO> getPaiementAFournir(RdbLink em, Contrat contrat) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMM yyyy");
        ArrayList<DetailPaiementAFournirDTO> res = new ArrayList<DetailPaiementAFournirDTO>();
        Query q = em.createQuery("select p from Paiement p WHERE p.etat=:etat and p.contrat=:c order by p.montant asc , p.modeleContratDatePaiement.datePaiement asc");
        q.setParameter("etat", (Object)EtatPaiement.A_FOURNIR);
        q.setParameter("c", (Object)contrat);
        List ps = q.getResultList();
        for (Paiement paiement : ps) {
            String datePaiement = df.format(paiement.modeleContratDatePaiement.datePaiement);
            if (this.lastMatch(res, paiement)) {
                DetailPaiementAFournirDTO last = (DetailPaiementAFournirDTO)res.get(res.size() - 1);
                ++last.nbCheque;
                last.datePaiements = String.valueOf(last.datePaiements) + ", " + datePaiement;
                continue;
            }
            DetailPaiementAFournirDTO dto = new DetailPaiementAFournirDTO();
            dto.nbCheque = 1;
            dto.datePaiements = datePaiement;
            dto.montant = paiement.montant;
            res.add(dto);
        }
        return res;
    }

    private boolean lastMatch(List<DetailPaiementAFournirDTO> res, Paiement paiement) {
        if (res.size() == 0) {
            return false;
        }
        DetailPaiementAFournirDTO last = res.get(res.size() - 1);
        return last.montant == paiement.montant;
    }

    private List<PaiementFourniDTO> getPaiementFourni(RdbLink em, Utilisateur user) {
        SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
        ArrayList<PaiementFourniDTO> res = new ArrayList<PaiementFourniDTO>();
        Query q = em.createQuery("select p from Paiement p WHERE p.etat<>:etat and p.contrat.utilisateur=:u AND p.contrat.modeleContrat.etat<>:etatModeleContrat order by p.modeleContratDatePaiement.datePaiement, p.modeleContratDatePaiement.modeleContrat.nom , p.modeleContratDatePaiement.modeleContrat.id");
        q.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
        q.setParameter("etatModeleContrat", (Object)EtatModeleContrat.ARCHIVE);
        q.setParameter("u", (Object)user);
        List ps = q.getResultList();
        for (Paiement paiement : ps) {
            DetailPaiementFourniDTO detail = this.createDetail(paiement);
            String datePaiement = df.format(paiement.modeleContratDatePaiement.datePaiement);
            if (this.lastMatch(res, datePaiement)) {
                PaiementFourniDTO last = (PaiementFourniDTO)res.get(res.size() - 1);
                last.paiements.add(detail);
                last.totalMois += detail.montant;
                continue;
            }
            PaiementFourniDTO dto = new PaiementFourniDTO();
            dto.moisPaiement = datePaiement;
            dto.totalMois = detail.montant;
            dto.paiements.add(detail);
            res.add(dto);
        }
        return res;
    }

    private boolean lastMatch(List<PaiementFourniDTO> res, String datePaiement) {
        if (res.size() == 0) {
            return false;
        }
        PaiementFourniDTO last = res.get(res.size() - 1);
        return last.moisPaiement.equals(datePaiement);
    }

    private DetailPaiementFourniDTO createDetail(Paiement paiement) {
        DetailPaiementFourniDTO dto = new DetailPaiementFourniDTO();
        dto.libCheque = paiement.contrat.modeleContrat.libCheque;
        dto.nomContrat = paiement.contrat.modeleContrat.nom;
        dto.montant = paiement.montant;
        dto.etatPaiement = paiement.etat;
        dto.datePaiement = paiement.modeleContratDatePaiement.datePaiement;
        return dto;
    }

    private List<PaiementHistoriqueDTO> getPaiementHistorique(RdbLink em, Utilisateur user) {
        ArrayList<PaiementHistoriqueDTO> res = new ArrayList<PaiementHistoriqueDTO>();
        Query q = em.createQuery("select p from Paiement p  WHERE p.etat=:etat and p.contrat.utilisateur=:u order by p.id");
        q.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
        q.setParameter("u", (Object)user);
        List ps = q.getResultList();
        for (Paiement paiement : ps) {
            PaiementHistoriqueDTO dto = new PaiementHistoriqueDTO();
            dto.id = paiement.getId();
            dto.nomProducteur = paiement.contrat.modeleContrat.producteur.nom;
            dto.nomContrat = paiement.contrat.modeleContrat.nom;
            dto.montant = paiement.montant;
            dto.datePrevu = paiement.modeleContratDatePaiement.datePaiement;
            dto.dateReelle = paiement.remise.dateRemise;
            res.add(dto);
        }
        return res;
    }

    @DbRead
    public String chercherChequeARendre(Long mcId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            ModeleContrat mc = em.find(ModeleContrat.class, mcId);
            Query q = em.createQuery("select c from Contrat c where  c.modeleContrat=:mc  order by c.utilisateur.nom, c.utilisateur.prenom");
            q.setParameter("mc", (Object)mc);
            List contrats = q.getResultList();
            for (Contrat contrat : contrats) {
                this.chercherChequeARendre(em, contrat, buf);
            }
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void chercherChequeARendre(RdbLink em, Contrat contrat, StringBuffer buf) {
        int mntCommande = new GestionContratSigneService().getMontant(em, contrat);
        int mntDonneAmap = this.getMontantDonneAMAP(contrat, em);
        List<Paiement> paiements = this.getPaiementALAMAP(contrat, em);
        if (mntDonneAmap > mntCommande && paiements.size() > 0) {
            Utilisateur u = contrat.utilisateur;
            SimpleDateFormat df = new SimpleDateFormat("MMMMM yyyy");
            buf.append("L'adh\u00e9rent " + u.nom + " " + u.prenom + " a un trop pay\u00e9 de " + new CurrencyTextFieldConverter().convertToString(mntDonneAmap - mntCommande) + " \u20ac<br/>");
            buf.append("Vous avez en votre possession ces ch\u00e8ques, que vous pouvez rendre ou faire refaire:<br/>");
            for (Paiement paiement : paiements) {
                buf.append(" - " + df.format(paiement.modeleContratDatePaiement.datePaiement) + " - " + new CurrencyTextFieldConverter().convertToString(paiement.montant) + "\u20ac <br/>");
            }
            buf.append("<br/>");
        }
    }

    private int getMontantDonneAMAP(Contrat contrat, RdbLink em) {
        Query q = em.createQuery("select sum(p.montant) from Paiement p  WHERE (p.etat=:e1 OR p.etat=:e2) and p.contrat=:c ");
        q.setParameter("e1", (Object)EtatPaiement.AMAP);
        q.setParameter("e2", (Object)EtatPaiement.PRODUCTEUR);
        q.setParameter("c", (Object)contrat);
        int mnt1 = LongUtils.toInt(q.getSingleResult());
        int avoir = contrat.montantAvoir;
        return mnt1 + avoir;
    }

    private List<Paiement> getPaiementALAMAP(Contrat contrat, RdbLink em) {
        Query q = em.createQuery("select p from Paiement p  WHERE p.etat=:etat and p.contrat=:c order by p.modeleContratDatePaiement.datePaiement");
        q.setParameter("etat", (Object)EtatPaiement.AMAP);
        q.setParameter("c", (Object)contrat);
        List paiements = q.getResultList();
        return paiements;
    }

    public int getNbChequeContrat(Contrat contrat, RdbLink em) {
        Query q = em.createQuery("select count(p) from Paiement p  WHERE p.contrat=:c ");
        q.setParameter("c", (Object)contrat);
        return LongUtils.toInt(q.getSingleResult());
    }

    public int getMontantChequeSansAvoir(Contrat contrat, RdbLink em) {
        Query q = em.createQuery("select sum(p.montant) from Paiement p  where p.contrat=:c ");
        q.setParameter("c", (Object)contrat);
        int mnt1 = LongUtils.toInt(q.getSingleResult());
        return mnt1;
    }
}

