/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.daily;

import fr.amapj.common.DateUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.fichierbase.EtatNotification;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurReferent;
import fr.amapj.model.models.fichierbase.ProducteurUtilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.edgenerator.zip.ZGAllDocEngagementModeleContrat;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.mailer.MailerAttachement;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DocEngagementNotificationService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public void sendDocEngagementNotification(DeamonsContext deamonsContext) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select mc from ModeleContrat mc where mc.etat<>:etat AND mc.gestionDocEngagement=:g AND mc.notificationDoneDocEngagement=:notif");
            em.setParameter("etat", (Object)EtatModeleContrat.CREATION);
            em.setParameter("g", (Object)GestionDocEngagement.SIGNATURE_EN_LIGNE);
            em.setParameter("notif", (Object)ChoixOuiNon.NON);
            List<ModeleContrat> mcs = em.result().list(ModeleContrat.class);
            for (ModeleContrat mc : mcs) {
                logger.info("Debut de traitement : " + mc.nom);
                try {
                    this.processModeleContrat(em, mc, deamonsContext);
                }
                catch (Exception e) {
                    ++deamonsContext.nbError;
                    logger.info("Erreur pour le contrat " + mc.nom + "\n" + StackUtils.asString(e));
                }
                logger.info("Fin de traitement : " + mc.nom);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void processModeleContrat(RdbLink em, ModeleContrat mc, DeamonsContext deamonsContext) {
        List<ModeleContratDate> dates = new GestionContratService().getAllDates(em, mc);
        ModeleContratDate fin = dates.get(dates.size() - 1);
        Date ref = DateUtils.addDays(DateUtils.getDate(), -15);
        if (fin.dateLiv.after(ref)) {
            logger.info("Le contrat n'est pas encore termin\u00e9");
            return;
        }
        String emails = this.getEmails(em, mc.producteur);
        MailerMessage message = new MailerMessage();
        ParametresDTO param = new ParametresService().getParametres();
        message.setTitle(String.valueOf(param.nomAmap) + " - Document d'engagement du contrat " + mc.nom);
        message.setContent(this.getMessageContent(mc, param));
        message.addAttachement(new MailerAttachement(new ZGAllDocEngagementModeleContrat(mc.id)));
        message.setEmail(emails);
        NewTransaction.write(em2 -> this.sendMessageAndMemorize((RdbLink)em2, message, modeleContrat.id));
    }

    private String getEmails(RdbLink em, Producteur producteur) {
        StringBuilder sb = new StringBuilder();
        List<ProducteurUtilisateur> us = new ProducteurService().getProducteurUtilisateur(em, producteur);
        for (ProducteurUtilisateur u : us) {
            if (u.notification != EtatNotification.AVEC_NOTIFICATION_MAIL || !UtilisateurUtil.canSendMailTo(u.utilisateur.email)) continue;
            sb.append(String.valueOf(u.utilisateur.email) + ";");
        }
        List<ProducteurReferent> rs = new ProducteurService().getProducteurReferent(em, producteur);
        for (ProducteurReferent r : rs) {
            if (r.notification != EtatNotification.AVEC_NOTIFICATION_MAIL || !UtilisateurUtil.canSendMailTo(r.referent.email)) continue;
            sb.append(String.valueOf(r.referent.email) + ";");
        }
        return sb.toString();
    }

    private void sendMessageAndMemorize(RdbLink em, MailerMessage message, Long modeleContratId) {
        ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
        mc.notificationDoneDocEngagement = ChoixOuiNon.OUI;
        new MailerService().sendHtmlMail(message);
    }

    private String getMessageContent(ModeleContrat mc, ParametresDTO param) {
        String link = param.getUrl();
        StringBuffer buf = new StringBuffer();
        buf.append("<h3>" + param.nomAmap + "-" + param.villeAmap + "</h3><br/>");
        buf.append("Bonjour ,");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Vous trouverez ci joint les documents d'engagement pour le contrat qui vient de se terminer.");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Nom du contrat : " + mc.nom);
        buf.append("<br/>");
        buf.append("Nom du producteur : " + mc.nom);
        buf.append("<br/>");
        buf.append("Ces documents sont \u00e0 conserver.");
        buf.append("<br/>");
        buf.append("Si vous souhaitez acc\u00e9der \u00e0 l'application : <a href=\"" + link + "\">Cliquez ici </a>");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Bonne journ\u00e9e !");
        buf.append("<br/>");
        buf.append("<br/>");
        return buf.toString();
    }
}

