/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.hourly.producteur;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.fichierbase.EtatNotification;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.stats.NotificationDone;
import fr.amapj.model.models.stats.TypNotificationDone;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGFeuilleDistributionProducteur;
import fr.amapj.service.services.mailer.MailerAttachement;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.mescontrats.ContratStatusService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProducteurFeuilleLivraisonNotificationService {
    private static final Logger logger = LogManager.getLogger();

    public void sendFeuilleLivraison(Producteur producteur, RdbLink em, DeamonsContext deamonsContext) {
        em.createQuery("select mcd from ModeleContratDate mcd where mcd.dateLiv>=:d1 and mcd.dateLiv<=:d2 and mcd.modeleContrat.producteur=:p");
        Date d1 = DateUtils.getDate();
        Date d2 = DateUtils.addDays(d1, producteur.delaiModifContrat);
        d2 = DateUtils.addHour(d2, -2);
        em.setParameter("d1", d1);
        em.setParameter("d2", d2);
        em.setParameter("p", producteur);
        ContratStatusService statusService = new ContratStatusService();
        List<ModeleContratDate> mcds = em.result().list(ModeleContratDate.class);
        for (ModeleContratDate modeleContratDate : mcds) {
            if (statusService.isDateModifiable(modeleContratDate, d1)) {
                SimpleDateFormat df = FormatUtils.getStdDate();
                logger.info("La notification du modele de contrat " + modeleContratDate.modeleContrat.nom + " n'a pas \u00e9t\u00e9 envoy\u00e9 car la date de livraison " + df.format(modeleContratDate.dateLiv) + " est encore modifiable.");
                continue;
            }
            List<Utilisateur> users = this.getUserToNotify(em, producteur, modeleContratDate);
            List<Utilisateur> referents = this.getReferentsToNotify(em, producteur, modeleContratDate);
            List<Object> dests = new ArrayList<Utilisateur>();
            dests.addAll(users);
            dests.addAll(referents);
            dests = CollectionUtils.filter(dests, u -> UtilisateurUtil.canSendMailTo(u.email));
            if (dests.size() <= 0) continue;
            this.sendOneMessageNotificationProducteur(modeleContratDate, dests, em, deamonsContext);
        }
    }

    private List<Utilisateur> getUserToNotify(RdbLink em, Producteur producteur, ModeleContratDate modeleContratDate) {
        em.createQuery("select c.utilisateur from ProducteurUtilisateur c WHERE c.producteur=:p AND c.notification=:etat AND NOT EXISTS (select d from NotificationDone d where d.typNotificationDone=:typNotif and d.utilisateur=c.utilisateur and d.modeleContratDate=:mcd) order by c.utilisateur.nom,c.utilisateur.prenom");
        em.setParameter("p", producteur);
        em.setParameter("etat", (Object)EtatNotification.AVEC_NOTIFICATION_MAIL);
        em.setParameter("typNotif", (Object)TypNotificationDone.FEUILLE_LIVRAISON_PRODUCTEUR);
        em.setParameter("mcd", modeleContratDate);
        return em.result().list(Utilisateur.class);
    }

    private List<Utilisateur> getReferentsToNotify(RdbLink em, Producteur producteur, ModeleContratDate modeleContratDate) {
        em.createQuery("select c.referent from ProducteurReferent c WHERE c.producteur=:p AND c.notification=:etat AND NOT EXISTS (select d from NotificationDone d where d.typNotificationDone=:typNotif and d.utilisateur=c.referent and d.modeleContratDate=:mcd) order by c.referent.nom,c.referent.prenom");
        em.setParameter("p", producteur);
        em.setParameter("etat", (Object)EtatNotification.AVEC_NOTIFICATION_MAIL);
        em.setParameter("typNotif", (Object)TypNotificationDone.FEUILLE_LIVRAISON_PRODUCTEUR);
        em.setParameter("mcd", modeleContratDate);
        return em.result().list(Utilisateur.class);
    }

    private void sendOneMessageNotificationProducteur(ModeleContratDate modeleContratDate, List<Utilisateur> users, RdbLink em, DeamonsContext deamonsContext) {
        MailerMessage message = new MailerMessage();
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        ParametresDTO param = new ParametresService().getParametres();
        message.setTitle(String.valueOf(param.nomAmap) + " - Feuille de livraison du " + df.format(modeleContratDate.dateLiv));
        message.setContent(this.getMessageContent(modeleContratDate, param, df));
        EGFeuilleDistributionProducteur generator = new EGFeuilleDistributionProducteur(modeleContratDate.modeleContrat.getId(), modeleContratDate.getId());
        message.addAttachement(new MailerAttachement(generator));
        for (Utilisateur utilisateur : users) {
            try {
                message.setEmail(utilisateur.email);
                this.sendMessageAndMemorize(message, modeleContratDate.getId(), utilisateur.getId());
            }
            catch (Exception e) {
                ++deamonsContext.nbError;
                logger.error("Erreur pour notifier  " + utilisateur.email + "\n" + StackUtils.asString(e));
            }
        }
    }

    private void sendMessageAndMemorize(MailerMessage message, Long modeleContratDateId, Long utilisateurId) {
        NewTransaction.write(em -> this.sendMessageAndMemorize((RdbLink)em, message, modeleContratDateId, utilisateurId));
    }

    protected void sendMessageAndMemorize(RdbLink em, MailerMessage message, Long modeleContratDateId, Long utilisateurId) {
        NotificationDone notificationDone = new NotificationDone();
        notificationDone.typNotificationDone = TypNotificationDone.FEUILLE_LIVRAISON_PRODUCTEUR;
        notificationDone.modeleContratDate = em.find(ModeleContratDate.class, modeleContratDateId);
        notificationDone.utilisateur = em.find(Utilisateur.class, utilisateurId);
        notificationDone.dateEnvoi = DateUtils.getDate();
        em.persist(notificationDone);
        new MailerService().sendHtmlMail(message);
    }

    private String getMessageContent(ModeleContratDate modeleContratDate, ParametresDTO param, SimpleDateFormat df) {
        String link = param.getUrl();
        StringBuffer buf = new StringBuffer();
        buf.append("<h3>" + param.nomAmap + "-" + param.villeAmap + "</h3><br/>");
        buf.append("Bonjour ,");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Vous trouverez ci joint la feuille de livraison pour le " + df.format(modeleContratDate.dateLiv));
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Nom du contrat : " + modeleContratDate.modeleContrat.nom);
        buf.append("<br/>");
        buf.append("Nom du producteur : " + modeleContratDate.modeleContrat.producteur.nom);
        buf.append("<br/>");
        buf.append("Si vous souhaitez acc\u00e9der \u00e0 l'application : <a href=\"" + link + "\">Cliquez ici </a>");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Bonne journ\u00e9e !");
        buf.append("<br/>");
        buf.append("<br/>");
        return buf.toString();
    }
}

