/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.notification.hourly.producteur;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.TypInscriptionContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurNotificationRetardataire;
import fr.amapj.model.models.stats.NotificationDone;
import fr.amapj.model.models.stats.TypNotificationDone;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.mescontrats.ContratStatusService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProducteurInscriptionRetardataireNotificationService {
    private static final Logger logger = LogManager.getLogger();

    public void sendInscriptionRetardataire(Producteur producteur, RdbLink em, DeamonsContext deamonsContext) {
        String emails = this.getAllUsersToNotify(em, producteur);
        if (emails.length() == 0) {
            return;
        }
        List<Contrat> cs = this.computeContratRetardataire(em, producteur);
        if (cs.size() == 0) {
            return;
        }
        this.sendOneMessage(cs, producteur, emails, em, deamonsContext);
    }

    private String getAllUsersToNotify(RdbLink em, Producteur producteur) {
        List<Object> res = new ArrayList();
        if (producteur.notificationRetardataire == ProducteurNotificationRetardataire.REFERENT || producteur.notificationRetardataire == ProducteurNotificationRetardataire.REFERENT_PRODUCTEUR) {
            res.addAll(new ProducteurService().getProducteurReferent(em, producteur).stream().map(e -> e.referent.email).collect(Collectors.toList()));
        }
        if (producteur.notificationRetardataire == ProducteurNotificationRetardataire.REFERENT_PRODUCTEUR) {
            res.addAll(new ProducteurService().getProducteurUtilisateur(em, producteur).stream().map(e -> e.utilisateur.email).collect(Collectors.toList()));
        }
        res = CollectionUtils.filter(res, u -> UtilisateurUtil.canSendMailTo(u));
        return CollectionUtils.asString(res, ",");
    }

    private List<Contrat> computeContratRetardataire(RdbLink em, Producteur producteur) {
        Date d1 = DateUtils.addDays(DateUtils.getDateWithNoTime(), -7);
        em.createQuery("select c from Contrat c WHERE c.modeleContrat.producteur=:p AND c.typInscriptionContrat=:typInscriptionContrat AND c.dateCreation>:d1 AND NOT EXISTS (select d from NotificationDone d where d.typNotificationDone=:typNotif and d.contrat=c) ");
        em.setParameter("p", producteur);
        em.setParameter("d1", d1);
        em.setParameter("typInscriptionContrat", (Object)TypInscriptionContrat.RETARDATAIRE);
        em.setParameter("typNotif", (Object)TypNotificationDone.INSCRIPTION_RETARDATAIRE);
        List<Contrat> cs = em.result().list(Contrat.class);
        ContratStatusService css = new ContratStatusService();
        Date d2 = DateUtils.addHour(DateUtils.getDate(), -2);
        return cs.stream().filter(e -> !css.isContratRetardataireModifiable((Contrat)e, d2)).collect(Collectors.toList());
    }

    private void sendOneMessage(List<Contrat> cs, Producteur producteur, String emails, RdbLink em, DeamonsContext deamonsContext) {
        MailerMessage message = new MailerMessage();
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        ParametresDTO param = new ParametresService().getParametres();
        message.setTitle(String.valueOf(param.nomAmap) + " - Notification inscription retardaire ");
        message.setContent(this.getMessageContent(cs, producteur, param, df));
        message.setEmail(emails);
        this.sendMessageAndMemorize(message, CollectionUtils.convert(cs, e -> e.id));
    }

    private void sendMessageAndMemorize(MailerMessage message, List<Long> contratIds) {
        NewTransaction.write(em -> this.sendMessageAndMemorize((RdbLink)em, message, contratIds));
    }

    protected void sendMessageAndMemorize(RdbLink em, MailerMessage message, List<Long> contratIds) {
        for (Long contratId : contratIds) {
            NotificationDone notificationDone = new NotificationDone();
            notificationDone.typNotificationDone = TypNotificationDone.INSCRIPTION_RETARDATAIRE;
            notificationDone.contrat = em.find(Contrat.class, contratId);
            notificationDone.dateEnvoi = DateUtils.getDate();
            em.persist(notificationDone);
        }
        new MailerService().sendHtmlMail(message);
    }

    private String getMessageContent(List<Contrat> cs, Producteur producteur, ParametresDTO param, SimpleDateFormat df) {
        String link = param.getUrl();
        StringBuffer buf = new StringBuffer();
        buf.append("<h3>" + param.nomAmap + "-" + param.villeAmap + "</h3><br/>");
        buf.append("Bonjour ,");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Un ou plusieurs adh\u00e9rents se sont inscrits en mode nouvel arrivant / retardataire");
        buf.append("<br/>");
        buf.append("Nom du producteur : " + producteur.nom);
        buf.append("<br/>");
        buf.append("<br/>");
        G1D<ModeleContrat, Contrat> c1 = new G1D<ModeleContrat, Contrat>();
        c1.fill(cs);
        c1.groupBy(e -> e.modeleContrat);
        c1.sortLig(e -> e.nom, true);
        c1.sortCell(e -> String.valueOf(e.utilisateur.nom) + " " + e.utilisateur.prenom, true);
        c1.compute();
        List mcs = c1.getFullCells();
        for (G1D.Cell1 cell1 : mcs) {
            buf.append("Nom du mod\u00e8le de contrat : " + StringUtils.s(((ModeleContrat)cell1.lig).nom));
            buf.append("<br/>");
            int nb = cell1.values.size();
            if (nb == 1) {
                buf.append("1 adh\u00e9rent a souscrit un nouveau contrat :");
            } else {
                buf.append(String.valueOf(nb) + " adh\u00e9rents ont souscrit un nouveau contrat :");
            }
            buf.append("<br/>");
            for (Contrat c : cell1.values) {
                buf.append("- " + StringUtils.s(String.valueOf(c.utilisateur.nom) + " " + c.utilisateur.prenom));
                buf.append("<br/>");
            }
            buf.append("<br/><br/><br/>");
        }
        buf.append("A noter : les feuilles de livraison envoy\u00e9es par mail contiennent bien ces nouveaux adh\u00e9rents.");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Si vous souhaitez acc\u00e9der \u00e0 l'application : <a href=\"" + link + "\">Cliquez ici </a>");
        buf.append("<br/>");
        buf.append("<br/>");
        buf.append("Bonne journ\u00e9e !");
        buf.append("<br/>");
        buf.append("<br/>");
        return buf.toString();
    }
}

