/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.parametres;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.Parametres;
import fr.amapj.model.models.param.paramecran.PEListeAdherent;
import fr.amapj.model.models.param.paramecran.common.AbstractParamEcran;
import fr.amapj.model.models.param.paramecran.common.ParamEcran;
import fr.amapj.model.models.param.paramecran.common.ParamEcranConverter;
import fr.amapj.service.services.parametres.ParamEcranDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.paramecran.PEListeAdherentDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.menu.MenuList;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class ParametresService {
    private static Long ID_PARAM = new Long(1L);

    @DbRead
    public ParametresDTO getParametres() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Parametres param = this.findParam(em);
            ParametresDTO dto = new ParametresDTO();
            dto.nomAmap = param.nomAmap;
            dto.villeAmap = param.villeAmap;
            dto.sendingMailUsername = param.sendingMailUsername;
            dto.sendingMailPassword = param.sendingMailPassword;
            dto.sendingMailNbMax = param.sendingMailNbMax;
            dto.sendingMailFooter = param.sendingMailFooter;
            dto.mailCopyTo = param.mailCopyTo;
            dto.url = param.url;
            dto.backupReceiver = param.backupReceiver;
            dto.etatPlanningDistribution = param.etatPlanningDistribution;
            dto.etatGestionCotisation = param.etatGestionCotisation;
            dto.delaiMailRappelPermanence = param.delaiMailRappelPermanence;
            dto.envoiMailRappelPermanence = param.envoiMailRappelPermanence;
            dto.titreMailRappelPermanence = param.titreMailRappelPermanence;
            dto.contenuMailRappelPermanence = param.contenuMailRappelPermanence;
            dto.envoiMailPeriodique = param.envoiMailPeriodique;
            dto.numJourDansMois = param.numJourDansMois;
            dto.titreMailPeriodique = param.titreMailPeriodique;
            dto.contenuMailPeriodique = param.contenuMailPeriodique;
            dto.etatGestionStock = param.etatGestionStock;
            dto.serviceMailActif = false;
            if (param.sendingMailUsername != null && param.sendingMailUsername.length() > 0) {
                dto.serviceMailActif = true;
            }
            ParametresDTO parametresDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return parametresDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ParametresArchivageDTO getParametresArchivage() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Parametres param = this.findParam(em);
            ParametresArchivageDTO dto = new ParametresArchivageDTO();
            dto.archivageContrat = param.archivageContrat;
            dto.suppressionContrat = param.suppressionContrat;
            dto.archivageUtilisateur = param.archivageUtilisateur;
            dto.archivageProducteur = param.archivageProducteur;
            dto.suppressionPeriodeCotisation = param.suppressionPeriodeCotisation;
            dto.suppressionPeriodePermanence = param.suppressionPeriodePermanence;
            ParametresArchivageDTO parametresArchivageDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return parametresArchivageDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private Parametres findParam(RdbLink em) {
        Parametres param = em.find(Parametres.class, ID_PARAM);
        if (param == null) {
            throw new RuntimeException("Il faut ins\u00e9rer les param\u00e8tres g\u00e9n\u00e9raux dans la base");
        }
        return param;
    }

    @DbWrite
    public void update(ParametresDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Parametres param = this.findParam(em);
            param.nomAmap = dto.nomAmap;
            param.villeAmap = dto.villeAmap;
            param.sendingMailUsername = dto.sendingMailUsername;
            param.sendingMailPassword = dto.sendingMailPassword;
            param.sendingMailNbMax = dto.sendingMailNbMax;
            param.sendingMailFooter = dto.sendingMailFooter;
            param.mailCopyTo = dto.mailCopyTo;
            param.url = dto.url;
            param.backupReceiver = dto.backupReceiver;
            param.etatPlanningDistribution = dto.etatPlanningDistribution;
            param.etatGestionCotisation = dto.etatGestionCotisation;
            param.delaiMailRappelPermanence = dto.delaiMailRappelPermanence;
            param.envoiMailRappelPermanence = dto.envoiMailRappelPermanence;
            param.titreMailRappelPermanence = dto.titreMailRappelPermanence;
            param.contenuMailRappelPermanence = dto.contenuMailRappelPermanence;
            param.envoiMailPeriodique = dto.envoiMailPeriodique;
            param.numJourDansMois = dto.numJourDansMois;
            param.titreMailPeriodique = dto.titreMailPeriodique;
            param.contenuMailPeriodique = dto.contenuMailPeriodique;
            param.etatGestionStock = dto.etatGestionStock;
            this.updateStockModeleContrat(em, param);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void updateStockModeleContrat(RdbLink em, Parametres param) {
        if (param.etatGestionStock == EtatModule.INACTIF) {
            TypedQuery<Producteur> q2 = em.createQuery("select p from Producteur p", Producteur.class);
            for (Producteur p : q2.getResultList()) {
                p.gestionStock = ProducteurStockGestion.NON;
                new ProducteurService().updateStockInfoModeleContratAndProduit(em, p);
            }
        }
    }

    @DbWrite
    public void updateParametresArchivage(ParametresArchivageDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Parametres param = this.findParam(em);
            param.archivageContrat = dto.archivageContrat;
            param.suppressionContrat = dto.suppressionContrat;
            param.archivageUtilisateur = dto.archivageUtilisateur;
            param.archivageProducteur = dto.archivageProducteur;
            param.suppressionPeriodeCotisation = dto.suppressionPeriodeCotisation;
            param.suppressionPeriodePermanence = dto.suppressionPeriodePermanence;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<ParamEcranDTO> getAllParamEcranDTO() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<ParamEcranDTO> res = new ArrayList<ParamEcranDTO>();
            Query q = em.createQuery("select p from ParamEcran p");
            List ps = q.getResultList();
            for (ParamEcran p : ps) {
                ParamEcranDTO dto = this.createParamEcranDTO(em, p);
                res.add(dto);
            }
            ArrayList<ParamEcranDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public ParamEcranDTO createParamEcranDTO(RdbLink em, ParamEcran p) {
        ParamEcranDTO dto = new ParamEcranDTO();
        dto.id = p.getId();
        dto.menu = p.getMenu();
        dto.content = p.getContent();
        return dto;
    }

    @DbWrite
    public void update(AbstractParamEcran abstractParamEcran) {
        try {
            ParamEcran p;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            boolean create = abstractParamEcran.getId() == null;
            ParamEcranDTO dto = ParamEcranConverter.save(abstractParamEcran);
            if (create) {
                p = new ParamEcran();
                p.setMenu(dto.menu);
            } else {
                p = em.find(ParamEcran.class, dto.id);
            }
            p.setContent(dto.content);
            if (create) {
                em.persist(p);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public AbstractParamEcran loadParamEcran(MenuList menuList) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ParamEcranDTO p = this.getParamEcranDTO(menuList, em);
            AbstractParamEcran pe = p != null ? ParamEcranConverter.load(p) : ParamEcranConverter.getNew(menuList);
            AbstractParamEcran abstractParamEcran = pe;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return abstractParamEcran;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ParamEcranDTO getParamEcranDTO(MenuList menu, RdbLink em) {
        Query q = em.createQuery("select p from ParamEcran p where p.menu=:m ");
        q.setParameter("m", (Object)menu);
        List ps = q.getResultList();
        if (ps.size() == 0) {
            return null;
        }
        if (ps.size() == 1) {
            return this.createParamEcranDTO(em, (ParamEcran)ps.get(0));
        }
        throw new AmapjRuntimeException("Erreur : il y a deux param ecrans pour " + (Object)((Object)menu));
    }

    public PEListeAdherentDTO getPEListeAdherentDTO() {
        PEListeAdherent pe = (PEListeAdherent)this.loadParamEcran(MenuList.LISTE_ADHERENTS);
        List<RoleList> roles = SessionManager.getSessionParameters().userRole;
        PEListeAdherentDTO ret = new PEListeAdherentDTO();
        ret.canAccessEmail = roles.contains((Object)pe.canAccessEmail);
        ret.canAccessTel1 = roles.contains((Object)pe.canAccessTel1);
        ret.canAccessTel2 = roles.contains((Object)pe.canAccessTel2);
        ret.canAccessAdress = roles.contains((Object)pe.canAccessAdress);
        return ret;
    }
}

