/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.detailperiode.calculauto;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceUtilisateur;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.persistence.Query;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalculAutoPeriodePermanenceService {
    private static final Logger logger = LogManager.getLogger();

    @DbWrite
    public String performPlanification(Long idPeriodePermanence) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            logger.info("D\u00e9but de l'action performPlanification pour la periode id = " + idPeriodePermanence);
            RdbLink em = RdbLink.get();
            StringBuilder sb = new StringBuilder();
            PeriodePermanenceDTO dto = new PeriodePermanenceService().loadPeriodePermanenceDTO(idPeriodePermanence);
            this.updateWithExistingInscription(em, dto);
            List<UtilisateurInfo> uInfos = this.createUtilisateurInfo(em, dto);
            this.performAffectationStandard(em, uInfos, sb, dto);
            for (PeriodePermanenceDateDTO datePerm : dto.datePerms) {
                for (PermanenceCellDTO cell : datePerm.permanenceCellDTOs) {
                    if (cell.idPeriodePermanenceUtilisateur == null) continue;
                    PermanenceCell pc = em.find(PermanenceCell.class, cell.idPermanenceCell);
                    pc.periodePermanenceUtilisateur = em.find(PeriodePermanenceUtilisateur.class, cell.idPeriodePermanenceUtilisateur);
                }
            }
            logger.info("Fin de l'action performPlanification pour la periode id = " + idPeriodePermanence + ". R\u00e9sultat : " + sb);
            String string = sb.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void updateWithExistingInscription(RdbLink em, PeriodePermanenceDTO dto) {
        for (PeriodePermanenceDateDTO datePerm : dto.datePerms) {
            for (PermanenceCellDTO cell : datePerm.permanenceCellDTOs) {
                if (cell.idUtilisateur == null) continue;
                PeriodePermanenceUtilisateurDTO util = dto.findPeriodePermanenceUtilisateurDTO(cell.idUtilisateur);
                --util.nbParticipation;
            }
        }
    }

    private List<UtilisateurInfo> createUtilisateurInfo(RdbLink em, PeriodePermanenceDTO dto) {
        ArrayList<UtilisateurInfo> res = new ArrayList<UtilisateurInfo>();
        List<Date> dates = this.extractDate(dto.datePerms);
        for (PeriodePermanenceUtilisateurDTO utilisateur : dto.utilisateurs) {
            List<Date> datLivs = this.geDateLivraison(utilisateur.idUtilisateur, dates, em);
            int i = 0;
            while (i < utilisateur.nbParticipation) {
                UtilisateurInfo uInfo = new UtilisateurInfo(i, utilisateur, datLivs);
                res.add(uInfo);
                ++i;
            }
        }
        return res;
    }

    private List<Date> extractDate(List<PeriodePermanenceDateDTO> dates) {
        ArrayList<Date> res = new ArrayList<Date>();
        for (PeriodePermanenceDateDTO date : dates) {
            res.add(date.datePerm);
        }
        return res;
    }

    private List<Date> geDateLivraison(Long idUtilisateur, List<Date> dates, RdbLink em) {
        Query q = em.createQuery("select distinct(c.modeleContratDate.dateLiv) from ContratCell c WHERE c.contrat.utilisateur=:u and c.modeleContratDate.dateLiv in :dates order by c.modeleContratDate.dateLiv");
        q.setParameter("u", (Object)em.find(Utilisateur.class, idUtilisateur));
        q.setParameter("dates", dates);
        List ds = q.getResultList();
        return ds;
    }

    private void performAffectationStandard(RdbLink em, List<UtilisateurInfo> uInfos, StringBuilder sb, PeriodePermanenceDTO dto) {
        CollectionUtils.sort(uInfos, e -> e.numPlacement, false, e -> e.datLivs.size(), true, e -> e.utilisateur.nom, true, e -> e.utilisateur.prenom, true);
        Random random = new Random(0L);
        for (UtilisateurInfo uInfo : uInfos) {
            this.placeUtilisateur(uInfo, sb, dto, random);
        }
    }

    private void placeUtilisateur(UtilisateurInfo uInfo, StringBuilder sb, PeriodePermanenceDTO dto, Random random) {
        int numPlacement = uInfo.numPlacement;
        PeriodePermanenceUtilisateurDTO utilisateur = uInfo.utilisateur;
        DateInfo di = this.computeDateRandomInPeriode(dto, numPlacement, utilisateur.nbParticipation, random);
        CollectionUtils.sort(dto.datePerms, e -> this.appartientPeriode((PeriodePermanenceDateDTO)e, di), e -> this.hasOrder((PeriodePermanenceDateDTO)e, utilisateurInfo.datLivs), e -> this.deltaFromRef((PeriodePermanenceDateDTO)e, di));
        for (PeriodePermanenceDateDTO date : dto.datePerms) {
            PermanenceCellDTO cell = this.canAffect(date, utilisateur);
            if (cell == null) continue;
            cell.idPeriodePermanenceUtilisateur = utilisateur.idPeriodePermanenceUtilisateur;
            cell.idUtilisateur = utilisateur.idUtilisateur;
            return;
        }
        sb.append("Impossible de placer l'utilisateur " + utilisateur.nom + " " + utilisateur.prenom + " pour sa session num\u00e9ro " + numPlacement + "<br/>");
    }

    private int appartientPeriode(PeriodePermanenceDateDTO e, DateInfo di) {
        if (DateUtils.isInIntervalle(e.datePerm, di.debut, di.fin)) {
            return 0;
        }
        return 1;
    }

    private int hasOrder(PeriodePermanenceDateDTO e, List<Date> datLivs) {
        if (datLivs.contains(e.datePerm)) {
            return 0;
        }
        return 1;
    }

    private int deltaFromRef(PeriodePermanenceDateDTO e, DateInfo di) {
        return Math.abs(DateUtils.getDeltaDay(e.datePerm, di.ref));
    }

    private PermanenceCellDTO canAffect(PeriodePermanenceDateDTO date, PeriodePermanenceUtilisateurDTO utilisateur) {
        if (date.isInscrit(utilisateur.idUtilisateur)) {
            return null;
        }
        if (date.isDateComplete()) {
            return null;
        }
        for (PermanenceCellDTO cell : date.permanenceCellDTOs) {
            if (cell.idUtilisateur != null) continue;
            return cell;
        }
        throw new AmapjRuntimeException();
    }

    private DateInfo computeDateRandomInPeriode(PeriodePermanenceDTO dto, int numPlacement, int nbTotalPlacement, Random random) {
        double delta = DateUtils.getDeltaDay(dto.dateDebut, dto.dateFin);
        double pas = delta / (double)nbTotalPlacement;
        DateInfo res = new DateInfo();
        res.debut = DateUtils.addDays(dto.dateDebut, (int)((double)(0 + numPlacement) * pas));
        res.ref = DateUtils.addDays(dto.dateDebut, (int)((random.nextDouble() + (double)numPlacement) * pas));
        res.fin = DateUtils.addDays(dto.dateDebut, (int)((double)(1 + numPlacement) * pas));
        return res;
    }

    public class DateInfo {
        public Date debut;
        public Date fin;
        public Date ref;
    }

    public class UtilisateurInfo {
        public int numPlacement;
        public PeriodePermanenceUtilisateurDTO utilisateur;
        public List<Date> datLivs;

        public UtilisateurInfo(int numPlacement, PeriodePermanenceUtilisateurDTO utilisateur, List<Date> datLivs) {
            this.numPlacement = numPlacement;
            this.utilisateur = utilisateur;
            this.datLivs = datLivs;
        }
    }
}

