/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.periode;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.model.models.permanence.periode.RegleInscriptionPeriodePermanence;
import fr.amapj.service.services.permanence.periode.PermanenceCellDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.tools.TableItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PeriodePermanenceDateDTO
implements TableItem {
    public String nomPeriode;
    public Long idPeriodePermanenceDate;
    public Date datePerm;
    public int nbPlace;
    public List<PermanenceCellDTO> permanenceCellDTOs = new ArrayList<PermanenceCellDTO>();
    public RegleInscriptionPeriodePermanence regleInscription;

    public Date getDatePerm() {
        return this.datePerm;
    }

    public void setDatePerm(Date datePerm) {
        this.datePerm = datePerm;
    }

    public int getNbPlace() {
        return this.nbPlace;
    }

    public void setNbPlace(int nbPlace) {
        this.nbPlace = nbPlace;
    }

    public int getNbInscrit() {
        int nb = 0;
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (pc.idUtilisateur == null) continue;
            ++nb;
        }
        return nb;
    }

    public void setNbInscrit(int nbPersonneInscrit) {
    }

    public String getComplet() {
        if (this.getNbInscrit() >= this.nbPlace) {
            return "OUI";
        }
        return "NON";
    }

    public void setComplet(String complet) {
    }

    public String getNomInscrit() {
        return this.getNomInscrit(", ");
    }

    public void setNomInscrit(String s) {
    }

    public String getNomInscrit(String sep) {
        ArrayList<PermanenceCellDTO> tmp = new ArrayList<PermanenceCellDTO>();
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (pc.idUtilisateur == null) continue;
            tmp.add(pc);
        }
        return CollectionUtils.asString(tmp, sep, e -> String.valueOf(e.nom) + " " + e.prenom);
    }

    public String getNomInscritWithRoles(String sep) {
        ArrayList<PermanenceCellDTO> tmp = new ArrayList<PermanenceCellDTO>();
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (pc.idUtilisateur == null) continue;
            tmp.add(pc);
        }
        return CollectionUtils.asString(tmp, sep, e -> String.valueOf(e.nom) + " " + e.prenom + " - " + e.lib);
    }

    public boolean isInscrit(Long idUtilisateur) {
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (!LongUtils.equals(pc.idUtilisateur, idUtilisateur)) continue;
            return true;
        }
        return false;
    }

    public int countInscrit(Long idUtilisateur) {
        int nb = 0;
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (!LongUtils.equals(pc.idUtilisateur, idUtilisateur)) continue;
            ++nb;
        }
        return nb;
    }

    public List<String> getRoles(Long idUtilisateur) {
        ArrayList<String> res = new ArrayList<String>();
        for (PermanenceCellDTO pc : this.permanenceCellDTOs) {
            if (!LongUtils.equals(pc.idUtilisateur, idUtilisateur)) continue;
            res.add(pc.lib);
        }
        return res;
    }

    public String getRolesAsString(Long idUtilisateur) {
        return CollectionUtils.asString(this.getRoles(idUtilisateur), ",");
    }

    public boolean isDateComplete() {
        return this.getNbInscrit() >= this.nbPlace;
    }

    public String checkRegleInscription() {
        switch (this.regleInscription) {
            case UNE_INSCRIPTION_PAR_DATE: {
                return this.checkRegleInscriptionUneInscriptionParDate();
            }
            case MULTIPLE_INSCRIPTION_SUR_ROLE_DIFFERENT: {
                return this.checkRegleInscriptionRoleDifferent();
            }
            case TOUT_AUTORISE: {
                return null;
            }
        }
        throw new AmapjRuntimeException();
    }

    private String checkRegleInscriptionUneInscriptionParDate() {
        ArrayList<PermanenceCellDTO> tmp = new ArrayList<PermanenceCellDTO>();
        int i = 0;
        while (i < this.permanenceCellDTOs.size()) {
            PermanenceCellDTO lig = this.permanenceCellDTOs.get(i);
            if (lig.idUtilisateur != null) {
                PermanenceCellDTO alreadyIn = CollectionUtils.findMatching(tmp, e -> permanenceCellDTO.idUtilisateur.equals(e.idUtilisateur));
                if (alreadyIn != null) {
                    String u = new UtilisateurService().prettyString(alreadyIn.idUtilisateur);
                    return "L'utilisateur " + u + " est pr\u00e9sent deux fois ou plus.";
                }
                tmp.add(lig);
            }
            ++i;
        }
        return null;
    }

    private String checkRegleInscriptionRoleDifferent() {
        ArrayList<PermanenceCellDTO> tmp = new ArrayList<PermanenceCellDTO>();
        int i = 0;
        while (i < this.permanenceCellDTOs.size()) {
            PermanenceCellDTO lig = this.permanenceCellDTOs.get(i);
            if (lig.idUtilisateur != null) {
                PermanenceCellDTO alreadyIn = CollectionUtils.findMatching(tmp, e -> permanenceCellDTO.idUtilisateur.equals(e.idUtilisateur) && permanenceCellDTO.idRole.equals(e.idRole));
                if (alreadyIn != null) {
                    String u = new UtilisateurService().prettyString(alreadyIn.idUtilisateur);
                    return "L'utilisateur " + u + " est pr\u00e9sent deux fois ou plus sur le m\u00eame r\u00f4le.";
                }
                tmp.add(lig);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Long getId() {
        return this.idPeriodePermanenceDate;
    }

    public List<PermanenceCellDTO> getPermanenceCellDTOs() {
        return this.permanenceCellDTOs;
    }

    public void setPermanenceCellDTOs(List<PermanenceCellDTO> permanenceCellDTOs) {
        this.permanenceCellDTOs = permanenceCellDTOs;
    }
}

