/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.periode.mail;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.edgenerator.excel.permanence.EGPlanningPermanence;
import fr.amapj.service.services.mailer.MailerAttachement;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;

public class PeriodePermanenceEnvoiMailService {
    @DbRead
    public void sendMailAvecPlanning(String texte, Long idPeriodePermanence) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Date startingDate = DateUtils.getDateWithNoTime();
            List<Utilisateur> utilisateurs = this.getUtilisateursPermanenceFuture(em, startingDate, idPeriodePermanence);
            EGPlanningPermanence generator = new EGPlanningPermanence(idPeriodePermanence, startingDate);
            MailerAttachement attachement = new MailerAttachement(generator);
            for (Utilisateur utilisateur : utilisateurs) {
                this.sendEmail(em, utilisateur, attachement, texte);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<Utilisateur> getUtilisateursPermanenceFuture(RdbLink em, Date startingDate, Long idPeriodePermanence) {
        Query q = em.createQuery("select distinct(pc.periodePermanenceUtilisateur.utilisateur) from PermanenceCell pc where  pc.periodePermanenceDate.datePerm>=:d1  and  pc.periodePermanenceDate.periodePermanence.id=:id   order by pc.periodePermanenceUtilisateur.utilisateur.nom , pc.periodePermanenceUtilisateur.utilisateur.prenom");
        q.setParameter("d1", (Object)startingDate);
        q.setParameter("id", (Object)idPeriodePermanence);
        List us = q.getResultList();
        return us;
    }

    private void sendEmail(RdbLink em, Utilisateur utilisateur, MailerAttachement attachement, String texte) {
        ParametresDTO param = new ParametresService().getParametres();
        String email = utilisateur.email;
        String subject = String.valueOf(param.nomAmap) + " - Planning des permanences";
        String htmlContent = texte;
        htmlContent = htmlContent.replaceAll("\r\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\r", "<br/>");
        String link = "<a href=\"" + param.getUrl() + "\">" + param.getUrl() + "</a>";
        htmlContent = htmlContent.replaceAll("#LINK#", link);
        String datePermanences = this.getDatePermanence(em, utilisateur);
        htmlContent = htmlContent.replaceAll("#DATES#", datePermanences);
        MailerMessage message = new MailerMessage();
        message.setEmail(email);
        message.setTitle(subject);
        message.setContent(htmlContent);
        message.addAttachement(attachement);
        new MailerService().sendHtmlMail(message);
    }

    private String getDatePermanence(RdbLink em, Utilisateur utilisateur) {
        List<PeriodePermanenceDateDTO> permanencesFutures = new MesPermanencesService().getDistributionsFutures(em, utilisateur);
        SimpleDateFormat df = FormatUtils.getFullDate();
        StringBuffer buf = new StringBuffer();
        buf.append("<ul>");
        for (PeriodePermanenceDateDTO distribution : permanencesFutures) {
            buf.append("<li>" + df.format(distribution.datePerm) + "</li>");
        }
        buf.append("</ul><br/>");
        return buf.toString();
    }
}

