/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.permanence.periode.update;

import fr.amapj.common.CollectionUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.permanence.periode.PeriodePermanence;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceDate;
import fr.amapj.model.models.permanence.periode.PeriodePermanenceUtilisateur;
import fr.amapj.model.models.permanence.periode.PermanenceRole;
import fr.amapj.model.models.permanence.reel.PermanenceCell;
import fr.amapj.service.services.permanence.detailperiode.DetailPeriodePermanenceService;
import fr.amapj.service.services.permanence.mespermanences.MesPermanencesService;
import fr.amapj.service.services.permanence.mespermanences.UnePeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceDateDTO;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceUtilisateurDTO;
import fr.amapj.service.services.permanence.role.PermanenceRoleService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class PeriodePermanenceUpdateService {
    public PeriodePermanenceDTO loadPeriodePermanence(Long id) {
        return null;
    }

    @DbWrite
    public void updateEntete(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            pp.nom = dto.nom;
            pp.description = dto.description;
            pp.dateFinInscription = dto.dateFinInscription;
            pp.flottantDelai = dto.flottantDelai;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void updateRegleInscription(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            pp.regleInscription = dto.regleInscription;
            pp.depassementAutorise = dto.depassementAutorise;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void addDates(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, dto.id);
            PermanenceRole defaultRole = new PermanenceRoleService().getOrCreateDefaultRole(em);
            for (PeriodePermanenceDateDTO date : dto.datePerms) {
                PeriodePermanenceDate md = new PeriodePermanenceDate();
                md.periodePermanence = p;
                md.datePerm = date.datePerm;
                md.nbPlace = date.nbPlace;
                em.persist(md);
                int i = 0;
                while (i < date.nbPlace) {
                    PermanenceCell pc = new PermanenceCell();
                    pc.periodePermanenceDate = md;
                    pc.permanenceRole = defaultRole;
                    pc.indx = i++;
                    em.persist(pc);
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getDeleteDateInfo(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer buf = new StringBuffer();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            Query q = em.createQuery("select d from PeriodePermanenceDate d where  d.periodePermanence=:pp and d.datePerm >= :debut and  d.datePerm <= :fin ORDER BY d.datePerm");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List mcds = q.getResultList();
            SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
            buf.append("Les " + mcds.size() + " dates de permanences suivantes vont \u00eatre supprim\u00e9es:<br/>");
            for (PeriodePermanenceDate modeleContratDate : mcds) {
                buf.append(" - " + df.format(modeleContratDate.datePerm) + "<br/>");
            }
            buf.append("<br/>");
            q = em.createQuery("select distinct(c.periodePermanenceUtilisateur.utilisateur) from PermanenceCell c where  c.periodePermanenceDate.periodePermanence=:pp and  c.periodePermanenceDate.datePerm >= :debut and  c.periodePermanenceDate.datePerm <= :fin  order by c.periodePermanenceUtilisateur.utilisateur.nom,c.periodePermanenceUtilisateur.utilisateur.prenom");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List utilisateurs = q.getResultList();
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void performDeleteDatePermanence(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            Query q = em.createQuery("select c from PermanenceCell c where  c.periodePermanenceDate.periodePermanence=:pp and  c.periodePermanenceDate.datePerm >= :debut and  c.periodePermanenceDate.datePerm <= :fin");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List pcs = q.getResultList();
            for (PermanenceCell pc : pcs) {
                em.remove(pc);
            }
            q = em.createQuery("select d from PeriodePermanenceDate d where  d.periodePermanence=:pp and d.datePerm >= :debut and  d.datePerm <= :fin");
            q.setParameter("pp", (Object)pp);
            q.setParameter("debut", (Object)dto.dateDebut);
            q.setParameter("fin", (Object)dto.dateFin);
            List ppds = q.getResultList();
            for (PeriodePermanenceDate ppd : ppds) {
                em.remove(ppd);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void addUtilisateurs(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence p = em.find(PeriodePermanence.class, dto.id);
            for (PeriodePermanenceUtilisateurDTO detail : dto.utilisateurs) {
                Utilisateur utilisateur = em.find(Utilisateur.class, detail.idUtilisateur);
                PeriodePermanenceUtilisateur ppu = new PeriodePermanenceUtilisateur();
                ppu.nbParticipation = detail.nbParticipation;
                ppu.utilisateur = utilisateur;
                ppu.periodePermanence = p;
                em.persist(ppu);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getUpdateNbParticipationInfo(PeriodePermanenceDTO dto, List<PeriodePermanenceUtilisateurDTO> existingUtilisateurs) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer info = new StringBuffer();
            ArrayList<Utilisateur> utilisateurs = new ArrayList<Utilisateur>();
            int i = 0;
            while (i < existingUtilisateurs.size()) {
                PeriodePermanenceUtilisateurDTO oldDetail = existingUtilisateurs.get(i);
                PeriodePermanenceUtilisateurDTO newDetail = dto.utilisateurs.get(i);
                if (newDetail.nbParticipation != oldDetail.nbParticipation) {
                    Utilisateur u = em.find(Utilisateur.class, newDetail.idUtilisateur);
                    utilisateurs.add(u);
                    info.append(this.getInfos(newDetail, oldDetail, em, u, dto.id));
                    info.append("<br/>");
                }
                ++i;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            buf.append("<br/>D\u00e9tail des modifications:<br/>");
            buf.append(info);
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String getInfos(PeriodePermanenceUtilisateurDTO newDetail, PeriodePermanenceUtilisateurDTO oldDetail, RdbLink em, Utilisateur u, Long idPeriodePermanence) {
        if (newDetail.nbParticipation > oldDetail.nbParticipation) {
            return "L'utilisateur " + u.nom + " " + u.prenom + " doit faire " + (newDetail.nbParticipation - oldDetail.nbParticipation) + " participations suppl\u00e9mentaires";
        }
        String str = "L'utilisateur " + u.nom + " " + u.prenom + " doit faire " + (oldDetail.nbParticipation - newDetail.nbParticipation) + " participations en moins.";
        UnePeriodePermanenceDTO cpts = new MesPermanencesService().loadCompteurPeriodePermanence(idPeriodePermanence, u.getId());
        str = cpts.nbInscription <= newDetail.nbParticipation ? String.valueOf(str) + " Il est inscrit " + cpts.nbInscription + " et doit maintenant participer " + newDetail.nbParticipation + ", donc il n'est pas impact\u00e9." : String.valueOf(str) + " Il est inscrit " + cpts.nbInscription + " et doit maintenant participer " + newDetail.nbParticipation + ", donc il doit se desincrire sur " + (cpts.nbInscription - newDetail.nbParticipation) + " dates.";
        return str;
    }

    @DbWrite
    public void performUpdateNbParticipation(PeriodePermanenceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, dto.id);
            for (PeriodePermanenceUtilisateurDTO detail : dto.utilisateurs) {
                PeriodePermanenceUtilisateur ppu = new DetailPeriodePermanenceService().findPeriodePermanenceUtilisateur(em, detail.idUtilisateur, pp);
                ppu.nbParticipation = detail.nbParticipation;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public String getDeleteUtilisateurInfo(List<PeriodePermanenceUtilisateurDTO> utilisateurToSuppress, Long idPeriodePermanence) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            StringBuffer info = new StringBuffer();
            ArrayList<Utilisateur> utilisateurs = new ArrayList<Utilisateur>();
            for (PeriodePermanenceUtilisateurDTO detail : utilisateurToSuppress) {
                Utilisateur u = em.find(Utilisateur.class, detail.idUtilisateur);
                utilisateurs.add(u);
                info.append(this.getDeleteUtilisateurInfos(detail, em, u, idPeriodePermanence));
                info.append("<br/>");
            }
            StringBuffer buf = new StringBuffer();
            buf.append("Les utilisateurs suivants vont \u00eatre enlev\u00e9s de cette p\u00e9riode de permanence<br/>");
            buf.append(UtilisateurUtil.getUtilisateurImpactes(utilisateurs));
            buf.append("<br/><br/>D\u00e9tail des inscriptions de ces utilisateurs :<br/>");
            buf.append(info);
            String string = buf.toString();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String getDeleteUtilisateurInfos(PeriodePermanenceUtilisateurDTO detail, RdbLink em, Utilisateur u, Long idPeriodePermanence) {
        List<PeriodePermanenceDate> dates = this.getDateUtilisateur(em, u, idPeriodePermanence);
        if (dates.size() == 0) {
            return "L'utilisateur " + u.nom + " " + u.prenom + " n'\u00e9tait pas inscrit.";
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
        String str = "L'utilisateur " + u.nom + " " + u.prenom + " \u00e9tait inscrit " + dates.size() + " fois :";
        str = String.valueOf(str) + CollectionUtils.asStdString(dates, e -> df.format(e.datePerm));
        str = String.valueOf(str) + ". Ces incriptions vont \u00eatre effac\u00e9es.";
        return str;
    }

    private List<PeriodePermanenceDate> getDateUtilisateur(RdbLink em, Utilisateur u, Long idPeriodePermanence) {
        Query q = em.createQuery("select c.periodePermanenceDate from PermanenceCell c WHERE  c.periodePermanenceDate.periodePermanence.id=:id and  c.periodePermanenceUtilisateur.utilisateur = :u  order by c.periodePermanenceDate.datePerm");
        q.setParameter("id", (Object)idPeriodePermanence);
        q.setParameter("u", (Object)u);
        List pcs = q.getResultList();
        return pcs;
    }

    @DbWrite
    public void performDeleteUtilisateur(Long idPeriodePermanence, List<PeriodePermanenceUtilisateurDTO> utilisateurToSuppress) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            PeriodePermanence pp = em.find(PeriodePermanence.class, idPeriodePermanence);
            for (PeriodePermanenceUtilisateurDTO detail : utilisateurToSuppress) {
                this.performDeleteOneUtilisateur(em, detail, pp);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void performDeleteOneUtilisateur(RdbLink em, PeriodePermanenceUtilisateurDTO detail, PeriodePermanence pp) {
        PeriodePermanenceUtilisateur ppu = new DetailPeriodePermanenceService().findPeriodePermanenceUtilisateur(em, detail.idUtilisateur, pp);
        Query q = em.createQuery("select c from PermanenceCell c where c.periodePermanenceUtilisateur=:ppu");
        q.setParameter("ppu", (Object)ppu);
        List pcs = q.getResultList();
        for (PermanenceCell pc : pcs) {
            em.remove(pc);
        }
        em.remove(ppu);
    }
}

