/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.producteur;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.LongUtils;
import fr.amapj.common.SQLUtils;
import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.fichierbase.EtatNotification;
import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurReferent;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.fichierbase.ProducteurUtilisateur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.service.engine.tools.DbToDto;
import fr.amapj.service.services.archivage.tools.ArchivableState;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.docengagement.signonline.DocEngagementSignOnLineService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.producteur.ProdUtilisateurDTO;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.produitextended.ProduitExtendedService;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class ProducteurService {
    @DbRead
    public List<ProducteurDTO> getAllProducteurs(EtatProducteur etat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            List<Producteur> ps = this.getAll(etat);
            List<ProducteurDTO> list = DbToDto.convert(ps, e -> this.createProducteurDto(em, (Producteur)e));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ProducteurDTO loadProducteur(Long idProducteur) {
        try {
            ProducteurDTO dto;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Producteur p = em.find(Producteur.class, idProducteur);
            ProducteurDTO producteurDTO = dto = this.createProducteurDto(em, p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return producteurDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ProducteurDTO createProducteurDto(RdbLink em, Producteur p) {
        ProducteurDTO dto = new ProducteurDTO();
        dto.id = p.id;
        dto.nom = p.nom;
        dto.description = p.description;
        dto.dateCreation = p.dateCreation;
        dto.dateModification = p.dateModification;
        dto.etat = p.etat;
        dto.feuilleDistributionGrille = p.feuilleDistributionGrille;
        dto.feuilleDistributionListe = p.feuilleDistributionListe;
        dto.feuilleDistributionEtiquette = p.etiquette == null ? ChoixOuiNon.NON : ChoixOuiNon.OUI;
        dto.idEtiquette = IdentifiableUtil.getId(p.etiquette);
        dto.libContrat = p.libContrat;
        dto.delaiModifContrat = p.delaiModifContrat;
        dto.referents = this.getReferents(em, p);
        dto.utilisateurs = this.getUtilisateur(em, p);
        dto.dateDerniereLivraison = this.findDerniereDateLivraison(em, p);
        dto.nbModeleContratActif = this.countModeleContratActif(em, p);
        dto.gestionStock = p.gestionStock;
        dto.notificationRetardataire = p.notificationRetardataire;
        return dto;
    }

    private Date findDerniereDateLivraison(RdbLink em, Producteur p) {
        TypedQuery<Date> q = em.createQuery("select max(c.dateLiv) from ModeleContratDate c WHERE c.modeleContrat.producteur=:p", Date.class);
        q.setParameter("p", (Object)p);
        return (Date)q.getSingleResult();
    }

    private int countModeleContratActif(RdbLink em, Producteur p) {
        Query q = em.createQuery("select count(c) from ModeleContrat c WHERE c.producteur=:p AND c.etat<>:etat");
        q.setParameter("p", (Object)p);
        q.setParameter("etat", (Object)EtatModeleContrat.ARCHIVE);
        return LongUtils.toInt(q.getSingleResult());
    }

    private int countModeleContrat(RdbLink em, Producteur p) {
        Query q = em.createQuery("select count(c) from ModeleContrat c WHERE c.producteur=:p");
        q.setParameter("p", (Object)p);
        return LongUtils.toInt(q.getSingleResult());
    }

    public List<ProdUtilisateurDTO> getReferents(RdbLink em, Producteur p) {
        ArrayList<ProdUtilisateurDTO> res = new ArrayList<ProdUtilisateurDTO>();
        List<ProducteurReferent> prs = this.getProducteurReferent(em, p);
        for (ProducteurReferent pr : prs) {
            ProdUtilisateurDTO dto = new ProdUtilisateurDTO();
            dto.idUtilisateur = pr.referent.id;
            dto.nom = pr.referent.nom;
            dto.prenom = pr.referent.prenom;
            dto.etatNotification = pr.notification == EtatNotification.AVEC_NOTIFICATION_MAIL;
            res.add(dto);
        }
        return res;
    }

    public List<ProducteurReferent> getProducteurReferent(RdbLink em, Producteur p) {
        TypedQuery<ProducteurReferent> q = em.createQuery("select c from ProducteurReferent c WHERE c.producteur=:p order by c.indx", ProducteurReferent.class);
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    public List<ProdUtilisateurDTO> getUtilisateur(RdbLink em, Producteur p) {
        ArrayList<ProdUtilisateurDTO> res = new ArrayList<ProdUtilisateurDTO>();
        List<ProducteurUtilisateur> pus = this.getProducteurUtilisateur(em, p);
        for (ProducteurUtilisateur pu : pus) {
            ProdUtilisateurDTO dto = new ProdUtilisateurDTO();
            dto.idUtilisateur = pu.utilisateur.getId();
            dto.nom = pu.utilisateur.nom;
            dto.prenom = pu.utilisateur.prenom;
            dto.etatNotification = pu.notification == EtatNotification.AVEC_NOTIFICATION_MAIL;
            res.add(dto);
        }
        return res;
    }

    public List<ProducteurUtilisateur> getProducteurUtilisateur(RdbLink em, Producteur p) {
        TypedQuery<ProducteurUtilisateur> q = em.createQuery("select c from ProducteurUtilisateur c WHERE c.producteur=:p order by c.indx", ProducteurUtilisateur.class);
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    @DbRead
    public String getEmailsProducteur(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            List<ProducteurUtilisateur> pus = this.getProducteurUtilisateur(em, em.find(Producteur.class, idProducteur));
            String res = "";
            for (ProducteurUtilisateur pu : pus) {
                Utilisateur u = pu.utilisateur;
                if (!UtilisateurUtil.canSendMailTo(u)) continue;
                res = String.valueOf(res) + u.email + ";";
            }
            String string = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public Long update(ProducteurDTO dto, boolean create) {
        try {
            Producteur p;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            if (create) {
                p = new Producteur();
                p.dateCreation = DateUtils.getDate();
            } else {
                p = em.find(Producteur.class, dto.id);
                p.dateModification = DateUtils.getDate();
            }
            p.nom = dto.nom;
            p.description = dto.description;
            p.feuilleDistributionGrille = dto.feuilleDistributionGrille;
            p.feuilleDistributionListe = dto.feuilleDistributionListe;
            p.etiquette = IdentifiableUtil.findIdentifiableFromId(EditionSpecifique.class, dto.idEtiquette, em);
            p.libContrat = dto.libContrat;
            p.delaiModifContrat = dto.delaiModifContrat;
            p.gestionStock = dto.gestionStock;
            p.notificationRetardataire = dto.notificationRetardataire;
            if (create) {
                em.persist(p);
            }
            this.updateUtilisateur(dto, em, p);
            this.updateReferent(dto, em, p);
            this.updateStockInfoModeleContratAndProduit(em, p);
            Long l = p.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void updateStockInfoModeleContratAndProduit(RdbLink em, Producteur p) {
        if (p.gestionStock == ProducteurStockGestion.NON) {
            TypedQuery<ModeleContrat> q = em.createQuery("select mc from ModeleContrat mc WHERE mc.producteur=:p", ModeleContrat.class);
            q.setParameter("p", (Object)p);
            for (ModeleContrat mc : q.getResultList()) {
                mc.stockGestion = StockGestion.NON;
            }
            RegleConversionProduit regles = new ProduitExtendedService().loadRegleConversionProduit(em, p);
            regles.regleStocks.clear();
            new ProduitExtendedService().saveRegleConversionProduit(regles, p, em);
        }
    }

    private void updateUtilisateur(ProducteurDTO dto, RdbLink em, Producteur p) {
        Query q = em.createQuery("select c from ProducteurUtilisateur c WHERE c.producteur=:p");
        q.setParameter("p", (Object)p);
        SQLUtils.deleteAll(em, q);
        int indx = 0;
        for (ProdUtilisateurDTO util : dto.utilisateurs) {
            ProducteurUtilisateur pr = new ProducteurUtilisateur();
            pr.producteur = p;
            pr.utilisateur = em.find(Utilisateur.class, util.idUtilisateur);
            pr.indx = indx;
            pr.notification = util.etatNotification ? EtatNotification.AVEC_NOTIFICATION_MAIL : EtatNotification.SANS_NOTIFICATION_MAIL;
            em.persist(pr);
            ++indx;
        }
    }

    private void updateReferent(ProducteurDTO dto, RdbLink em, Producteur p) {
        Query q = em.createQuery("select c from ProducteurReferent c WHERE c.producteur=:p");
        q.setParameter("p", (Object)p);
        SQLUtils.deleteAll(em, q);
        int indx = 0;
        for (ProdUtilisateurDTO referent : dto.referents) {
            ProducteurReferent pr = new ProducteurReferent();
            pr.producteur = p;
            pr.referent = em.find(Utilisateur.class, referent.idUtilisateur);
            pr.indx = indx;
            pr.notification = referent.etatNotification ? EtatNotification.AVEC_NOTIFICATION_MAIL : EtatNotification.SANS_NOTIFICATION_MAIL;
            em.persist(pr);
            ++indx;
        }
    }

    @DbWrite
    public void delete(Long id) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Producteur p = em.find(Producteur.class, id);
            int r = this.countModeleContrat(em, p);
            if (r > 0) {
                throw new UnableToSuppressException("Cet producteur poss\u00e9de " + r + " modeles de contrats.");
            }
            r = this.countProduit(p, em);
            if (r > 0) {
                throw new UnableToSuppressException("Cet producteur poss\u00e9de " + r + " produits. Vous devez d'abord les supprimer.");
            }
            Query q = em.createQuery("select c from ProducteurReferent c WHERE c.producteur=:p", ProducteurReferent.class);
            q.setParameter("p", (Object)p);
            SQLUtils.deleteAll(em, q);
            q = em.createQuery("select c from ProducteurUtilisateur c WHERE c.producteur=:p");
            q.setParameter("p", (Object)p);
            SQLUtils.deleteAll(em, q);
            q = em.createQuery("select c from ProduitExtendedParam c WHERE c.producteur=:p");
            q.setParameter("p", (Object)p);
            SQLUtils.deleteAll(em, q);
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private int countProduit(Producteur p, RdbLink em) {
        Query q = em.createQuery("select count(c) from Produit c WHERE c.producteur=:p");
        q.setParameter("p", (Object)p);
        return LongUtils.toInt(q.getSingleResult());
    }

    @DbRead
    public List<ModeleContratSummaryDTO> getModeleContratInfo(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Query q = em.createQuery("select mc from ModeleContrat mc WHERE mc.producteur.id=:id");
            q.setParameter("id", (Object)idProducteur);
            List<ModeleContratSummaryDTO> list = DbToDto.transform(q, mc -> this.createModeleContratInfo(em, (ModeleContrat)mc));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ModeleContratSummaryDTO createModeleContratInfo(RdbLink em, ModeleContrat mc) {
        GestionContratService service = new GestionContratService();
        ModeleContratSummaryDTO res = service.createModeleContratInfo(em, mc);
        res.nbContratASignerProducteur = new DocEngagementSignOnLineService().getAllDocumentsASignerByProducteur(mc.id).size();
        return res;
    }

    @DbRead
    public int getDelaiNotification(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Producteur producteur = em.find(Producteur.class, idProducteur);
            int n = producteur.delaiModifContrat;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return n;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void updateEtat(Long idProducteur, EtatProducteur etat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Producteur producteur = em.find(Producteur.class, idProducteur);
            producteur.etat = etat;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public List<Producteur> getAll(EtatProducteur etat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            List<Producteur> list = this.getAll(em, etat);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<Producteur> getAll(RdbLink em, EtatProducteur etat) {
        TypedQuery<Producteur> q = em.createQuery("select p from Producteur p where p.etat=:etat", Producteur.class);
        q.setParameter("etat", (Object)etat);
        return q.getResultList();
    }

    @DbWrite
    public void deleteWithProduit(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            TypedQuery<Produit> q = em.createQuery("select p from Produit p  where p.producteur.id=:prod", Produit.class);
            q.setParameter("prod", (Object)idProducteur);
            for (Produit p : q.getResultList()) {
                em.remove(p);
            }
            this.delete(idProducteur);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public String computeArchivageLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable d'archiver un producteur qui remplit les conditions suivantes : <ul><li>tous les contrats de ce producteur ont \u00e9t\u00e9 archiv\u00e9s</li><li>la date de derni\u00e8re livraison est plus vieille que " + param.archivageProducteur + " jours</li>" + "<li>la date de cr\u00e9ation du producteur est plus vieille que 90 jours</li></ul><br/>";
        return str;
    }

    public ArchivableState computeArchivageState(ProducteurDTO p, ParametresArchivageDTO param) {
        ArchivableState res = new ArchivableState();
        if (p.etat == EtatProducteur.ARCHIVE) {
            res.nonArchivables.add("Le producteur est d\u00e9j\u00e0 archiv\u00e9");
        }
        if (p.nbModeleContratActif != 0) {
            res.nonArchivables.add("Le producteur poss\u00e9de " + p.nbModeleContratActif + " contrats vierges \u00e0 l'\u00e9tat CREATION ou ACTIF");
        }
        Date ref = DateUtils.getDateWithNoTime();
        ref = DateUtils.addDays(ref, -param.archivageProducteur);
        if (p.dateDerniereLivraison != null && p.dateDerniereLivraison.after(ref)) {
            res.reserveMineures.add("La derni\u00e8re livraison est assez r\u00e9cente : " + FormatUtils.getStdDate().format(p.dateDerniereLivraison));
        }
        Date ref2 = DateUtils.getDateWithNoTime();
        if (p.dateCreation.after(ref2 = DateUtils.addDays(ref2, -90))) {
            res.reserveMineures.add("La cr\u00e9ation de ce producteur est assez r\u00e9cente : " + FormatUtils.getStdDate().format(p.dateCreation));
        }
        return res;
    }

    public List<ProducteurDTO> getAllProducteursArchivables(ParametresArchivageDTO param) {
        List<ProducteurDTO> ps = this.getAllProducteurs(EtatProducteur.ACTIF);
        ArrayList<ProducteurDTO> res = new ArrayList<ProducteurDTO>();
        for (ProducteurDTO p : ps) {
            ArchivableState state = this.computeArchivageState(p, param);
            if (state.getStatus() != ArchivableState.AStatus.OUI_SANS_RESERVE) continue;
            res.add(p);
        }
        CollectionUtils.sort(res, e -> e.dateDerniereLivraison);
        return res;
    }

    public String computeSuppressionLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable de supprimer un producteur qui remplit les conditions suivantes : <ul><li>tous les contrats de ce producteur ont \u00e9t\u00e9 supprim\u00e9s</li><li>la date de cr\u00e9ation du producteur est plus vieille que 90 jours</li></ul><br/>";
        return str;
    }

    @DbRead
    public SuppressionState computeSuppressionState(ProducteurDTO dto, ParametresArchivageDTO param) {
        try {
            int r;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            SuppressionState res = new SuppressionState();
            RdbLink em = RdbLink.get();
            Producteur p = em.find(Producteur.class, dto.id);
            if (p.etat != EtatProducteur.ARCHIVE) {
                res.nonSupprimables.add("Le producteur n'est pas \u00e0 l'\u00e9tat Archiv\u00e9");
            }
            if ((r = this.countModeleContrat(em, p)) > 0) {
                res.nonSupprimables.add("Cet producteur poss\u00e9de " + r + " modeles de contrats");
            }
            Date ref2 = DateUtils.getDateWithNoTime();
            if (p.dateCreation.after(ref2 = DateUtils.addDays(ref2, -90))) {
                res.reserveMajeures.add("La cr\u00e9ation de ce producteur est trop r\u00e9cente : " + FormatUtils.getStdDate().format(p.dateCreation));
            }
            SuppressionState suppressionState = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return suppressionState;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<ProducteurDTO> getAllProducteurSupprimables(ParametresArchivageDTO param) {
        List<ProducteurDTO> ps = this.getAllProducteurs(EtatProducteur.ARCHIVE);
        ArrayList<ProducteurDTO> res = new ArrayList<ProducteurDTO>();
        for (ProducteurDTO p : ps) {
            SuppressionState state = this.computeSuppressionState(p, param);
            if (state.getStatus() != SuppressionState.SStatus.OUI_SANS_RESERVE) continue;
            res.add(p);
        }
        res.sort(Comparator.comparing(e -> e.dateCreation));
        return res;
    }
}

