/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.produit;

import fr.amapj.common.CollectionUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.produitextended.reglesconversion.ProduitLimiteQuantite;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionStock;
import fr.amapj.model.models.web.WebPage;
import fr.amapj.service.services.produit.ProduitDTO;
import fr.amapj.service.services.produitextended.ProduitExtendedService;
import fr.amapj.service.services.web.WebPageDTO;
import fr.amapj.service.services.web.WebPageService;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.util.List;
import java.util.stream.Collectors;

public class ProduitService {
    @DbRead
    public List<ProduitDTO> getAllProduitDTO(Long idProducteur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select p from Produit p where p.producteur.id=:prd order by p.nom,p.conditionnement");
            em.setParameter("prd", idProducteur);
            List<ProduitDTO> list = em.result().listConverted(Produit.class, e -> this.createProduitDto((Produit)e, em, false));
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return list;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public ProduitDTO loadProduit(Long idProduit) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Produit p = em.find(Produit.class, idProduit);
            ProduitDTO produitDTO = this.createProduitDto(p, em, true);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return produitDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private ProduitDTO createProduitDto(Produit p, RdbLink em, boolean full) {
        ProduitDTO dto = new ProduitDTO();
        dto.id = p.getId();
        dto.nom = p.nom;
        dto.conditionnement = p.conditionnement;
        dto.producteurId = p.producteur.getId();
        if (full && p.producteur.gestionStock == ProducteurStockGestion.OUI) {
            RegleConversionStock r = new ProduitExtendedService().loadRegleConversionProduit(em, p.producteur).findReglesConversionStock(p.id);
            dto.limiteQuantite = r.limiteQuantite;
            dto.coefficient = r.coefficient;
            dto.idProduitEnStock = r.idProduitEnStock;
        }
        return dto;
    }

    @DbWrite
    public Long update(ProduitDTO dto, boolean create) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Produit p = create ? new Produit() : em.find(Produit.class, dto.id);
            p.nom = dto.nom;
            p.conditionnement = dto.conditionnement;
            p.producteur = em.find(Producteur.class, dto.producteurId);
            if (create) {
                em.persist(p);
            }
            new ProduitExtendedService().saveRegleConversionOneProduit(p, dto, em);
            Long l = p.getId();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteProduit(Long idItemToSuppress) throws UnableToSuppressException {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Produit p = em.find(Produit.class, idItemToSuppress);
            this.verifContrat(p, em);
            this.verifProduitExtendedParam(p, em);
            if (p.webPage != null) {
                new WebPageService().delete(em, p.webPage.id);
            }
            em.remove(p);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void verifProduitExtendedParam(Produit p, RdbLink em) {
        RegleConversionProduit regles = new ProduitExtendedService().loadRegleConversionProduit(em, p.producteur);
        for (RegleConversionStock r : regles.regleStocks) {
            if (r.limiteQuantite != ProduitLimiteQuantite.SUIVI_AVEC_REGLE_CALCUL || r.idProduitEnStock == null || !r.idProduitEnStock.equals(p.id)) continue;
            Produit plie = em.find(Produit.class, r.idProduit);
            throw new UnableToSuppressException("Cet produit est pr\u00e9sent dans une r\u00e9gle de calcul pour le stock. Produit li\u00e9 : " + plie.nom + ", " + plie.conditionnement);
        }
        List toRemove = regles.regleStocks.stream().filter(e -> e.idProduit.equals(produit.id)).collect(Collectors.toList());
        regles.regleStocks.removeAll(toRemove);
        new ProduitExtendedService().saveRegleConversionProduit(regles, p.producteur, em);
    }

    private void verifContrat(Produit p, RdbLink em) throws UnableToSuppressException {
        em.createQuery("select distinct(c.modeleContrat) from ModeleContratProduit c WHERE c.produit=:p");
        em.setParameter("p", p);
        List<ModeleContrat> mcs = em.result().list(ModeleContrat.class);
        if (mcs.size() > 0) {
            String str = CollectionUtils.asStdString(mcs, t -> t.nom);
            throw new UnableToSuppressException("Cet produit est pr\u00e9sent dans " + mcs.size() + " contrats : " + str);
        }
    }

    @DbRead
    public String prettyString(Long idProduit) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (idProduit == null) {
                string = "";
            } else {
                Produit p = em.find(Produit.class, idProduit);
                string = String.valueOf(p.nom) + "," + p.conditionnement;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public WebPageDTO loadWebPage(Long idProduit) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Produit p = em.find(Produit.class, idProduit);
            WebPageDTO webPageDTO = new WebPageService().loadWebPage(em, p.webPage);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return webPageDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbWrite
    public void saveWebPage(Long idProduit, WebPageDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Produit p = em.find(Produit.class, idProduit);
            new WebPageService().saveWebPage(em, dto, e -> {
                WebPage webPage = produit.webPage = e;
            });
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

