/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.remiseproducteur;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDatePaiement;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.remise.RemiseProducteur;
import fr.amapj.service.services.remiseproducteur.PaiementRemiseDTO;
import fr.amapj.service.services.remiseproducteur.RemiseDTO;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class RemiseProducteurService {
    @DbRead
    public List<RemiseDTO> getAllRemise(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            ArrayList<RemiseDTO> res = new ArrayList<RemiseDTO>();
            Query q = em.createQuery("select r from RemiseProducteur r WHERE r.datePaiement.modeleContrat=:mc ORDER BY r.datePaiement.datePaiement");
            q.setParameter("mc", (Object)mc);
            List remises = q.getResultList();
            SimpleDateFormat df = FormatUtils.getLiteralMonthDate();
            for (RemiseProducteur remise : remises) {
                RemiseDTO mcInfo = this.createRemiseInfo(em, remise, df);
                res.add(mcInfo);
            }
            ArrayList<RemiseDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public RemiseDTO createRemiseInfo(RdbLink em, RemiseProducteur remise, SimpleDateFormat df) {
        RemiseDTO info = new RemiseDTO();
        info.idModeleContrat = remise.datePaiement.modeleContrat.getId();
        info.dateCreation = remise.dateCreation;
        info.dateReelleRemise = remise.dateRemise;
        info.dateTheoRemise = remise.datePaiement.datePaiement;
        info.id = remise.getId();
        info.mnt = remise.montant;
        info.moisRemise = df.format(info.dateTheoRemise);
        info.nbCheque = this.getNbCheque(em, remise);
        return info;
    }

    private int getNbCheque(RdbLink em, RemiseProducteur remise) {
        Query q = em.createQuery("select count(p) from Paiement p WHERE p.remise=:r");
        q.setParameter("r", (Object)remise);
        return ((Long)q.getSingleResult()).intValue();
    }

    @DbRead
    public List<RemiseDTO> getNextRemise(Long idModeleContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            List<ModeleContratDatePaiement> dates = this.getDatePaiementSansRemise(em, mc);
            SimpleDateFormat df = FormatUtils.getLiteralMonthDate();
            ArrayList<RemiseDTO> res = new ArrayList<RemiseDTO>();
            for (ModeleContratDatePaiement modeleContratDatePaiement : dates) {
                RemiseDTO dto = this.createVirtualRemise(modeleContratDatePaiement, em, idModeleContrat, df);
                res.add(dto);
            }
            ArrayList<RemiseDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private RemiseDTO createVirtualRemise(ModeleContratDatePaiement datePaiement, RdbLink em, Long idModeleContrat, SimpleDateFormat df) {
        RemiseDTO info = new RemiseDTO();
        info.idModeleContratDatePaiement = datePaiement.getId();
        info.dateTheoRemise = datePaiement.datePaiement;
        info.idModeleContrat = idModeleContrat;
        info.moisRemise = df.format(info.dateTheoRemise);
        List<Paiement> paiements = this.getPaiement(em, datePaiement);
        info.nbCheque = paiements.size();
        info.mnt = 0;
        for (Paiement paiement : paiements) {
            info.mnt += paiement.montant;
            PaiementRemiseDTO dto = new PaiementRemiseDTO();
            dto.idPaiement = paiement.getId();
            dto.montant = paiement.montant;
            dto.nomUtilisateur = paiement.contrat.utilisateur.nom;
            dto.prenomUtilisateur = paiement.contrat.utilisateur.prenom;
            dto.etatPaiement = paiement.etat;
            dto.commentaire1 = paiement.commentaire1;
            dto.commentaire2 = paiement.commentaire2;
            dto.commentaire3 = paiement.commentaire3;
            dto.commentaire4 = paiement.commentaire4;
            info.paiements.add(dto);
        }
        return info;
    }

    @DbRead
    public RemiseDTO prepareRemise(Long idModeleContrat) {
        try {
            RemiseDTO remiseDTO;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            List<RemiseDTO> nextRemises = this.getNextRemise(idModeleContrat);
            if (nextRemises.size() == 0) {
                RemiseDTO dto = new RemiseDTO();
                dto.preparationRemiseFailed = true;
                dto.messageRemiseFailed = "Il n'y a plus de remise \u00e0 faire pour ce contrat";
                remiseDTO = dto;
            } else {
                RemiseDTO nextRemise = nextRemises.get(0);
                List<String> chequesManquants = this.getChequesManquants(nextRemise);
                if (chequesManquants.size() != 0) {
                    nextRemise.preparationRemiseFailed = true;
                    nextRemise.messageRemiseFailed = "Il n'est pas possible de r\u00e9aliser la remise. Il manque les ch\u00e8ques de : <br/>" + StringUtils.asString(chequesManquants, "<br/>") + this.getInfo();
                    remiseDTO = nextRemise;
                } else {
                    nextRemise.preparationRemiseFailed = false;
                    remiseDTO = nextRemise;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return remiseDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String getInfo() {
        return "<br/><br/>Pour r\u00e9soudre le probl\u00e8me, vous devez aller dans R\u00e9ception des ch\u00e8ques, et supprimer les ch\u00e8ques qui vous manquent, ou alors les reporter sur un autre mois";
    }

    private List<String> getChequesManquants(RemiseDTO nextRemise) {
        ArrayList<String> strs = new ArrayList<String>();
        for (PaiementRemiseDTO paiement : nextRemise.paiements) {
            if (paiement.etatPaiement == EtatPaiement.AMAP) continue;
            strs.add(String.valueOf(paiement.nomUtilisateur) + " " + paiement.prenomUtilisateur + " - " + new CurrencyTextFieldConverter().convertToString(paiement.montant) + " \u20ac");
        }
        return strs;
    }

    public List<ModeleContratDatePaiement> getDatePaiementSansRemise(RdbLink em, ModeleContrat mc) {
        Query q = em.createQuery("select d from ModeleContratDatePaiement d WHERE d.modeleContrat=:mc and  NOT EXISTS (select r from RemiseProducteur r where r.datePaiement = d) order by d.datePaiement");
        q.setParameter("mc", (Object)mc);
        List us = q.getResultList();
        return us;
    }

    private List<Paiement> getPaiement(RdbLink em, ModeleContratDatePaiement datePaiement) {
        Query q = em.createQuery("select p from Paiement p WHERE p.modeleContratDatePaiement=:d ORDER BY p.contrat.utilisateur.nom , p.contrat.utilisateur.prenom");
        q.setParameter("d", (Object)datePaiement);
        return q.getResultList();
    }

    @DbWrite
    public Long performRemise(RemiseDTO remiseDTO) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RemiseProducteur remiseProducteur = new RemiseProducteur();
            remiseProducteur.dateCreation = DateUtils.getDate();
            remiseProducteur.datePaiement = em.find(ModeleContratDatePaiement.class, remiseDTO.idModeleContratDatePaiement);
            remiseProducteur.dateRemise = remiseDTO.dateReelleRemise;
            remiseProducteur.montant = remiseDTO.mnt;
            em.persist(remiseProducteur);
            for (PaiementRemiseDTO paiement : remiseDTO.paiements) {
                Paiement p = em.find(Paiement.class, paiement.idPaiement);
                p.etat = EtatPaiement.PRODUCTEUR;
                p.remise = remiseProducteur;
            }
            Long l = remiseProducteur.id;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void deleteRemise(Long idItemToSuppress) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            RemiseProducteur remiseProducteur = em.find(RemiseProducteur.class, idItemToSuppress);
            List<Paiement> paiements = this.getPaiement(em, remiseProducteur);
            for (Paiement p : paiements) {
                p.etat = EtatPaiement.AMAP;
                p.remise = null;
            }
            em.remove(remiseProducteur);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private List<Paiement> getPaiement(RdbLink em, RemiseProducteur remise) {
        Query q = em.createQuery("select p from Paiement p WHERE p.remise=:r ORDER BY p.contrat.utilisateur.nom, p.contrat.utilisateur.prenom");
        q.setParameter("r", (Object)remise);
        return q.getResultList();
    }

    @DbRead
    public RemiseDTO loadRemise(Long idRemise) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            SimpleDateFormat df = FormatUtils.getLiteralMonthDate();
            RemiseProducteur remiseProducteur = em.find(RemiseProducteur.class, idRemise);
            RemiseDTO res = this.createRemiseInfo(em, remiseProducteur, df);
            List<Paiement> paiements = this.getPaiement(em, remiseProducteur);
            for (Paiement paiement : paiements) {
                PaiementRemiseDTO dto = new PaiementRemiseDTO();
                dto.idPaiement = paiement.getId();
                dto.etatPaiement = paiement.etat;
                dto.montant = paiement.montant;
                dto.nomUtilisateur = paiement.contrat.utilisateur.nom;
                dto.prenomUtilisateur = paiement.contrat.utilisateur.prenom;
                dto.commentaire1 = paiement.commentaire1;
                dto.commentaire2 = paiement.commentaire2;
                dto.commentaire3 = paiement.commentaire3;
                dto.commentaire4 = paiement.commentaire4;
                res.paiements.add(dto);
                if (paiement.etat == EtatPaiement.PRODUCTEUR) continue;
                throw new RuntimeException("Erreur pour " + paiement.contrat.utilisateur.nom + paiement.contrat.utilisateur.prenom + " le cheque n'a pas le bon \u00e9tat");
            }
            RemiseDTO remiseDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return remiseDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    @DbRead
    public List<ModeleContratDatePaiementInfo> getAllDatesPaiementsInfo(RdbLink em, ModeleContrat mc) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            TypedQuery<ModeleContratDatePaiement> q = em.createQuery("select p from ModeleContratDatePaiement p WHERE p.modeleContrat=:mc order by p.datePaiement", ModeleContratDatePaiement.class);
            q.setParameter("mc", (Object)mc);
            List paiements = q.getResultList();
            TypedQuery<RemiseProducteur> q2 = em.createQuery("select r from RemiseProducteur r  WHERE r.datePaiement.modeleContrat=:mc", RemiseProducteur.class);
            q2.setParameter("mc", (Object)mc);
            List remises = q2.getResultList();
            ArrayList<ModeleContratDatePaiementInfo> res = new ArrayList<ModeleContratDatePaiementInfo>();
            for (ModeleContratDatePaiement modeleContratDatePaiement : paiements) {
                ModeleContratDatePaiementInfo info = new ModeleContratDatePaiementInfo();
                info.modeleContratDatePaiement = modeleContratDatePaiement;
                info.remiseDone = this.computeRemiseDone(modeleContratDatePaiement, remises);
                res.add(info);
            }
            ArrayList<ModeleContratDatePaiementInfo> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private boolean computeRemiseDone(ModeleContratDatePaiement modeleContratDatePaiement, List<RemiseProducteur> remises) {
        for (RemiseProducteur remiseProducteur : remises) {
            if (!remiseProducteur.datePaiement.id.equals(modeleContratDatePaiement.id)) continue;
            return true;
        }
        return false;
    }

    public static class ModeleContratDatePaiementInfo {
        public ModeleContratDatePaiement modeleContratDatePaiement;
        public boolean remiseDone;
    }
}

