/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.saisie;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStock;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStockProduit;
import fr.amapj.model.models.produitextended.reglesconversion.RegleConversionProduit;
import fr.amapj.service.services.produitextended.ProduitExtendedService;
import fr.amapj.service.services.stockservice.saisie.SaisieStockDTO;
import fr.amapj.service.services.stockservice.verifstock.VerifStockDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class SaisieStockService {
    @DbRead
    public SaisieStockDTO loadStockInfo(Long idModeleContrat, boolean loadStockOther, int nbJourRef) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            SaisieStockDTO dto = new SaisieStockDTO();
            Date ref = DateUtils.addDays(DateUtils.getDateWithNoTime(), nbJourRef);
            List<Long> idModeleContrats = this.findAllModeleContrat(em, mc, ref);
            dto.modeleContratId = mc.id;
            dto.nomModeleContrats = this.computeNom(mc, idModeleContrats, em);
            dto.modeleContratStockGestion = mc.stockGestion;
            dto.modeleContratStockIdentiqueDate = mc.stockIdentiqueDate;
            dto.modeleContratStockMultiContrat = mc.stockMultiContrat;
            VerifStockDTO verif = new VerifStockDTO();
            RegleConversionProduit regles = new ProduitExtendedService().loadRegleConversionProduit(em, mc.producteur);
            verif.addAllDates(this.findAllDates(em, mc, ref));
            List<ModeleContratProduit> mcps = this.getAllProduitInFutur(em, idModeleContrats);
            ArrayList<Long> additionalProduits = new ArrayList<Long>();
            verif.addAllProduits(mcps, true, em, mc.producteur, additionalProduits, regles);
            verif.computeHasConsommateurCommandable(idModeleContrats, regles, em, ref);
            if (loadStockOther) {
                verif.insertQteCommandeOther(em, mc, null);
            }
            QteDispoStock qteDispoStock = verif.insertQteDispoStock(em, mc);
            verif.completeInfoProduitAndSortProduit(em);
            dto.verifStockDTO = verif;
            dto.qteDispoStock = qteDispoStock;
            SaisieStockDTO saisieStockDTO = dto;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return saisieStockDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<String> computeNom(ModeleContrat mc, List<Long> idModeleContrats, RdbLink em) {
        ArrayList<String> res = new ArrayList<String>();
        for (Long id : idModeleContrats) {
            res.add(em.find(ModeleContrat.class, (Object)id).nom);
        }
        return res;
    }

    private List<Long> findAllModeleContrat(RdbLink em, ModeleContrat mc, Date ref) {
        switch (mc.stockMultiContrat) {
            case NON: {
                return this.computeProdsAndDatesMonoContrat(em, mc);
            }
            case OUI: {
                return this.computeProdsAndDatesMultiContrat(em, mc, ref);
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<Long> computeProdsAndDatesMonoContrat(RdbLink em, ModeleContrat mc) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(mc.id);
        return ids;
    }

    private List<Long> computeProdsAndDatesMultiContrat(RdbLink em, ModeleContrat mc, Date ref) {
        TypedQuery<Long> q = em.createQuery("select distinct(c.modeleContrat.id) from ModeleContratDate c where c.modeleContrat.producteur=:p AND c.modeleContrat.stockGestion=:g AND c.modeleContrat.stockMultiContrat=:m AND c.dateLiv >= :dateRef ORDER BY c.modeleContrat.id", Long.class);
        q.setParameter("p", (Object)mc.producteur);
        q.setParameter("g", (Object)StockGestion.OUI);
        q.setParameter("m", (Object)StockMultiContrat.OUI);
        q.setParameter("dateRef", (Object)ref);
        return q.getResultList();
    }

    private List<Date> findAllDates(RdbLink em, ModeleContrat mc, Date ref) {
        switch (mc.stockMultiContrat) {
            case NON: {
                return this.findAllDatesMonoContrat(em, mc, ref);
            }
            case OUI: {
                return this.findAllDatesMultiContrat(em, mc, ref);
            }
        }
        throw new AmapjRuntimeException();
    }

    private List<Date> findAllDatesMonoContrat(RdbLink em, ModeleContrat mc, Date ref) {
        TypedQuery<Date> q = em.createQuery("select c.dateLiv from ModeleContratDate c where c.modeleContrat=:mc AND c.dateLiv >= :dateRef ORDER BY c.dateLiv", Date.class);
        q.setParameter("mc", (Object)mc);
        q.setParameter("dateRef", (Object)ref);
        return q.getResultList();
    }

    private List<Date> findAllDatesMultiContrat(RdbLink em, ModeleContrat mc, Date ref) {
        TypedQuery<Date> q = em.createQuery("select distinct(c.dateLiv) from ModeleContratDate c where c.modeleContrat.producteur=:p AND c.modeleContrat.stockGestion=:g AND c.modeleContrat.stockMultiContrat=:m AND c.dateLiv >= :dateRef ORDER BY c.dateLiv", Date.class);
        q.setParameter("p", (Object)mc.producteur);
        q.setParameter("g", (Object)StockGestion.OUI);
        q.setParameter("m", (Object)StockMultiContrat.OUI);
        q.setParameter("dateRef", (Object)ref);
        return q.getResultList();
    }

    private List<ModeleContratProduit> getAllProduitInFutur(RdbLink em, List<Long> idModeleContrats) {
        if (idModeleContrats.size() == 0) {
            return new ArrayList<ModeleContratProduit>();
        }
        TypedQuery<ModeleContratProduit> q = em.createQuery("select c from ModeleContratProduit c where c.modeleContrat.id IN :ids ", ModeleContratProduit.class);
        q.setParameter("ids", idModeleContrats);
        return q.getResultList();
    }

    @DbWrite
    public void saveStockInfo(SaisieStockDTO s) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Date ref = DateUtils.addDays(DateUtils.getDateWithNoTime(), -30);
            ArrayList<QteDispoStockProduit> toRemove = new ArrayList<QteDispoStockProduit>();
            for (QteDispoStockProduit p : s.qteDispoStock.qteDispoStockProduits) {
                if (p.date == null || !p.date.before(ref)) continue;
                toRemove.add(p);
            }
            s.qteDispoStock.qteDispoStockProduits.removeAll(toRemove);
            new ProduitExtendedService().saveQteDispoStock(s.qteDispoStock, s.modeleContratId, em);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }
}

