/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.verifstock;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.service.services.stockservice.verifstock.ProduitCdeDTO;
import fr.amapj.service.services.stockservice.verifstock.Qte;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class Consommateur {
    public double coefficient;
    public ProduitCdeDTO produitCdeDTO;

    public void consommerOther(Qte qte, int indexDate) {
        qte.decr((double)this.produitCdeDTO.qteOther[indexDate] * this.coefficient);
    }

    public void consommerMe(Qte qte, int indexDate) {
        qte.decr((double)this.produitCdeDTO.qteMe[indexDate] * this.coefficient);
    }

    public boolean isStockSuffisant(Qte qte, int indexDate) {
        int qteMe = this.produitCdeDTO.qteMe[indexDate];
        if (qteMe == 0) {
            return true;
        }
        qte.decr((double)qteMe * this.coefficient);
        return !qte.isNegative();
    }

    public void computePrettyMessage(List<String> res, RdbLink em, SimpleDateFormat df, Qte qte, int indexDate, Date date) {
        int qteMe = this.produitCdeDTO.qteMe[indexDate];
        if (qteMe == 0) {
            return;
        }
        int restant = qte.getRestant(this.coefficient);
        qte.decr((double)qteMe * this.coefficient);
        if (qte.isNegative()) {
            Produit p = em.find(Produit.class, this.produitCdeDTO.idProduit);
            res.add("Date : " + df.format(date) + " Produit= " + p.nom + ", " + p.conditionnement);
            res.add("La quantit\u00e9 maximum autoris\u00e9e est " + restant);
            res.add("");
        }
    }

    public void addDebugInfo(List<String> ls, int indexDate, RdbLink em) {
        Produit p = em.find(Produit.class, this.produitCdeDTO.idProduit);
        ls.add("\tProduit Command\u00e9 = " + p.nom + "," + p.conditionnement);
        ls.add("\tCoefficient = " + this.coefficient);
        ls.add("\tQte Command\u00e9e = " + this.produitCdeDTO.qteOther[indexDate]);
        ls.add("");
    }
}

