/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.stockservice.verifstock;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.service.services.stockservice.verifstock.Consommateur;
import fr.amapj.service.services.stockservice.verifstock.ProduitCdeDTO;
import fr.amapj.service.services.stockservice.verifstock.ProduitEnStockDTO;
import fr.amapj.service.services.stockservice.verifstock.Qte;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifStockDateDTO {
    public List<ProduitEnStockDTO> prodStocks = new ArrayList<ProduitEnStockDTO>();
    public Map<Long, Consommateur> mapIdProdCdeConsommateur = new HashMap<Long, Consommateur>();
    public Map<Long, ProduitEnStockDTO> mapIdProdStockPodStock = new HashMap<Long, ProduitEnStockDTO>();

    public boolean isStockSuffisant(int indexDate) {
        for (ProduitEnStockDTO prodStock : this.prodStocks) {
            if (prodStock.isStockSuffisant(indexDate)) continue;
            return false;
        }
        return true;
    }

    public void computePrettyMessage(List<String> res, RdbLink em, SimpleDateFormat df, int indexDate, Date date) {
        for (ProduitEnStockDTO prodStock : this.prodStocks) {
            prodStock.computePrettyMessage(res, em, df, indexDate, date);
        }
    }

    public boolean isOneMoreAvailable(Long produitId, int indexDate) {
        Consommateur consommateur = this.findConsommateur(produitId);
        if (consommateur == null) {
            return true;
        }
        ProduitEnStockDTO produitEnStockDTO = consommateur.produitCdeDTO.produitEnStockDTO;
        Qte qteRestante = produitEnStockDTO.getQteRestante(indexDate);
        return qteRestante.greaterOrEqual(consommateur.coefficient);
    }

    public List<Long> computeProduitCommandeIds() {
        ArrayList<Long> res = new ArrayList<Long>();
        for (ProduitEnStockDTO p : this.prodStocks) {
            for (Consommateur consommateur : p.consommateurs) {
                res.add(consommateur.produitCdeDTO.idProduit);
            }
        }
        return res;
    }

    public void addDebugInfo(List<String> ls, int indexDate, RdbLink em) {
        for (ProduitEnStockDTO produitEnStockDTO : this.prodStocks) {
            produitEnStockDTO.addDebugInfo(ls, indexDate, em);
        }
    }

    public Consommateur findConsommateur(Long produitIdCommande) {
        return this.mapIdProdCdeConsommateur.get(produitIdCommande);
    }

    public ProduitEnStockDTO findProduitEnStockDTO(Long idProduitEnStock) {
        return this.mapIdProdStockPodStock.get(idProduitEnStock);
    }

    public void createProduitEnStockAndConsommateur(Long idProduitEnStock, Long idProduitCommande, double coefficient, int datesSize, boolean fullInfo, ModeleContratProduit mcp) {
        ProduitEnStockDTO prodStock = this.findProduitEnStockDTO(idProduitEnStock);
        boolean create = false;
        if (prodStock == null) {
            create = true;
            prodStock = new ProduitEnStockDTO();
            prodStock.idProduit = idProduitEnStock;
            prodStock.qteDispo = new int[datesSize];
            prodStock.hasConsommateurCommandable = new boolean[datesSize];
            this.prodStocks.add(prodStock);
            this.mapIdProdStockPodStock.put(idProduitEnStock, prodStock);
        }
        if (fullInfo) {
            this.completeFullInfo(prodStock, create, mcp);
        }
        this.addConsommateur(idProduitCommande, coefficient, datesSize, prodStock);
    }

    private void completeFullInfo(ProduitEnStockDTO prodStock, boolean create, ModeleContratProduit mcp) {
        if (create) {
            prodStock.indx = mcp != null ? mcp.indx : -1;
            prodStock.prix = mcp != null ? mcp.prix : 0;
            prodStock.idModeleContrat = mcp != null ? mcp.modeleContrat.id : null;
        } else {
            if (prodStock.idModeleContrat == null && mcp != null) {
                prodStock.idModeleContrat = mcp.modeleContrat.id;
                prodStock.prix = mcp.prix;
                prodStock.indx = mcp.indx;
            }
            if (prodStock.idModeleContrat != null && mcp != null && mcp.modeleContrat.id < prodStock.idModeleContrat) {
                prodStock.idModeleContrat = mcp.modeleContrat.id;
                prodStock.prix = mcp.prix;
                prodStock.indx = mcp.indx;
            }
        }
    }

    public void addConsommateurIfNeeded(Long idProduitEnStock, Long idProduitCommande, double coefficient, int datesSize) {
        ProduitEnStockDTO prodStock = this.findProduitEnStockDTO(idProduitEnStock);
        if (prodStock == null) {
            return;
        }
        Consommateur c = prodStock.findConsommateur(idProduitCommande);
        if (c == null) {
            this.addConsommateur(idProduitCommande, coefficient, datesSize, prodStock);
        }
    }

    private void addConsommateur(Long idProduitCommande, double coefficient, int datesSize, ProduitEnStockDTO prodStock) {
        ProduitCdeDTO produitCdeDTO = new ProduitCdeDTO();
        produitCdeDTO.produitEnStockDTO = prodStock;
        produitCdeDTO.idProduit = idProduitCommande;
        produitCdeDTO.qteMe = new int[datesSize];
        produitCdeDTO.qteOther = new int[datesSize];
        Consommateur c = new Consommateur();
        c.coefficient = coefficient;
        c.produitCdeDTO = produitCdeDTO;
        prodStock.consommateurs.add(c);
        this.mapIdProdCdeConsommateur.put(idProduitCommande, c);
    }
}

