/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.utilisateur.util;

import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.utilisateur.util.IUtilisateur;
import java.util.List;

public class UtilisateurUtil {
    public static boolean canSendMailTo(Utilisateur u) {
        return UtilisateurUtil.canSendMailTo(u.email);
    }

    public static boolean canSendMailTo(String email) {
        if (email == null) {
            return false;
        }
        return !email.endsWith("#");
    }

    public static String libMail(Utilisateur u) {
        if (UtilisateurUtil.canSendMailTo(u)) {
            return u.email;
        }
        return "";
    }

    public static String asStringPrenomFirst(List<? extends IUtilisateur> ls, String sep) {
        if (ls.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < ls.size() - 1) {
            IUtilisateur l = ls.get(i);
            str.append(String.valueOf(l.getPrenom()) + " " + l.getNom());
            str.append(sep);
            ++i;
        }
        IUtilisateur l = ls.get(ls.size() - 1);
        str.append(String.valueOf(l.getPrenom()) + " " + l.getNom());
        return str.toString();
    }

    public static String getUtilisateurImpactes(List<Utilisateur> utilisateurs) {
        StringBuffer buf = new StringBuffer();
        if (utilisateurs.size() == 0) {
            buf.append("Aucun utilisateur n'est impact\u00e9 par cette modification.<br/>");
            return buf.toString();
        }
        buf.append("Les " + utilisateurs.size() + " utilisateurs suivants sont impact\u00e9s par cette modification :<br/>");
        for (Utilisateur utilisateur : utilisateurs) {
            String warning = "";
            if (!UtilisateurUtil.canSendMailTo(utilisateur)) {
                warning = "<b>Utilisateur sans e mail !</b>";
            }
            buf.append(" - " + utilisateur.nom + " " + utilisateur.prenom + warning + "<br/>");
        }
        buf.append("<br/>");
        buf.append("Liste des adresses e-mail :<br/>");
        for (Utilisateur utilisateur : utilisateurs) {
            if (!UtilisateurUtil.canSendMailTo(utilisateur)) continue;
            buf.append(String.valueOf(utilisateur.email) + ";");
        }
        return buf.toString();
    }

    public static EmailInfo getEmailsInfos(List<Utilisateur> utilisateurs) {
        EmailInfo res = new EmailInfo();
        for (Utilisateur utilisateur : utilisateurs) {
            if (UtilisateurUtil.canSendMailTo(utilisateur)) {
                ++res.nbUtilisateurAvecEmail;
                res.utilisateurAvecEmail = String.valueOf(res.utilisateurAvecEmail) + utilisateur.email + ";";
                continue;
            }
            ++res.nbUtilisateurSansEmail;
            res.utilisateurSansEmail = String.valueOf(res.utilisateurSansEmail) + utilisateur.nom + " " + utilisateur.prenom + ";";
        }
        return res;
    }

    public static class EmailInfo {
        public int nbUtilisateurAvecEmail;
        public String utilisateurAvecEmail = "";
        public int nbUtilisateurSansEmail;
        public String utilisateurSansEmail = "";
    }
}

