/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.web;

import fr.amapj.common.StringUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.web.WebPage;
import fr.amapj.service.services.web.WebPageDTO;
import java.util.function.Consumer;

public class WebPageService {
    @DbRead
    public WebPageDTO loadWebPage(Long idWebPage) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            WebPage webPage = em.find(WebPage.class, idWebPage);
            WebPageDTO webPageDTO = this.loadWebPage(em, webPage);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return webPageDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public WebPageDTO loadWebPage(RdbLink em, WebPage webPage) {
        if (webPage == null) {
            return new WebPageDTO();
        }
        WebPageDTO dto = new WebPageDTO();
        dto.id = webPage.id;
        dto.content = StringUtils.fromBytes(webPage.getHtml());
        return dto;
    }

    public WebPage saveWebPage(RdbLink em, WebPageDTO dto, Consumer<WebPage> updater) {
        WebPage p;
        if (dto.content == null) {
            if (dto.id == null) {
                return null;
            }
            updater.accept(null);
            this.delete(em, dto.id);
            return null;
        }
        if (dto.id == null) {
            p = new WebPage();
            em.persist(p);
            updater.accept(p);
        } else {
            p = em.find(WebPage.class, dto.id);
        }
        p.setHtml(em, StringUtils.toBytes(dto.content));
        return p;
    }

    public void delete(RdbLink em, Long webPageId) {
        WebPage p = em.find(WebPage.class, webPageId);
        p.setHtml(em, null);
        em.remove(p);
    }
}

