/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.collectioneditor;

import com.vaadin.data.Buffered;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.BeanItem;
import com.vaadin.event.Action;
import com.vaadin.event.FieldEvents;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.collectioneditor.Row;
import fr.amapj.view.engine.collectioneditor.RowList;
import fr.amapj.view.engine.collectioneditor.columns.ColumnInfo;
import fr.amapj.view.engine.collectioneditor.columns.SearcherColumn;
import fr.amapj.view.engine.enumselector.EnumSearcher;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.engine.searcher.SearcherDefinition;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectionEditor<BEANTYPE>
extends CustomField
implements Action.Handler {
    private static final Logger logger = LogManager.getLogger();
    private final Action add = new Action(this.getMasterDetailAddItemCaption());
    private final Action remove = new Action(this.getMasterDetailRemoveItemCaption());
    private final Action up = new Action(this.getMasterDetailUpItemCaption());
    private final Action down = new Action(this.getMasterDetailDownItemCaption());
    private Table table;
    private BeanItem item;
    private Object propertyId;
    private Class<BEANTYPE> beanType;
    private RowList rows;
    private List<ColumnInfo> columns;
    private boolean btnAjouter = true;
    private boolean btnSupprimer = true;
    private boolean btnMonter = true;
    private boolean btnDescendre = true;
    private String propertyIdBeanToPreserve;

    public CollectionEditor(String caption, BeanItem item, Object propertyId, Class<BEANTYPE> beanType) {
        this.item = item;
        this.beanType = beanType;
        this.propertyId = propertyId;
        this.rows = new RowList();
        this.columns = new ArrayList<ColumnInfo>();
        this.setCaption(caption);
    }

    public void addColumn(String propertyId, String title, FieldType fieldType, Object defaultValue) {
        this.columns.add(new ColumnInfo(propertyId, title, fieldType, true, defaultValue));
    }

    public void addColumn(String propertyId, String title, FieldType fieldType, boolean editable, Object defaultValue) {
        this.columns.add(new ColumnInfo(propertyId, title, fieldType, editable, defaultValue));
    }

    public void addSearcherColumn(String propertyId, String title, FieldType fieldType, Object defaultValue, SearcherDefinition searcher, Searcher linkedSearcher) {
        this.columns.add(new SearcherColumn(propertyId, title, fieldType, true, defaultValue, searcher, linkedSearcher));
    }

    public void addSearcherColumn(String propertyId, String title, FieldType fieldType, boolean editable, Object defaultValue, SearcherDefinition searcher, Searcher linkedSearcher) {
        this.columns.add(new SearcherColumn(propertyId, title, fieldType, editable, defaultValue, searcher, linkedSearcher));
    }

    private void buildTable() {
        this.table = new Table();
        this.table.addStyleName("no-stripes");
        this.table.addStyleName("no-vertical-lines");
        this.table.addStyleName("no-horizontal-lines");
        for (ColumnInfo col : this.columns) {
            Class clazz = this.getFieldAsClass(col.fieldType);
            this.table.addContainerProperty((Object)col.title, clazz, null);
        }
        List beans = (List)this.item.getItemProperty(this.propertyId).getValue();
        for (Object bean : beans) {
            this.addRow(bean);
        }
        this.table.setPageLength(10);
        this.table.addActionHandler((Action.Handler)this);
        this.table.setEditable(true);
        this.table.setSelectable(true);
        this.table.setImmediate(true);
        this.table.setSortEnabled(false);
    }

    private Class getFieldAsClass(FieldType fieldType) {
        switch (fieldType) {
            case STRING: {
                return TextField.class;
            }
            case SEARCHER: {
                return ComboBox.class;
            }
            case CURRENCY: {
                return TextField.class;
            }
            case QTE: {
                return TextField.class;
            }
            case INTEGER: {
                return TextField.class;
            }
            case DATE: {
                return PopupDateField.class;
            }
            case CHECK_BOX: {
                return CheckBox.class;
            }
            case COMBO: {
                return ComboBox.class;
            }
        }
        throw new AmapjRuntimeException();
    }

    private AbstractField getField(FieldType fieldType, ColumnInfo col) {
        switch (fieldType) {
            case STRING: {
                TextField str = new TextField();
                str.addStyleName("text");
                return str;
            }
            case SEARCHER: {
                SearcherColumn s = (SearcherColumn)col;
                Searcher box = new Searcher(s.searcher, null);
                if (s.linkedSearcher != null) {
                    box.setLinkedSearcher(s.linkedSearcher);
                }
                box.addStyleName("searcher");
                return box;
            }
            case CURRENCY: {
                TextField currency = BaseUiTools.createCurrencyField("", false);
                currency.addStyleName("currency");
                return currency;
            }
            case QTE: {
                TextField qte = BaseUiTools.createQteField("");
                qte.addStyleName("qte");
                return qte;
            }
            case INTEGER: {
                TextField integer = BaseUiTools.createIntegerField("");
                integer.addStyleName("integer");
                return integer;
            }
            case DATE: {
                PopupDateField dateField = BaseUiTools.createDateField("");
                dateField.addStyleName("date");
                return dateField;
            }
            case CHECK_BOX: {
                CheckBox checkBox = BaseUiTools.createCheckBoxField("");
                checkBox.addStyleName("checkbox");
                return checkBox;
            }
            case COMBO: {
                ComboBox combo = EnumSearcher.createEnumSearcher("", (Enum)col.defaultValue);
                combo.addStyleName("combo");
                return combo;
            }
        }
        throw new AmapjRuntimeException();
    }

    private void addRow(BEANTYPE bean) {
        Row row = new Row();
        BeanItem beanItem = null;
        if (bean != null) {
            beanItem = new BeanItem(bean);
        }
        for (ColumnInfo col : this.columns) {
            Object val1 = col.defaultValue;
            if (beanItem != null) {
                val1 = beanItem.getItemProperty((Object)col.propertyId).getValue();
            }
            AbstractField f = this.getField(col.fieldType, col);
            f.setConvertedValue(val1);
            f.setReadOnly(!col.editable);
            if (this.shouldHaveFocusNotifier(f, col.editable)) {
                FieldEvents.FocusNotifier tf = (FieldEvents.FocusNotifier)f;
                tf.addFocusListener((FieldEvents.FocusListener & Serializable)e -> this.table.select(row.getItemId()));
            }
            row.addField(f);
        }
        Object idInfo = this.getIdBeanInfo(beanItem);
        this.rows.add(row, idInfo);
        this.table.addItem(row.getColumnTable(), row.getItemId());
    }

    private boolean shouldHaveFocusNotifier(AbstractField f, boolean editable) {
        if (!(f instanceof FieldEvents.FocusNotifier)) {
            return false;
        }
        if (editable) {
            return true;
        }
        return !(f instanceof TextField);
    }

    private void remove(Object itemId) {
        if (itemId == null) {
            return;
        }
        Object selectedRow = this.rows.remove(itemId);
        this.table.removeItem(itemId);
        if (selectedRow != null) {
            this.table.select(selectedRow);
        }
    }

    protected Table getTable() {
        return this.table;
    }

    protected String getMasterDetailRemoveItemCaption() {
        return "Supprimer";
    }

    protected String getMasterDetailAddItemCaption() {
        return "Ajouter";
    }

    protected String getMasterDetailUpItemCaption() {
        return "Monter";
    }

    protected String getMasterDetailDownItemCaption() {
        return "Descendre";
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (action == this.add) {
            this.addRow(null);
        } else if (action == this.remove) {
            this.remove(target);
        } else if (action == this.up) {
            this.up(target);
        } else if (action == this.down) {
            this.down(target);
        }
    }

    private void down(Object target) {
        if (target == null) {
            return;
        }
        int index = this.rows.getIndex(target);
        if (!this.rows.canDown(index)) {
            return;
        }
        Object itemId = this.rows.downRow(index);
        this.table.select(itemId);
    }

    private void up(Object target) {
        if (target == null) {
            return;
        }
        int index = this.rows.getIndex(target);
        if (!this.rows.canUp(index)) {
            return;
        }
        Object itemId = this.rows.upRow(index);
        this.table.select(itemId);
    }

    public Action[] getActions(Object target, Object sender) {
        ArrayList<Action> acts = new ArrayList<Action>();
        if (this.btnAjouter) {
            acts.add(this.add);
        }
        if (this.btnSupprimer) {
            acts.add(this.remove);
        }
        if (this.btnMonter) {
            acts.add(this.up);
        }
        if (this.btnDescendre) {
            acts.add(this.down);
        }
        return acts.toArray(new Action[acts.size()]);
    }

    public Object getValue() {
        return this.computeValue();
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        List<BEANTYPE> ls = this.computeValue();
        this.item.getItemProperty(this.propertyId).setValue(ls);
    }

    private List<BEANTYPE> computeValue() {
        try {
            ArrayList<BEANTYPE> ls = new ArrayList<BEANTYPE>();
            for (Row row : this.rows.getRows()) {
                BEANTYPE elt = this.beanType.newInstance();
                BeanItem beanItem = new BeanItem(elt);
                int i = 0;
                for (ColumnInfo col : this.columns) {
                    Object val = row.getFieldValue(i);
                    beanItem.getItemProperty((Object)col.propertyId).setValue(val);
                    ++i;
                }
                this.setIdBeanInfo(beanItem, row.getIdBeanInfo());
                ls.add(elt);
            }
            return ls;
        }
        catch (Property.ReadOnlyException | IllegalAccessException | InstantiationException e) {
            logger.warn("Commit failed", e);
            throw new RuntimeException("Erreur inattendue", e);
        }
    }

    public Class<?> getType() {
        return List.class;
    }

    public Collection getElements() {
        return (Collection)this.getPropertyDataSource().getValue();
    }

    protected Component initContent() {
        VerticalLayout vl = new VerticalLayout();
        vl.addStyleName("collection-editor");
        this.buildTable();
        vl.addComponent((Component)this.getTable());
        if (this.hasOneButtonOrMore()) {
            this.addButtons(vl);
        }
        return vl;
    }

    private void addButtons(VerticalLayout vl) {
        HorizontalLayout buttons = new HorizontalLayout();
        if (this.btnAjouter) {
            buttons.addComponent((Component)new Button(this.getMasterDetailAddItemCaption(), (Button.ClickListener & Serializable)e -> this.addRow(null)));
        }
        if (this.btnSupprimer) {
            buttons.addComponent((Component)new Button(this.getMasterDetailRemoveItemCaption(), (Button.ClickListener & Serializable)e -> this.remove(this.getTable().getValue())));
        }
        if (this.btnMonter) {
            buttons.addComponent((Component)new Button(this.getMasterDetailUpItemCaption(), (Button.ClickListener & Serializable)e -> this.up(this.getTable().getValue())));
        }
        if (this.btnDescendre) {
            buttons.addComponent((Component)new Button(this.getMasterDetailDownItemCaption(), (Button.ClickListener & Serializable)e -> this.down(this.getTable().getValue())));
        }
        vl.addComponent((Component)buttons);
    }

    private boolean hasOneButtonOrMore() {
        return this.btnAjouter || this.btnSupprimer || this.btnMonter || this.btnDescendre;
    }

    public void activeButton(boolean btnAjouter, boolean btnSupprimer, boolean btnMonter, boolean btnDescendre) {
        this.btnAjouter = btnAjouter;
        this.btnSupprimer = btnSupprimer;
        this.btnMonter = btnMonter;
        this.btnDescendre = btnDescendre;
    }

    public void disableAllButtons() {
        this.activeButton(false, false, false, false);
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.disableAllButtons();
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.editable = false;
            }
        }
    }

    public void addBeanIdToPreserve(String propertyIdBeanToPreserve) {
        this.propertyIdBeanToPreserve = propertyIdBeanToPreserve;
    }

    private Object getIdBeanInfo(BeanItem beanItem) {
        if (this.propertyIdBeanToPreserve == null) {
            return null;
        }
        if (beanItem == null) {
            return null;
        }
        return beanItem.getItemProperty((Object)this.propertyIdBeanToPreserve).getValue();
    }

    private void setIdBeanInfo(BeanItem beanItem, Object idBeanInfo) {
        if (this.propertyIdBeanToPreserve == null) {
            return;
        }
        beanItem.getItemProperty((Object)this.propertyIdBeanToPreserve).setValue(idBeanInfo);
    }
}

