/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.excelgenerator;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Link;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.FileInfoDTO;
import fr.amapj.view.engine.excelgenerator.CoreResource;
import java.io.ByteArrayInputStream;
import java.io.Serializable;

public class LinkCreator {
    public static Link createLink(CoreGenerator generator) {
        return LinkCreator.createLink(generator, true);
    }

    public static Link createLink(CoreGenerator generator, boolean addPrefixTelecharger) {
        FileInfoDTO fileInfoDTO = new CoreGeneratorService().getFileInfo(generator);
        String titre = fileInfoDTO.nameToDisplay;
        String fileName = fileInfoDTO.fileName;
        String extension = fileInfoDTO.extension;
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource)new CoreResource(fileInfoDTO.generator), String.valueOf(fileName) + "." + extension);
        streamResource.setCacheTime(1000L);
        String lien = addPrefixTelecharger ? "T\u00e9l\u00e9charger " + titre : titre;
        Link extractFile = new Link(lien, (Resource)streamResource);
        extractFile.setIcon((Resource)FontAwesome.DOWNLOAD);
        extractFile.setTargetName("_blank");
        return extractFile;
    }

    public static Link createLink(String fileName, String linkName, byte[] bs) {
        if (bs == null) {
            throw new AmapjRuntimeException();
        }
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(bs), fileName);
        streamResource.setCacheTime(1000L);
        Link extractFile = new Link(linkName, (Resource)streamResource);
        extractFile.setIcon((Resource)FontAwesome.DOWNLOAD);
        extractFile.setTargetName("_blank");
        return extractFile;
    }
}

