/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid;

import fr.amapj.view.engine.grid.GridHeaderLine;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public class GridSizeCalculator {
    public int getHeight(String cellValue, int cellWidth, String fontName, int fontSize) {
        if (cellValue == null || cellValue.length() == 0) {
            return 1;
        }
        Font currFont = new Font(fontName, 0, fontSize);
        AttributedString attrStr = new AttributedString(cellValue);
        attrStr.addAttribute(TextAttribute.FONT, currFont);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        LineBreakMeasurer measurer = new LineBreakMeasurer(attrStr.getIterator(), frc);
        int nextPos = 0;
        int lineCnt = 0;
        while (measurer.getPosition() < cellValue.length()) {
            nextPos = measurer.nextOffset(cellWidth);
            ++lineCnt;
            measurer.setPosition(nextPos);
        }
        return lineCnt;
    }

    public int getHeightInPixel(String cellValue, int cellWidth, String fontName, int fontSize) {
        int nbLine = this.getHeight(cellValue, cellWidth, fontName, fontSize);
        int margin = 9;
        int height = fontSize + margin;
        return height * nbLine;
    }

    public static void autoSize(GridHeaderLine line, int cellWidth, String fontName, int fontSize) {
        int nbLine = 1;
        GridSizeCalculator cal = new GridSizeCalculator();
        for (GridHeaderLine.GridHeaderLineCell cell : line.cells) {
            if (cell.content == null) continue;
            nbLine = Math.max(nbLine, cal.getHeight(cell.content, cellWidth, fontName, fontSize));
        }
        int margin = 6;
        int height = fontSize + margin;
        line.height = height * nbLine + 2;
    }
}

