/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid;

import com.vaadin.event.ShortcutListener;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import fr.amapj.view.engine.grid.GridIJData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShortCutManager {
    private int nbLig;
    private int nbCol;
    private Map<GridIJData, TextField> cells = new HashMap<GridIJData, TextField>();
    private List<ShortCutLine> lines;

    public ShortCutManager(List<ShortCutLine> lines) {
        this.lines = lines;
        this.nbLig = lines.size();
        this.nbCol = this.nbLig == 0 ? 0 : lines.get((int)0).editable.length;
    }

    public void addShorcut(Window w) {
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(13, Key.ENTER));
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(107, Key.PLUS));
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(39, Key.RIGHT));
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(37, Key.LEFT));
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(38, Key.UP));
        w.addShortcutListener((ShortcutListener)new ShortcutListenerImpl(40, Key.DOWN));
    }

    protected void processAction(Key key, Object target) {
        if (!(target instanceof TextField)) {
            return;
        }
        TextField from = (TextField)target;
        GridIJData fromIJ = (GridIJData)from.getData();
        GridIJData toIJ = this.findNext(key, fromIJ);
        if (toIJ != null) {
            TextField to = this.cells.get(toIJ);
            to.selectAll();
            to.focus();
        }
    }

    private GridIJData findNext(Key key, GridIJData fromIJ) {
        while ((fromIJ = this.createNext(key, fromIJ)) != null && !this.isEditable(fromIJ)) {
        }
        return fromIJ;
    }

    private GridIJData createNext(Key key, GridIJData fromIJ) {
        switch (key) {
            case ENTER: 
            case DOWN: {
                return this.createNextDown(fromIJ);
            }
            case UP: {
                return this.createNextUp(fromIJ);
            }
            case RIGHT: {
                return this.createNextRight(fromIJ);
            }
            case LEFT: {
                return this.createNextLeft(fromIJ);
            }
            case PLUS: {
                return this.createNextPlus(fromIJ);
            }
        }
        throw new RuntimeException("Erreur inattendue");
    }

    private GridIJData createNextPlus(GridIJData fromIJ) {
        if (fromIJ.i() == this.nbLig - 1 && fromIJ.j() == this.nbCol - 1) {
            return null;
        }
        if (fromIJ.j() == this.nbCol - 1) {
            return new GridIJData(fromIJ.i() + 1, 0);
        }
        return new GridIJData(fromIJ.i(), fromIJ.j() + 1);
    }

    private GridIJData createNextUp(GridIJData fromIJ) {
        if (fromIJ.i() == 0) {
            return null;
        }
        return new GridIJData(fromIJ.i() - 1, fromIJ.j());
    }

    private GridIJData createNextDown(GridIJData fromIJ) {
        if (fromIJ.i() == this.nbLig - 1) {
            return null;
        }
        return new GridIJData(fromIJ.i() + 1, fromIJ.j());
    }

    private GridIJData createNextRight(GridIJData fromIJ) {
        if (fromIJ.j() == this.nbCol - 1) {
            return null;
        }
        return new GridIJData(fromIJ.i(), fromIJ.j() + 1);
    }

    private GridIJData createNextLeft(GridIJData fromIJ) {
        if (fromIJ.j() == 0) {
            return null;
        }
        return new GridIJData(fromIJ.i(), fromIJ.j() - 1);
    }

    private boolean isEditable(GridIJData fromIJ) {
        ShortCutLine line = this.lines.get(fromIJ.i());
        if (!line.isVisible) {
            return false;
        }
        return line.editable[fromIJ.j()];
    }

    public void registerTextField(TextField tf) {
        GridIJData ij = (GridIJData)tf.getData();
        this.cells.put(ij, tf);
    }

    public static enum Key {
        ENTER,
        UP,
        DOWN,
        RIGHT,
        LEFT,
        PLUS;

    }

    public static class ShortCutLine {
        public boolean isVisible = true;
        public boolean[] editable;
    }

    class ShortcutListenerImpl
    extends ShortcutListener {
        private Key key;

        public ShortcutListenerImpl(int keyCode, Key key) {
            super("", keyCode, null);
            this.key = key;
        }

        public void handleAction(Object sender, Object target) {
            ShortCutManager.this.processAction(this.key, target);
        }
    }
}

