/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.integergrid;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.WebBrowser;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.grid.ErreurSaisieException;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridIJData;
import fr.amapj.view.engine.grid.ShortCutManager;
import fr.amapj.view.engine.grid.integergrid.IntegerGridCell;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.IntegerGridParam;
import fr.amapj.view.engine.grid.integergrid.lignecumul.LigneCumulManager;
import fr.amapj.view.engine.grid.utils.HelpPopupSupplier;
import fr.amapj.view.engine.notification.NotificationHelper;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class PopupIntegerGrid
extends CorePopup {
    private Table table;
    protected IntegerGridParam param = new IntegerGridParam();
    private ShortCutManager shortCutManager;
    private Label labelMessageSpecifiqueBottom;
    private LigneCumulManager ligneCumulManager;

    public abstract void loadParam();

    public abstract boolean performSauvegarder();

    public abstract int getLineHeight(boolean var1);

    public abstract int getHeaderHeight();

    @Override
    protected void createContent(VerticalLayout mainLayout) {
        this.setType(CorePopup.PopupType.CENTERFIT);
        this.loadParam();
        this.ligneCumulManager = new LigneCumulManager(this.param);
        if (this.param.messageSpecifique != null && this.param.messageSpecifique.length() > 0) {
            Label messageSpeLabel = new Label(this.param.messageSpecifique, ContentMode.HTML);
            messageSpeLabel.addStyleName("popup-integer-grid-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.switchButtonAction != null) {
            Button btn = new Button((Resource)FontAwesome.ROTATE_RIGHT);
            btn.addStyleName("leftpart");
            btn.addStyleName("borderless-colored");
            btn.addStyleName("question-mark");
            btn.addClickListener((Button.ClickListener & Serializable)e -> this.param.switchButtonAction.run());
            mainLayout.addComponent((Component)btn);
            mainLayout.setComponentAlignment((Component)btn, Alignment.TOP_RIGHT);
            this.addStyleNameForMainLayout("no-padding-top");
        }
        for (GridHeaderLine line : this.param.headerLines) {
            line.constructHeaderLine(mainLayout, this.param.leftPartLineLargeur, this.param.largeurCol);
        }
        this.table = new Table();
        this.table.addStyleName("no-vertical-lines");
        this.table.addStyleName("no-horizontal-lines");
        this.table.addStyleName("no-stripes");
        this.table.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.table.addContainerProperty((Object)new Integer(-1), HorizontalLayout.class, null);
        this.table.setColumnWidth((Object)new Integer(-1), this.param.leftPartLineLargeur);
        int i = 0;
        while (i < this.param.nbCol) {
            Class clzz = this.param.readOnly ? Label.class : TextField.class;
            this.table.addContainerProperty((Object)new Integer(i), clzz, null);
            this.table.setColumnWidth((Object)new Integer(i), this.param.largeurCol);
            ++i;
        }
        if (!this.param.readOnly) {
            this.shortCutManager = new ShortCutManager(this.computeShortCutManager());
            this.shortCutManager.addShorcut(this.getWindow());
        }
        boolean hasHelpLeftPart = this.param.lines.stream().anyMatch(e -> e.hasLeftPartHelp());
        int i2 = 0;
        while (i2 < this.param.nbLig) {
            this.addRow(i2, hasHelpLeftPart);
            ++i2;
        }
        if (this.param.readOnly) {
            this.table.setEditable(false);
        } else {
            this.table.setEditable(true);
        }
        this.table.setSelectable(true);
        this.table.setSortEnabled(false);
        this.table.setPageLength(this.getPageLength());
        mainLayout.addComponent((Component)this.table);
        HorizontalLayout footer0 = new HorizontalLayout();
        footer0.setWidth("200px");
        footer0.setHeight("20px");
        mainLayout.addComponent((Component)footer0);
        this.ligneCumulManager.createContent(mainLayout);
        if (this.param.messageSpecifiqueBottom != null && this.param.messageSpecifiqueBottom.length() > 0) {
            this.labelMessageSpecifiqueBottom = new Label(this.param.messageSpecifiqueBottom, ContentMode.HTML);
            this.labelMessageSpecifiqueBottom.addStyleName("popup-integer-grid-message");
            mainLayout.addComponent((Component)this.labelMessageSpecifiqueBottom);
        }
    }

    private List<ShortCutManager.ShortCutLine> computeShortCutManager() {
        ArrayList<ShortCutManager.ShortCutLine> res = new ArrayList<ShortCutManager.ShortCutLine>();
        int i = 0;
        while (i < this.param.nbLig) {
            ShortCutManager.ShortCutLine line = new ShortCutManager.ShortCutLine();
            line.isVisible = this.param.lines.get((int)i).isVisible;
            line.editable = new boolean[this.param.nbCol];
            int j = 0;
            while (j < this.param.nbCol) {
                line.editable[j] = !this.param.cell[i][j].isStaticText;
                ++j;
            }
            res.add(line);
            ++i;
        }
        return res;
    }

    @Override
    protected void createButtonBar() {
        if (this.param.readOnly) {
            this.addButtonBlank();
            this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleContinuer());
        } else {
            if (this.param.buttonCopyFirstLine && this.param.getNbLineVisible() > 1) {
                this.addButton("Copier la 1\u00e8re ligne partout", (Button.ClickListener & Serializable)e -> this.handleCopier());
            }
            this.addButtonBlank();
            this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            Button saveButton = this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
            saveButton.addStyleName("primary");
        }
    }

    protected void handleCopier() {
        try {
            this.doHandleCopier();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotification("Erreur de saisie sur la premiere ligne - Impossible de copier");
        }
    }

    private void doHandleCopier() throws ErreurSaisieException {
        int j = 0;
        while (j < this.param.nbCol) {
            int qteRef = -1;
            int i = 0;
            while (i < this.param.nbLig) {
                IntegerGridLine line = this.param.lines.get(i);
                IntegerGridCell c = this.param.cell[i][j];
                if (!c.isStaticText && line.isVisible) {
                    TextField tf = this.getTextField(i, j);
                    if (qteRef == -1) {
                        qteRef = this.readValueInCell(tf);
                    } else {
                        tf.setConvertedValue((Object)qteRef);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private int getPageLength() {
        Page page = UI.getCurrent().getPage();
        int pageLength = 15;
        int lineHeight = this.getLineHeight(this.param.readOnly);
        int headerAndButtonHeight = this.getHeaderHeight();
        int maxLineAvailable = (page.getBrowserWindowHeight() - headerAndButtonHeight) / lineHeight;
        maxLineAvailable = Math.max(maxLineAvailable, 4);
        pageLength = Math.min(pageLength, maxLineAvailable);
        WebBrowser webBrowser = UI.getCurrent().getPage().getWebBrowser();
        if (webBrowser.isIE() && webBrowser.getBrowserMajorVersion() < 9) {
            pageLength = Math.min(pageLength, 6);
        }
        pageLength = Math.min(pageLength, this.param.getNbLineVisible());
        return pageLength;
    }

    private void addRow(int lig, boolean hasHelpLeftPart) {
        IntegerGridLine line = this.param.lines.get(lig);
        if (!line.isVisible) {
            return;
        }
        ArrayList<Object> cells = new ArrayList<Object>();
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSpacing(false);
        hl.setMargin(false);
        if (hasHelpLeftPart) {
            HorizontalLayout h2 = new HorizontalLayout();
            h2.setSpacing(false);
            h2.setMargin(false);
            h2.setWidth("26px");
            h2.setHeight("100%");
            hl.addComponent((Component)h2);
            if (line.hasLeftPartHelp()) {
                Button btn = new Button((Resource)FontAwesome.QUESTION_CIRCLE);
                btn.addStyleName("leftpart");
                btn.addStyleName("borderless-colored");
                btn.addStyleName("question-mark");
                btn.addClickListener((Button.ClickListener & Serializable)e -> HelpPopupSupplier.displayHelpPopup(integerGridLine.leftPartHelpSupplier));
                h2.addComponent((Component)btn);
                h2.setComponentAlignment((Component)btn, Alignment.MIDDLE_LEFT);
            }
        }
        Label dateLabel = new Label(line.leftPart, ContentMode.HTML);
        dateLabel.addStyleName(this.param.leftPartLineStyle);
        hl.addComponent((Component)dateLabel);
        hl.setExpandRatio((Component)dateLabel, 1.0f);
        cells.add(hl);
        int j = 0;
        while (j < this.param.nbCol) {
            TextField tf;
            IntegerGridCell c = this.param.cell[lig][j];
            int qte = c.qte;
            if (this.param.readOnly) {
                String txt = c.isStaticText ? c.staticText : (qte == 0 ? "" : "" + qte);
                Label tf2 = new Label(txt);
                tf2.addStyleName("cell-voir");
                tf2.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
                cells.add(tf2);
            } else if (c.isStaticText) {
                tf = new TextField();
                tf.setValue(c.staticText);
                tf.setEnabled(false);
                tf.addStyleName("cell-voir");
                tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
                cells.add(tf);
            } else {
                tf = BaseUiTools.createQteField("");
                tf.setData((Object)new GridIJData(lig, j));
                if (qte == 0) {
                    tf.setConvertedValue(null);
                } else {
                    tf.setConvertedValue((Object)new Integer(qte));
                }
                tf.addValueChangeListener(new Property.ValueChangeListener(){

                    public void valueChange(Property.ValueChangeEvent event) {
                        try {
                            GridIJData ij = (GridIJData)tf.getData();
                            int qte = PopupIntegerGrid.this.readValueInCell(tf);
                            PopupIntegerGrid.this.param.updateQte(ij.i(), ij.j(), qte);
                            PopupIntegerGrid.this.ligneCumulManager.displayMontantTotal();
                        }
                        catch (ErreurSaisieException erreurSaisieException) {
                            NotificationHelper.displayNotificationQte();
                        }
                    }
                });
                tf.addStyleName("cell-saisie");
                tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
                this.shortCutManager.registerTextField(tf);
                cells.add(tf);
            }
            ++j;
        }
        this.table.addItem(cells.toArray(), (Object)new Integer(lig));
    }

    private int readValueInCell(TextField tf) throws ErreurSaisieException {
        try {
            Integer val = (Integer)tf.getConvertedValue();
            int qte = 0;
            if (val != null) {
                qte = val;
            }
            return qte;
        }
        catch (Converter.ConversionException conversionException) {
            throw new ErreurSaisieException();
        }
    }

    private TextField getTextField(int i, int j) {
        Item item1 = this.table.getItem((Object)new Integer(i));
        TextField tf1 = (TextField)item1.getItemProperty((Object)new Integer(j)).getValue();
        return tf1;
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleContinuer() {
        this.close();
    }

    protected void handleSauvegarder() {
        try {
            this.updateModele();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotificationQte();
            return;
        }
        if (!this.param.allowedEmpty && this.param.isEmpty()) {
            NotificationHelper.displayNotification("Vous devez saisir une quantit\u00e9 avant de continuer");
            return;
        }
        boolean ret = this.performSauvegarder();
        if (ret) {
            this.close();
        }
    }

    private void updateModele() throws ErreurSaisieException {
        int i = 0;
        while (i < this.param.nbLig) {
            IntegerGridLine line = this.param.lines.get(i);
            if (line.isVisible) {
                Item item = this.table.getItem((Object)new Integer(i));
                int j = 0;
                while (j < this.param.nbCol) {
                    IntegerGridCell c = this.param.cell[i][j];
                    if (!c.isStaticText) {
                        int qte;
                        TextField tf = (TextField)item.getItemProperty((Object)new Integer(j)).getValue();
                        c.qte = qte = this.readValueInCell(tf);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void updateLabelMessageSpecifiqueBottom(String msg) {
        this.labelMessageSpecifiqueBottom.setValue(msg);
    }

    protected void updateFirstCol(int lineNumber, String msg) {
        Item item = this.table.getItem((Object)new Integer(lineNumber));
        HorizontalLayout hl = (HorizontalLayout)item.getItemProperty((Object)new Integer(-1)).getValue();
        Label label = (Label)hl.getComponent(hl.getComponentCount() - 1);
        label.setValue(msg);
    }

    protected void updatePrixTotal() {
        this.ligneCumulManager.displayMontantTotal();
    }
}

