/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.integertable;

import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.view.engine.grid.ErreurSaisieException;
import fr.amapj.view.engine.grid.GridIJData;
import fr.amapj.view.engine.grid.GridSizeCalculator;
import fr.amapj.view.engine.grid.ShortCutManager;
import fr.amapj.view.engine.grid.integertable.IntegerTableCell;
import fr.amapj.view.engine.grid.integertable.IntegerTableParam;
import fr.amapj.view.engine.grid.utils.HelpPopupSupplier;
import fr.amapj.view.engine.notification.NotificationHelper;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.QteTextFieldConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class PopupIntegerTable
extends CorePopup {
    private Label prixTotal;
    protected IntegerTableParam param = new IntegerTableParam();
    private ShortCutManager shortCutManager;
    private Label labelMessageSpecifiqueBottom;
    private List<TextField> tfs = new ArrayList<TextField>();
    private int nbCol;
    private int nbRow;
    public int cellWidth;
    private int[] cellHeight;
    private int fullWidth;
    private boolean isHeightFull;

    public abstract void loadParam();

    public abstract boolean performSauvegarder();

    @Override
    protected void createContent(VerticalLayout mainLayout) {
        this.loadParam();
        this.computeWidthAndHeigth();
        this.setType(CorePopup.PopupType.FILL);
        this.setWidth(10, this.fullWidth);
        if (this.isHeightFull) {
            this.setHeight("100%");
        }
        if (this.param.messageSpecifique != null && this.param.messageSpecifique.length() > 0) {
            Label messageSpeLabel = new Label(this.param.messageSpecifique, ContentMode.HTML);
            messageSpeLabel.addStyleName("popup-integer-table-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.switchButtonAction != null) {
            Button btn = new Button((Resource)FontAwesome.ROTATE_LEFT);
            btn.addStyleName("leftpart");
            btn.addStyleName("borderless-colored");
            btn.addStyleName("question-mark");
            btn.addClickListener((Button.ClickListener & Serializable)e -> this.param.switchButtonAction.run());
            mainLayout.addComponent((Component)btn);
            mainLayout.setComponentAlignment((Component)btn, Alignment.TOP_RIGHT);
            this.addStyleNameForMainLayout("no-padding-top");
        }
        this.shortCutManager = new ShortCutManager(this.computeShortCutManager());
        this.shortCutManager.addShorcut(this.getWindow());
        GridLayout gd = new GridLayout(this.nbCol, this.nbRow);
        gd.setSpacing(true);
        mainLayout.addComponent((Component)gd);
        int i = 0;
        while (i < this.param.nbCell) {
            IntegerTableCell paramCell = this.param.cell[i];
            int row = i / this.nbCol;
            int col = i % this.nbCol;
            gd.addComponent(this.createCell(paramCell, row, col, i));
            ++i;
        }
        HorizontalLayout footer0 = new HorizontalLayout();
        footer0.setWidth("200px");
        footer0.setHeight("20px");
        mainLayout.addComponent((Component)footer0);
        if (this.param.hasLignePrixTotal) {
            this.prixTotal = new Label("", ContentMode.HTML);
            this.displayMontantTotal();
            mainLayout.addComponent((Component)this.prixTotal);
        }
    }

    private Component createCell(IntegerTableCell paramCell, int row, int col, int cellNumber) {
        Panel p = new Panel();
        p.addStyleName("popup-integer-table-panel");
        p.setWidth(String.valueOf(this.cellWidth) + "px");
        p.setHeight(String.valueOf(this.cellHeight[row]) + "px");
        VerticalLayout vl = new VerticalLayout();
        vl.setSizeFull();
        vl.setMargin(true);
        HorizontalLayout hl1 = new HorizontalLayout();
        hl1.setSpacing(false);
        hl1.setMargin(false);
        hl1.setWidth("100%");
        Label lib1Label = new Label(paramCell.lib1);
        hl1.addComponent((Component)lib1Label);
        hl1.setExpandRatio((Component)lib1Label, 1.0f);
        if (paramCell.helpSupplier.hasHelp()) {
            Button btn = new Button((Resource)FontAwesome.QUESTION_CIRCLE);
            btn.addStyleName("leftpart");
            btn.addStyleName("borderless-colored");
            btn.addStyleName("question-mark");
            btn.addClickListener((Button.ClickListener & Serializable)e -> HelpPopupSupplier.displayHelpPopup(integerTableCell.helpSupplier));
            hl1.addComponent((Component)btn);
            hl1.setComponentAlignment((Component)btn, Alignment.TOP_LEFT);
        }
        vl.addComponent((Component)hl1);
        BaseUiTools.addStdLabel((Layout)vl, paramCell.lib2, "");
        VerticalLayout vl2 = new VerticalLayout();
        vl2.setSizeFull();
        vl.addComponent((Component)vl2);
        vl.setExpandRatio((Component)vl2, 1.0f);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSpacing(true);
        hl.setWidth("100%");
        Label prixLabel = BaseUiTools.addHtmlLabel((Layout)hl, "<b>" + FormatUtils.prix(paramCell.prix) + "</b>", "");
        hl.setComponentAlignment((Component)prixLabel, Alignment.MIDDLE_LEFT);
        TextField tf = this.createTextField(paramCell, row, col, cellNumber);
        hl.addComponent((Component)tf);
        hl.setComponentAlignment((Component)tf, Alignment.MIDDLE_RIGHT);
        vl.addComponent((Component)hl);
        vl.setExpandRatio((Component)hl, 0.0f);
        p.setContent((Component)vl);
        return p;
    }

    private TextField createTextField(IntegerTableCell c, int row, int col, int cellNumber) {
        TextField tf = new TextField();
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        this.tfs.add(tf);
        tf.setWidth("70px");
        tf.addStyleName("cell-saisie");
        tf.setData((Object)new GridIJData(row, col));
        this.shortCutManager.registerTextField(tf);
        if (c.isStaticText) {
            tf.setValue(c.staticText);
            tf.setEnabled(false);
            return tf;
        }
        tf.setConverter((Converter)new QteTextFieldConverter());
        tf.setConvertedValue((Object)new Integer(c.qte));
        if (this.param.readOnly) {
            tf.setReadOnly(true);
            return tf;
        }
        tf.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleTextFieldChange(tf, cellNumber));
        return tf;
    }

    private void handleTextFieldChange(TextField tf, int cellNumber) {
        try {
            GridIJData cfr_ignored_0 = (GridIJData)tf.getData();
            int qte = this.readValueInCell(tf);
            this.param.updateQte(cellNumber, qte);
            this.displayMontantTotal();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotificationQte();
        }
    }

    private List<ShortCutManager.ShortCutLine> computeShortCutManager() {
        ArrayList<ShortCutManager.ShortCutLine> res = new ArrayList<ShortCutManager.ShortCutLine>();
        int i = 0;
        while (i < this.nbRow) {
            ShortCutManager.ShortCutLine line = new ShortCutManager.ShortCutLine();
            line.isVisible = true;
            line.editable = new boolean[this.nbCol];
            int j = 0;
            while (j < this.nbCol) {
                line.editable[j] = this.isEditable(i, j);
                ++j;
            }
            res.add(line);
            ++i;
        }
        return res;
    }

    private boolean isEditable(int i, int j) {
        int cellNumber = i * this.nbCol + j;
        if (cellNumber >= this.param.nbCell) {
            return false;
        }
        return !this.param.cell[cellNumber].isStaticText;
    }

    @Override
    protected void createButtonBar() {
        if (this.param.readOnly) {
            this.addButtonBlank();
            this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleContinuer());
        } else {
            this.addButtonBlank();
            this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            Button saveButton = this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
            saveButton.addStyleName("primary");
        }
    }

    private void displayMontantTotal() {
        if (this.prixTotal != null) {
            this.prixTotal.setValue("<b>" + this.param.libPrixTotal + " : " + FormatUtils.prix(this.param.getMontantTotal()) + "</b>");
        }
    }

    private int readValueInCell(TextField tf) throws ErreurSaisieException {
        try {
            Integer val = (Integer)tf.getConvertedValue();
            int qte = 0;
            if (val != null) {
                qte = val;
            }
            return qte;
        }
        catch (Converter.ConversionException conversionException) {
            throw new ErreurSaisieException();
        }
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleContinuer() {
        this.close();
    }

    protected void handleSauvegarder() {
        try {
            this.updateModele();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotificationQte();
            return;
        }
        if (!this.param.allowedEmpty && this.param.isEmpty()) {
            NotificationHelper.displayNotification("Vous devez saisir une quantit\u00e9 avant de continuer");
            return;
        }
        boolean ret = this.performSauvegarder();
        if (ret) {
            this.close();
        }
    }

    private void updateModele() throws ErreurSaisieException {
        int i = 0;
        while (i < this.param.nbCell) {
            IntegerTableCell c = this.param.cell[i];
            if (!c.isStaticText) {
                int qte;
                TextField tf = this.tfs.get(i);
                c.qte = qte = this.readValueInCell(tf);
            }
            ++i;
        }
    }

    protected void updateLabelMessageSpecifiqueBottom(String msg) {
        this.labelMessageSpecifiqueBottom.setValue(msg);
    }

    protected void updatePrixTotal() {
        this.displayMontantTotal();
    }

    private void computeWidthAndHeigth() {
        int width = BaseUiTools.getWidth();
        if (width < 600) {
            this.nbCol = 1;
            this.cellWidth = width - 45;
        } else if (width < 900) {
            this.nbCol = 2;
            this.cellWidth = 260;
        } else if (width < 1200) {
            this.nbCol = 3;
            this.cellWidth = 260;
        } else {
            this.nbCol = 4;
            this.cellWidth = 260;
            if (this.param.nbCell == 6 || this.param.nbCell == 9) {
                this.nbCol = 3;
                this.cellWidth = 260;
            }
        }
        this.nbRow = this.getNbRow();
        this.cellHeight = new int[this.nbRow];
        int i = 0;
        while (i < this.nbRow) {
            this.cellHeight[i] = this.computeHeight(i);
            ++i;
        }
        this.fullWidth = this.nbCol * (this.cellWidth + 11) + 64;
        this.isHeightFull = this.computeIsHeightFull();
    }

    private int computeHeight(int i) {
        int height = 0;
        int j = 0;
        while (j < this.nbCol) {
            height = Math.max(height, this.heightOf(i, j));
            ++j;
        }
        return height;
    }

    private int heightOf(int i, int j) {
        int index = this.index(i, j);
        if (index == -1) {
            return 0;
        }
        IntegerTableCell c = this.param.cell[index];
        boolean hasHelp = c.helpSupplier.hasHelp();
        return this.height(c.lib1, hasHelp) + this.height(c.lib2, false) + 80;
    }

    private int index(int i, int j) {
        int index = i * this.nbCol + j;
        if (index >= this.param.nbCell) {
            return -1;
        }
        return index;
    }

    private int height(String lib, boolean hasHelp) {
        int marge = 26 + (hasHelp ? 20 : 0);
        return new GridSizeCalculator().getHeightInPixel(lib, this.cellWidth - marge, "Arial", 16);
    }

    private int getNbRow() {
        int r = this.param.nbCell % this.nbCol;
        if (r == 0) {
            return this.param.nbCell / this.nbCol;
        }
        return this.param.nbCell / this.nbCol + 1;
    }

    private boolean computeIsHeightFull() {
        int fullHeight = 170;
        if (this.param.messageSpecifique != null && this.param.messageSpecifique.length() > 0) {
            fullHeight += 30;
        }
        int i = 0;
        while (i < this.cellHeight.length) {
            fullHeight = fullHeight + this.cellHeight[i] + 11;
            ++i;
        }
        return BaseUiTools.getHeight() <= fullHeight;
    }
}

