/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.libbutton;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.FormatUtils;
import fr.amapj.view.engine.grid.libbutton.LibButtonLine;
import fr.amapj.view.engine.grid.libbutton.LibButtonParam;
import fr.amapj.view.engine.notification.NotificationHelper;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.okcancelpopup.OKCancelMessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class PopupLibButton<T>
extends CorePopup {
    private Map<LibButtonLine<T>, Panel> panels = new HashMap<LibButtonLine<T>, Panel>();
    private Label prixTotal;
    protected LibButtonParam<T> param = new LibButtonParam();
    private Label labelMessageSpecifiqueBottom;
    private boolean isCompactMode;

    public abstract void loadParam();

    protected abstract void handleButton(LibButtonLine<T> var1);

    public abstract boolean performSauvegarder();

    @Override
    protected void createContent(VerticalLayout mainLayout) {
        this.setType(CorePopup.PopupType.FILL);
        this.setWidth(60, 960);
        this.setHeight("100%");
        this.loadParam();
        this.isCompactMode = BaseUiTools.isCompactMode();
        if (this.param.messageSpecifique != null && this.param.messageSpecifique.length() > 0) {
            Label messageSpeLabel = new Label(this.param.messageSpecifique, ContentMode.HTML);
            messageSpeLabel.addStyleName("popup-integer-grid-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.switchButtonAction != null) {
            Button btn = new Button((Resource)FontAwesome.ROTATE_LEFT);
            btn.addStyleName("leftpart");
            btn.addStyleName("borderless-colored");
            btn.addStyleName("question-mark");
            btn.addClickListener((Button.ClickListener & Serializable)e -> this.param.switchButtonAction.run());
            mainLayout.addComponent((Component)btn);
            mainLayout.setComponentAlignment((Component)btn, Alignment.TOP_RIGHT);
            this.addStyleNameForMainLayout("no-padding-top");
        }
        int i = 0;
        while (i < this.param.nbLig) {
            LibButtonLine line = this.param.lines.get(i);
            if (line.isVisible) {
                mainLayout.addComponent(this.createLine(line));
            }
            ++i;
        }
        mainLayout.addComponent((Component)new Label("<br/>", ContentMode.HTML));
        if (this.param.hasLignePrixTotal) {
            this.prixTotal = new Label("", ContentMode.HTML);
            this.displayMontantTotal();
            mainLayout.addComponent((Component)this.prixTotal);
        }
        if (this.param.messageSpecifiqueBottom != null && this.param.messageSpecifiqueBottom.length() > 0) {
            this.labelMessageSpecifiqueBottom = new Label(this.param.messageSpecifiqueBottom, ContentMode.HTML);
            this.labelMessageSpecifiqueBottom.addStyleName("popup-integer-grid-message");
            mainLayout.addComponent((Component)this.labelMessageSpecifiqueBottom);
        }
    }

    private Component createLine(LibButtonLine<T> line) {
        Panel p = new Panel();
        this.fillPanel(p, line);
        this.panels.put(line, p);
        return p;
    }

    protected void refreshLine(LibButtonLine<T> line) {
        Panel p = this.panels.get(line);
        this.fillPanel(p, line);
    }

    private void fillPanel(Panel p, LibButtonLine<T> line) {
        if (this.isCompactMode) {
            p.addStyleName("popup-lib-button-panel-compactmode");
            this.fillPanelCompactMode(p, line);
        } else {
            p.addStyleName("popup-lib-button-panel");
            this.fillPanelStdMode(p, line);
        }
    }

    private void fillPanelStdMode(Panel p, LibButtonLine<T> line) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("100%");
        hl.setMargin(true);
        Label tf1 = new Label(line.lib1, ContentMode.HTML);
        tf1.addStyleName("popup-lib-button-lib1");
        tf1.setIcon((Resource)FontAwesome.CALENDAR_O);
        tf1.setWidth("80px");
        hl.addComponent((Component)tf1);
        hl.setComponentAlignment((Component)tf1, Alignment.MIDDLE_CENTER);
        Label tf2 = new Label(line.lib2.lib, ContentMode.HTML);
        tf2.addStyleName(line.lib2.styleName);
        hl.addComponent((Component)tf2);
        hl.setExpandRatio((Component)tf2, 1.0f);
        hl.setComponentAlignment((Component)tf2, Alignment.MIDDLE_CENTER);
        if (line.hasButton) {
            Button b = new Button(line.buttonLib);
            b.addClickListener((Button.ClickListener & Serializable)e -> this.handleButton(line));
            hl.addComponent((Component)b);
            hl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
        }
        p.setContent((Component)hl);
    }

    private void fillPanelCompactMode(Panel p, LibButtonLine<T> line) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("100%");
        hl.setMargin(true);
        hl.addStyleName("popup-lib-button-compactmode");
        VerticalLayout vl = new VerticalLayout();
        vl.setSizeUndefined();
        Label tf1 = new Label(line.lib1, ContentMode.HTML);
        tf1.addStyleName("popup-lib-button-lib1-compactmode");
        tf1.setIcon((Resource)FontAwesome.CALENDAR_O);
        tf1.setWidth("80px");
        vl.addComponent((Component)tf1);
        if (line.hasButton) {
            Button b = new Button(line.buttonLib);
            b.addClickListener((Button.ClickListener & Serializable)e -> this.handleButton(line));
            vl.addComponent((Component)b);
            vl.setComponentAlignment((Component)b, Alignment.MIDDLE_CENTER);
        }
        hl.addComponent((Component)vl);
        Label tf2 = new Label(line.lib2.lib, ContentMode.HTML);
        tf2.addStyleName(line.lib2.styleName);
        hl.addComponent((Component)tf2);
        hl.setExpandRatio((Component)tf2, 1.0f);
        hl.setComponentAlignment((Component)tf2, Alignment.MIDDLE_CENTER);
        p.setContent((Component)hl);
    }

    @Override
    protected void createButtonBar() {
        if (this.param.readOnly) {
            this.addButtonBlank();
            this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleContinuer());
        } else {
            if (this.param.copyFirstLineAction != null && this.param.getNbLineVisible() > 1) {
                this.addButtonCopyFirstLine();
            }
            this.addButtonBlank();
            this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            Button saveButton = this.addDefaultButton(this.param.libButtonSave, (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
            saveButton.addStyleName("primary");
        }
    }

    private void addButtonCopyFirstLine() {
        if (BaseUiTools.isCompactMode()) {
            this.addButton("Copier...", (Button.ClickListener & Serializable)e -> this.handleCopyWithConfirm());
        } else {
            this.addButton("Copier la 1\u00e8re ligne partout", (Button.ClickListener & Serializable)e -> this.param.copyFirstLineAction.run());
        }
    }

    private void handleCopyWithConfirm() {
        OKCancelMessagePopup popup = new OKCancelMessagePopup("Copier ...", "Etes vous sur de vouloir copier le contenu du panier de la premi\u00e8re date sur toutes les dates ? ", () -> this.param.copyFirstLineAction.run());
        popup.open();
    }

    protected void displayMontantTotal() {
        if (this.prixTotal != null) {
            this.prixTotal.setValue("<b>Montant total : " + FormatUtils.prix(this.param.getMontantTotal()) + "</b>");
        }
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleContinuer() {
        this.close();
    }

    protected void handleSauvegarder() {
        if (!this.param.allowedEmpty && this.param.isEmpty()) {
            NotificationHelper.displayNotification("Vous devez saisir une quantit\u00e9 avant de continuer");
            return;
        }
        boolean ret = this.performSauvegarder();
        if (ret) {
            this.close();
        }
    }
}

