/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.infoservlet;

import fr.amapj.messagingcenter.miniproxy.core.BasicHttpDeserializer;
import fr.amapj.messagingcenter.miniproxy.core.BasicHttpSerializer;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.view.engine.infoservlet.MonitorInfo;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InfoServlet
extends HttpServlet {
    private static final Logger logger = LogManager.getLogger();

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        InfoType type = this.getInfoType(req.getPathInfo());
        if (type == null) {
            return;
        }
        switch (type) {
            case MONITOR: {
                this.doMonitor(req, res);
                break;
            }
            case MAINTENANCE: {
                this.doMaintenance(res);
                break;
            }
            case BACKUP: {
                this.doBackup(req, res);
                break;
            }
            case APPINSTANCE_STAT_INFO: {
                this.doAppInstanceStatInfo(req, res);
                break;
            }
            case TABLE_SIZE: {
                this.doTableSize(req, res);
                break;
            }
        }
    }

    private InfoType getInfoType(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        if (pathInfo.startsWith("/monitor")) {
            return InfoType.MONITOR;
        }
        if (pathInfo.startsWith("/maintenance")) {
            return InfoType.MAINTENANCE;
        }
        if (pathInfo.startsWith("/backup")) {
            return InfoType.BACKUP;
        }
        if (pathInfo.startsWith("/appinstance_stat_info")) {
            return InfoType.APPINSTANCE_STAT_INFO;
        }
        if (pathInfo.startsWith("/table_size")) {
            return InfoType.TABLE_SIZE;
        }
        return null;
    }

    private void doMaintenance(HttpServletResponse res) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.write("<html><head><title></title></head><body>");
        out.write("<h1>Application non disponible</h1>");
        out.write("<p>D\u00e9sol\u00e9, l'application est en cours de maintenance ou votre abonnement a expir\u00e9. Merci de vous reconnecter plus tard.</p>");
        out.write("</body></html>");
    }

    private void doMonitor(HttpServletRequest req, HttpServletResponse res) throws IOException {
        logger.info("Debut du doMonitor");
        BasicHttpDeserializer bis = new BasicHttpDeserializer((InputStream)req.getInputStream());
        BasicHttpSerializer bos = new BasicHttpSerializer((OutputStream)res.getOutputStream());
        this.checkMaintenanceKey(bis);
        int top = bis.readInt();
        String str = MonitorInfo.performMonitorInfo(top == 1);
        bos.writeString(str);
        bos.flush();
    }

    private void doTableSize(HttpServletRequest req, HttpServletResponse res) throws IOException {
        logger.info("Debut du doTableSize");
        BasicHttpDeserializer bis = new BasicHttpDeserializer((InputStream)req.getInputStream());
        BasicHttpSerializer bos = new BasicHttpSerializer((OutputStream)res.getOutputStream());
        this.checkMaintenanceKey(bis);
        int size = bis.readInt();
        String str = new AppInstanceService().getSchemaAllBases(size == 1);
        bos.writeString(str);
        bos.flush();
    }

    private void doBackup(HttpServletRequest req, HttpServletResponse res) throws IOException {
        logger.info("Debut du backup");
        BasicHttpDeserializer bis = new BasicHttpDeserializer((InputStream)req.getInputStream());
        BasicHttpSerializer bos = new BasicHttpSerializer((OutputStream)res.getOutputStream());
        this.checkMaintenanceKey(bis);
        String backupDir = AppConfiguration.getConf().getBackupDirectory();
        String date = bis.readString();
        int i = 0;
        while (i < date.length()) {
            char c = date.charAt(i);
            if (!this.isAllowed(c)) {
                throw new IOException("Erreur de validit\u00e9 de la date - c=" + c);
            }
            ++i;
        }
        logger.info("Date du backup : " + date);
        File[] fs = new File(String.valueOf(backupDir) + "/" + date).listFiles();
        if (fs == null) {
            throw new IOException("Le repertoire " + backupDir + "/" + date + " n'existe pas.");
        }
        bos.writeInt(fs.length);
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            logger.info("Envoi du fichier : " + file.getName());
            bos.writeFile(file);
            ++n2;
        }
        bos.flush();
    }

    private boolean isAllowed(char c) {
        if (c == '_') {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    private void doAppInstanceStatInfo(HttpServletRequest req, HttpServletResponse res) throws IOException {
        BasicHttpDeserializer bis = new BasicHttpDeserializer((InputStream)req.getInputStream());
        BasicHttpSerializer bos = new BasicHttpSerializer((OutputStream)res.getOutputStream());
        this.checkMaintenanceKey(bis);
        String str = new AppInstanceService().getStatInfo();
        bos.writeGzipString(str);
        bos.flush();
    }

    private void checkMaintenanceKey(BasicHttpDeserializer bis) throws IOException {
        logger.info("Debut verification de la cle de maintenance");
        String maintenanceKey = AppConfiguration.getConf().getMaintenanceKey();
        String key = bis.readString(200);
        if (maintenanceKey.length() < 40 || !key.equals(maintenanceKey)) {
            logger.info("Cle de maintenance erronn\u00e9e ou trop courte");
            throw new IOException("Erreur dans la cl\u00e9 de maintenance");
        }
        logger.info("Cle de maintenance correcte");
    }

    public static enum InfoType {
        MONITOR,
        MAINTENANCE,
        BACKUP,
        APPINSTANCE_STAT_INFO,
        TABLE_SIZE;

    }
}

