/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.infoservlet;

import com.google.gson.Gson;
import com.sun.management.UnixOperatingSystemMXBean;
import fr.amapj.common.StackUtils;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class MonitorInfo {
    public int cpuLoad;
    public long diskFreeSpace;
    public long nbOpenFile;
    public long memInit;
    public long memMax;
    public long memUsed;
    public int threadNb;
    public int threadPeak;
    public int upTimeDays;
    public long totalGarbageCollections = 0L;
    public long garbageCollectionTime = 0L;
    public List<String> top = new ArrayList<String>();
    public String version;

    public String toString() {
        String str = "cpuLoad=" + this.cpuLoad + "<br/> diskFreeSpace=" + this.diskFreeSpace + "<br/> nbOpenFile=" + this.nbOpenFile + "<br/> memInit=" + this.memInit + "<br/> memMax=" + this.memMax + "<br/> memUsed=" + this.memUsed + "<br/> threadNb=" + this.threadNb + "<br/> threadPeak=" + this.threadPeak + "<br/> upTimeDays=" + this.upTimeDays + "<br/> totalGarbageCollections=" + this.totalGarbageCollections + "<br/> garbageCollectionTime=" + this.garbageCollectionTime + "<br/> ";
        str = String.valueOf(str) + "Top<br/><br/>";
        for (String s : this.top) {
            str = String.valueOf(str) + s + "<br/>";
        }
        return str;
    }

    public static MonitorInfo calculateMonitorInfo(boolean computeTop) {
        MonitorInfo info = new MonitorInfo();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.cpuLoad = (int)(os.getSystemLoadAverage() * 100.0);
        File f = new File("/");
        if (f.getTotalSpace() != 0L) {
            info.diskFreeSpace = f.getFreeSpace() * 100L / f.getTotalSpace();
        }
        if (os instanceof UnixOperatingSystemMXBean) {
            info.nbOpenFile = ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        }
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage mem = memBean.getHeapMemoryUsage();
        info.memInit = mem.getInit() / 0x100000L;
        info.memUsed = mem.getUsed() / 0x100000L;
        info.memMax = mem.getMax() / 0x100000L;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        info.threadNb = threadBean.getThreadCount();
        info.threadPeak = threadBean.getPeakThreadCount();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        info.upTimeDays = (int)(runtimeBean.getUptime() / 86400000L);
        List<GarbageCollectorMXBean> garbageBean = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : garbageBean) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                info.totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            info.garbageCollectionTime += time;
        }
        if (computeTop) {
            info.top = MonitorInfo.computeTopInfo();
        }
        info.version = new MaintenanceService().getVersion();
        return info;
    }

    private static List<String> computeTopInfo() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            ProcessBuilder builder = new ProcessBuilder("top", "-b", "-n", "1", "-e", "m", "-o", "%MEM");
            Process proc = builder.start();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = stdin.readLine()) != null) {
                    res.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            StackUtils.popStack(res, e);
        }
        return res;
    }

    public static String performMonitorInfo(boolean computeTopInfo) {
        MonitorInfo info = MonitorInfo.calculateMonitorInfo(computeTopInfo);
        return new Gson().toJson((Object)info);
    }

    public static void main(String[] args) {
        System.out.println(MonitorInfo.performMonitorInfo(false));
    }
}

