/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.listpart;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.ItemSorter;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.util.filter.Like;
import com.vaadin.data.util.filter.Or;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.listpart.ButtonHandler;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.ListPartItemSorter;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.template.ListPartView;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.tools.DateTimeToStringConverter;
import fr.amapj.view.engine.tools.DateToStringConverter;
import fr.amapj.view.engine.tools.TableItem;
import fr.amapj.view.engine.tools.TableTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public abstract class StandardListPart<T extends TableItem>
extends ListPartView
implements ComponentContainer,
PopupListener {
    private TextField searchField;
    private List<ButtonHandler> buttons = new ArrayList<ButtonHandler>();
    private String textFilter;
    private BeanItemContainer<T> mcInfos;
    private Table cdesTable;
    private Class<T> beanClazz;
    private boolean multiSelect;
    private List<ColInfo> cols = new ArrayList<ColInfo>();

    public StandardListPart(Class<T> beanClazz, boolean multiSelect) {
        this.beanClazz = beanClazz;
        this.multiSelect = multiSelect;
    }

    protected abstract String getTitle();

    protected abstract void drawButton();

    protected abstract void drawTable();

    protected void addSelectorComponent() {
    }

    protected void addExtraComponent() {
    }

    protected abstract List<T> getLines();

    protected abstract String[] getSortInfos();

    protected boolean[] getSortAsc() {
        return null;
    }

    protected abstract String[] getSearchInfos();

    protected boolean isEditAllowed() {
        return true;
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        this.buildMainArea();
    }

    public ColInfo addColumn(Object propertyId, String header) {
        return this.addColumnInternal(propertyId, header, null);
    }

    public ColInfo addColumnDateTime(Object propertyId, String header) {
        return this.addColumnInternal(propertyId, header, new DateTimeToStringConverter());
    }

    public ColInfo addColumnDate(Object propertyId, String header) {
        return this.addColumnInternal(propertyId, header, new DateToStringConverter());
    }

    public ColInfo addColumnCurrency(Object propertyId, String header) {
        return this.addColumnInternal(propertyId, header, new CurrencyTextFieldConverter());
    }

    public ColInfo addColumnGenerator(Object propertyId, String header, Table.ColumnGenerator generator) {
        ColInfo colInfo = new ColInfo();
        colInfo.propertyId = propertyId;
        colInfo.header = header;
        colInfo.generator = generator;
        this.cols.add(colInfo);
        return colInfo;
    }

    private ColInfo addColumnInternal(Object propertyId, String header, Converter<String, ?> converter) {
        ColInfo colInfo = new ColInfo();
        colInfo.propertyId = propertyId;
        colInfo.header = header;
        colInfo.converter = converter;
        this.cols.add(colInfo);
        return colInfo;
    }

    public void addButtonAction(String label, ButtonType type, final Runnable listener) {
        Button newButton = new Button(label);
        newButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                listener.run();
            }
        });
        ButtonHandler handler = new ButtonHandler();
        handler.button = newButton;
        handler.type = type;
        this.buttons.add(handler);
    }

    public void addButton(String label, ButtonType type, final Function<T, CorePopup> popupSupplier) {
        Button newButton = new Button(label);
        newButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                TableItem t = null;
                if (StandardListPart.this.multiSelect) {
                    Set s = (Set)StandardListPart.this.cdesTable.getValue();
                    if (s.size() == 1) {
                        t = (TableItem)s.iterator().next();
                    }
                } else {
                    t = (TableItem)StandardListPart.this.cdesTable.getValue();
                }
                CorePopup popup = (CorePopup)popupSupplier.apply(t);
                popup.open(() -> StandardListPart.this.onPopupClose());
            }
        });
        ButtonHandler handler = new ButtonHandler();
        handler.button = newButton;
        handler.type = type;
        this.buttons.add(handler);
    }

    public void addSearchField(String label) {
        this.searchField = new TextField();
        this.searchField.setInputPrompt(label);
        this.searchField.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent event) {
                StandardListPart.this.textFilter = event.getText();
                StandardListPart.this.updateFilters();
            }
        });
    }

    private void buildMainArea() {
        this.mcInfos = new BeanItemContainer(this.beanClazz);
        this.mcInfos.setItemSorter((ItemSorter)new ListPartItemSorter());
        this.cdesTable = this.createTable(this.mcInfos);
        this.drawTable();
        ArrayList<Object> colPropertyIds = new ArrayList<Object>();
        for (ColInfo col : this.cols) {
            this.cdesTable.setColumnHeader(col.propertyId, col.header);
            if (col.converter != null) {
                this.cdesTable.setConverter(col.propertyId, col.converter);
            }
            this.cdesTable.setColumnAlignment(col.propertyId, col.alignment);
            if (col.width != -1) {
                this.cdesTable.setColumnWidth(col.propertyId, col.width);
            }
            if (col.generator != null) {
                this.cdesTable.addGeneratedColumn(col.propertyId, col.generator);
            }
            colPropertyIds.add(col.propertyId);
        }
        this.cdesTable.setVisibleColumns(colPropertyIds.toArray());
        this.cdesTable.setSelectable(true);
        this.cdesTable.setMultiSelect(this.multiSelect);
        this.cdesTable.setImmediate(true);
        this.cdesTable.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                if (StandardListPart.this.multiSelect) {
                    Set s = (Set)event.getProperty().getValue();
                    StandardListPart.this.buttonBarEditMode(s.size() > 0);
                } else {
                    StandardListPart.this.buttonBarEditMode(event.getProperty().getValue() != null);
                }
            }
        });
        this.cdesTable.setSizeFull();
        this.cdesTable.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                if (event.isDoubleClick()) {
                    StandardListPart.this.cdesTable.select(event.getItemId());
                }
            }
        });
        Label title2 = new Label(this.getTitle());
        title2.setSizeUndefined();
        title2.addStyleName("title");
        this.addComponent((Component)title2);
        this.addSelectorComponent();
        this.drawButtonBar();
        this.addExtraComponent();
        this.addComponent((Component)this.cdesTable);
        this.setExpandRatio((Component)this.cdesTable, 1.0f);
        this.refreshTable();
    }

    private void drawButtonBar() {
        HorizontalLayout gtool = new HorizontalLayout();
        gtool.setWidth("100%");
        HorizontalLayout toolbar = new HorizontalLayout();
        toolbar.addStyleName("wrapping");
        gtool.addComponent((Component)toolbar);
        gtool.setExpandRatio((Component)toolbar, 1.0f);
        this.drawButton();
        for (ButtonHandler handler : this.buttons) {
            toolbar.addComponent((Component)handler.button);
        }
        if (this.searchField != null) {
            if (BaseUiTools.isWidthBelow(960)) {
                toolbar.addComponent((Component)this.searchField);
            } else {
                gtool.addComponent((Component)this.searchField);
            }
        }
        this.addComponent((Component)gtool);
    }

    private void updateFilters() {
        this.mcInfos.removeAllContainerFilters();
        if (this.textFilter != null && !this.textFilter.equals("")) {
            String[] searchInfos = this.getSearchInfos();
            Container.Filter[] filters = new Container.Filter[searchInfos.length];
            int i = 0;
            while (i < searchInfos.length) {
                String search = searchInfos[i];
                filters[i] = new Like((Object)search, "%" + this.textFilter + "%", false);
                ++i;
            }
            Or or = new Or(filters);
            this.mcInfos.addContainerFilter((Container.Filter)or);
        }
    }

    public void refreshTable() {
        boolean[] sortAscending;
        String[] sortColumns = this.getSortInfos();
        boolean[] ascColumns = this.getSortAsc();
        if (ascColumns == null) {
            sortAscending = new boolean[sortColumns.length];
            Arrays.fill(sortAscending, true);
        } else {
            if (ascColumns.length != sortColumns.length) {
                throw new AmapjRuntimeException("Les deux m\u00e9thodes getSortAsc et getSortInfos doivent retourner deux tableaux de m\u00eame taille");
            }
            sortAscending = ascColumns;
        }
        List<T> res = this.getLines();
        if (res == null) {
            this.mcInfos.removeAllItems();
            this.buttonBarFull(false);
            return;
        }
        boolean enabled = this.multiSelect ? TableTools.updateTableMultiselect(this.cdesTable, res, sortColumns, sortAscending) : TableTools.updateTable(this.cdesTable, res, sortColumns, sortAscending);
        this.buttonBarFull(true);
        this.buttonBarEditMode(enabled);
    }

    @Override
    public void onPopupClose() {
        this.refreshTable();
    }

    private void buttonBarFull(boolean enable) {
        for (ButtonHandler handler : this.buttons) {
            handler.button.setEnabled(enable);
        }
    }

    private void buttonBarEditMode(boolean enable) {
        if (enable && !this.isEditAllowed()) {
            enable = false;
        }
        for (ButtonHandler handler : this.buttons) {
            if (handler.type != ButtonType.EDIT_MODE) continue;
            handler.button.setEnabled(enable);
        }
    }

    protected List<T> getSelectedLines() {
        if (!this.multiSelect) {
            throw new AmapjRuntimeException("Vous ne pouvez pas utiliser cette methode en mono selection ");
        }
        ArrayList res = new ArrayList();
        Set s = (Set)this.cdesTable.getValue();
        res.addAll(s);
        return res;
    }

    protected T getSelectedLine() {
        if (this.multiSelect) {
            throw new AmapjRuntimeException("Vous ne pouvez pas utiliser cette methode en multi selection ");
        }
        TableItem dto = (TableItem)this.cdesTable.getValue();
        return (T)dto;
    }

    protected List<T> getVisiblesLines() {
        return this.mcInfos.getItemIds();
    }

    public BeanItemContainer<T> getBeanItemContainer() {
        return this.mcInfos;
    }

    public static class ColInfo {
        private Object propertyId;
        private String header;
        private Converter<String, ?> converter;
        private Table.Align alignment = Table.Align.LEFT;
        private int width = -1;
        private Table.ColumnGenerator generator;

        public ColInfo center() {
            this.alignment = Table.Align.CENTER;
            return this;
        }

        public ColInfo right() {
            this.alignment = Table.Align.RIGHT;
            return this;
        }

        public ColInfo width(int width) {
            this.width = width;
            return this;
        }
    }
}

