/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.archivagepopup;

import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import java.util.List;

public abstract class SuppressionApresArchivagePopup
extends WizardFormPopup {
    protected ParametresArchivageDTO param;
    private SuppressionState state;
    private TextField tf;

    protected abstract String getInfo();

    protected abstract String computeSuppressionLib();

    protected abstract SuppressionState computeSuppressionState();

    protected abstract void suppressElement();

    public SuppressionApresArchivagePopup() {
        this.setWidth(60);
        this.setHeight("50%");
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfo());
        this.add(() -> this.addFieldConditions());
        this.add(() -> this.addFieldConfirmation(), () -> this.checkConfirmation());
    }

    private void addFieldInfo() {
        String str = this.getInfo();
        this.addHtml(str);
    }

    private void addFieldConditions() {
        String str = this.computeSuppressionLib();
        this.addHtml(str);
    }

    private void addFieldConfirmation() {
        this.state = this.computeSuppressionState();
        this.tf = null;
        switch (this.state.getStatus()) {
            case OUI_SANS_RESERVE: {
                this.addHtml("Ce \u00e9l\u00e9ment respecte bien toutes les conditions pour pouvoir \u00eatre supprim\u00e9.");
                this.addHtml("Veuillez cliquer sur Sauvegarder pour le supprimer, ou Annuler pour ne rien faire.");
                return;
            }
            case OUI_AVEC_RESERVE_MINEURE: {
                this.addHtml("Ce \u00e9l\u00e9ment peut \u00eatre archiv\u00e9, mais il ne respecte pas les conditions suivantes (r\u00e9serves mineures) : ");
                this.addHtml(this.asHtmlList(this.state.reserveMineures));
                this.addHtml("Veuillez cliquer sur Sauvegarder pour le supprimer, ou Annuler pour ne rien faire.");
                return;
            }
            case OUI_AVEC_RESERVE_MAJEURE: {
                this.addHtml("Ce \u00e9l\u00e9ment ne devrait pas \u00eatre archiv\u00e9 car il ne respecte pas les conditions suivantes (r\u00e9serves majeures) : ");
                this.addHtml(this.asHtmlList(this.state.reserveMajeures));
                this.addHtml("N\u00e9anmoins, si vous pensez que ce \u00e9lement est bien supprimable, vous pouvez le supprimer quand m\u00eame en saisissant ci dessous le texte <br/>SUPPRESSION<br/> puis en cliquant sur Sauvegarder");
                this.tf = new TextField("");
                this.tf.setValue("");
                this.tf.setImmediate(true);
                this.form.addComponent((Component)this.tf);
                return;
            }
            case NON: {
                this.addHtml("Ce \u00e9l\u00e9ment ne peut pas \u00eatre supprim\u00e9 pour les raisons suivantes : ");
                this.addHtml(this.asHtmlList(this.state.nonSupprimables));
                this.setBackOnlyMode();
                return;
            }
        }
        throw new AmapjRuntimeException("state=" + (Object)((Object)this.state.getStatus()));
    }

    private String asHtmlList(List<String> strs) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (String str : strs) {
            sb.append("<li>");
            sb.append(str);
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private String checkConfirmation() {
        if (this.tf == null) {
            return null;
        }
        if (((String)this.tf.getValue()).equals("SUPPRESSION")) {
            return null;
        }
        return "Pour pouvoir continuer, vous devez saisir le texte SUPPRESSION (apr\u00e8s vous \u00eates assur\u00e9s que cet \u00e9lement est bel et bien supprimable)";
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        this.suppressElement();
    }
}

