/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.corepopup;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import fr.amapj.common.StringUtils;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import java.util.ArrayList;
import java.util.List;

public abstract class CorePopup {
    private Window window = new Window();
    private PopupType popupType = PopupType.FILL;
    protected Window.CloseListener popupCloseListener;
    protected String popupTitle = "";
    private boolean closeable = true;
    protected HorizontalLayout popupButtonBarLayout;
    private Integer popupWidth = 40;
    private Integer minWidth = 400;
    private Integer maxWidth = null;
    private String popupHeight = null;
    private Integer minHeight = 400;
    private Integer maxHeight = null;
    private ColorStyle colorStyle = ColorStyle.GREEN;
    private List<String> styleNamesForMainLayout = new ArrayList<String>();

    public void createPopup() {
        VerticalLayout contentLayout = new VerticalLayout();
        this.createContent(contentLayout);
        this.popupButtonBarLayout = new HorizontalLayout();
        this.popupButtonBarLayout.setWidth("100%");
        this.popupButtonBarLayout.setMargin(false);
        this.popupButtonBarLayout.addStyleName("buttonbar");
        this.createButtonBar();
        this.popupButtonBarLayout.setSpacing(true);
        this.window.setClosable(this.closeable);
        this.window.setResizable(true);
        this.window.setModal(true);
        if (this.popupType == PopupType.CENTERFIT) {
            contentLayout.setWidthUndefined();
            VerticalLayout mainLayout = new VerticalLayout();
            mainLayout.addStyleName("corepopup");
            mainLayout.setResponsive(true);
            mainLayout.addStyleName("centerfit-corepopup");
            mainLayout.addStyleName("centerfit-corepopup-" + this.getWidthRange());
            this.addAllStyleNamesInMainLayout(mainLayout);
            mainLayout.setWidth(null);
            mainLayout.addComponent((Component)contentLayout);
            mainLayout.addComponent((Component)this.popupButtonBarLayout);
            mainLayout.setComponentAlignment((Component)this.popupButtonBarLayout, Alignment.MIDDLE_RIGHT);
            this.window.setContent((Component)mainLayout);
            this.window.setSizeUndefined();
        } else {
            contentLayout.setWidth("100%");
            VerticalLayout mainLayout = new VerticalLayout();
            mainLayout.addStyleName("corepopup");
            mainLayout.setResponsive(true);
            mainLayout.addStyleName("fill-corepopup");
            mainLayout.addStyleName("fill-corepopup-" + this.getWidthRange());
            this.addAllStyleNamesInMainLayout(mainLayout);
            mainLayout.setWidth("100%");
            mainLayout.addComponent((Component)contentLayout);
            mainLayout.addComponent((Component)this.popupButtonBarLayout);
            mainLayout.setComponentAlignment((Component)this.popupButtonBarLayout, Alignment.MIDDLE_RIGHT);
            this.window.setContent((Component)mainLayout);
            this.computeWindowSize();
            this.window.setHeight(this.popupHeight);
        }
        this.window.center();
        this.window.setCaption(this.popupTitle);
        this.window.setStyleName("opaque");
        if (this.colorStyle == ColorStyle.RED) {
            this.window.setStyleName("corepopup-red");
        }
    }

    private void addAllStyleNamesInMainLayout(VerticalLayout mainLayout) {
        for (String styleName : this.styleNamesForMainLayout) {
            mainLayout.addStyleName(styleName);
        }
    }

    protected void addStyleNameForMainLayout(String styleName) {
        this.styleNamesForMainLayout.add(styleName);
    }

    private String getWidthRange() {
        int browserWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        if (browserWidth < 501) {
            return "size0_500px";
        }
        if (browserWidth < 801) {
            return "size501_800px";
        }
        return "size801px_";
    }

    protected abstract void createContent(VerticalLayout var1);

    protected abstract void createButtonBar();

    protected Button addButton(String title, Button.ClickListener listener) {
        Button saveButton = new Button(title, listener);
        this.popupButtonBarLayout.addComponent((Component)saveButton);
        return saveButton;
    }

    protected Button addDefaultButton(String title, Button.ClickListener listener) {
        Button saveButton = this.addButton(title, listener);
        if (this.colorStyle == ColorStyle.RED) {
            saveButton.addStyleName("danger");
        } else {
            saveButton.addStyleName("primary");
        }
        return saveButton;
    }

    protected void addButtonBlank() {
        HorizontalLayout hl = new HorizontalLayout();
        this.popupButtonBarLayout.addComponent((Component)hl);
        this.popupButtonBarLayout.setExpandRatio((Component)hl, 1.0f);
    }

    protected void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    protected void setType(PopupType popupType) {
        this.popupType = popupType;
    }

    protected void setWidth(int width) {
        this.popupWidth = width;
    }

    protected void setColorStyle(ColorStyle colorStyle) {
        this.colorStyle = colorStyle;
    }

    protected void setHeight(String height) {
        this.popupHeight = height;
    }

    protected void setWidth(int width, int minSize) {
        this.popupWidth = width;
        this.minWidth = minSize;
    }

    private void computeWindowSize() {
        int browserWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        int computedWith = this.minWidth * 100 / browserWidth;
        String w = computedWith >= 100 ? "100%" : (computedWith >= this.popupWidth ? String.valueOf(computedWith) + "%" : this.popupWidth + "%");
        this.window.setWidth(w);
    }

    protected void close() {
        this.window.close();
    }

    public void changeCloseListener(Window.CloseListener cl) {
        this.window.removeCloseListener(this.popupCloseListener);
        this.window.addCloseListener(cl);
    }

    public Window getWindow() {
        return this.window;
    }

    public void open() {
        CorePopup.open(this);
    }

    public void open(PopupListener listener) {
        CorePopup.open(this, listener);
    }

    public static void open(CorePopup popup) {
        CorePopup.open(popup, null);
    }

    public static void open(CorePopup popup, final PopupListener listener) {
        if (listener != null) {
            popup.popupCloseListener = new Window.CloseListener(){

                public void windowClose(Window.CloseEvent e) {
                    try {
                        listener.onPopupClose();
                    }
                    catch (Throwable t) {
                        ErrorPopup.open(t);
                    }
                }
            };
            popup.window.addCloseListener(popup.popupCloseListener);
        }
        popup.createPopup();
        UI.getCurrent().addWindow(popup.window);
    }

    public static String s(String value) {
        return StringUtils.s(value);
    }

    public static enum ColorStyle {
        GREEN,
        RED;

    }

    public static enum PopupType {
        CENTERFIT,
        FILL;

    }
}

