/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup;

import com.vaadin.data.Item;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.RichTextArea;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.Identifiable;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.enumselector.EnumSearcher;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.formpopup.ValidatorManager;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.engine.searcher.SearcherDefinition;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.vaadin.openesignforms.ckeditor.CKEditorConfig;
import org.vaadin.openesignforms.ckeditor.CKEditorTextField;

public abstract class AbstractFormPopup
extends CorePopup {
    private Item item;
    protected FieldGroup binder;
    protected FormLayout form;
    protected ValidatorManager validatorManager = new ValidatorManager();
    private CollectionEditor currentCollectionEditor;

    protected void setModel(Object dto) {
        this.item = new BeanItem(dto);
    }

    protected Item getModelAsItem() {
        return this.item;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean doCommit() {
        try {
            this.binder.commit();
            return true;
        }
        catch (FieldGroup.CommitException e) {
            msgs = new ArrayList<String>();
            msgs.add("Merci de corriger les points suivants (commit exception)");
            ** for (entry : e.getInvalidFields().entrySet())
        }
lbl-1000:
        // 1 sources

        {
            str = "Le champ " + this.getCaption((Field)entry.getKey()) + " est incorrect (D\u00e9tails : " + ((Validator.InvalidValueException)entry.getValue()).getMessage() + ").";
            msgs.add(str);
            continue;
        }
lbl13:
        // 1 sources

        if (msgs.size() == 1) {
            StackUtils.popStack(msgs, e);
        }
        MessagePopup.open(new MessagePopup("Notification", msgs));
        return false;
    }

    private String getCaption(Field<?> field) {
        if (!(field.getParent() instanceof FormLayout)) {
            return field.getParent().getCaption();
        }
        return field.getCaption();
    }

    protected <T> void addComplexTable(ComplexTableBuilder<T> ctb) {
        ctb.buildComponent((Layout)this.form);
    }

    protected Label addText(String content) {
        return this.addHtml(content);
    }

    protected Label addHtml(String content) {
        return this.addLabel(content, ContentMode.HTML);
    }

    private Label addLabel(String content, ContentMode mode) {
        Label l = new Label(content, mode);
        l.setStyleName("big");
        l.setWidth("80%");
        this.form.addComponent((Component)l);
        return l;
    }

    protected Label addBr() {
        return this.addHtml("<br/>");
    }

    protected TextField addTextField(String title, Object propertyId, IValidator ... validators) {
        TextField f = (TextField)this.binder.buildAndBind(title, propertyId);
        f.setId("amapj.popup." + propertyId);
        f.setNullRepresentation("");
        f.setStyleName("big");
        f.setWidth("80%");
        this.form.addComponent((Component)f);
        this.validatorManager.add((AbstractField)f, title, propertyId, validators);
        return f;
    }

    protected Searcher addSearcher(String title, String propertyId, SearcherDefinition iSearcher, List<? extends Identifiable> fixedValues, IValidator ... validators) {
        Searcher prod = new Searcher(iSearcher, title, fixedValues);
        prod.bind(this.binder, propertyId);
        this.form.addComponent((Component)prod);
        this.validatorManager.add((AbstractField)prod, title, propertyId, validators);
        return prod;
    }

    protected TextArea addTextAeraField(String title, Object propertyId) {
        TextArea f = new TextArea(title);
        f.setId("amapj.popup." + propertyId);
        this.binder.bind((Field)f, propertyId);
        f.setNullRepresentation("");
        f.setStyleName("big");
        f.setWidth("80%");
        this.form.addComponent((Component)f);
        return f;
    }

    protected RichTextArea addRichTextAeraField(String title, Object propertyId) {
        RichTextArea f = new RichTextArea(title);
        this.binder.bind((Field)f, propertyId);
        f.setNullRepresentation("");
        f.setStyleName("big");
        f.setWidth("80%");
        this.form.addComponent((Component)f);
        return f;
    }

    protected <T extends Enum<T>> ComboBox addComboEnumField(String title, String propertyId, IValidator ... validators) {
        return this.addComboEnumField(title, propertyId, null, null, validators);
    }

    protected <T extends Enum<T>> ComboBox addComboEnumField(String title, String propertyId, T[] enumsToExcludes, IValidator ... validators) {
        return this.addComboEnumField(title, propertyId, null, (Enum[])enumsToExcludes, validators);
    }

    protected <T extends Enum<T>> ComboBox addComboEnumField(String title, String propertyId, String overrideHelpText) {
        return this.addComboEnumField(title, propertyId, overrideHelpText, null, new IValidator[0]);
    }

    protected <T extends Enum<T>> ComboBox addComboEnumField(String title, String propertyId, String overrideHelpText, T[] enumsToExcludes, IValidator ... validators) {
        HorizontalLayout hl = EnumSearcher.createEnumSearcher((FieldGroup)this.binder, (String)title, (String)propertyId, (String)overrideHelpText, enumsToExcludes);
        this.form.addComponent((Component)hl);
        ComboBox box = (ComboBox)hl.getComponent(0);
        this.validatorManager.add((AbstractField)box, title, propertyId, validators);
        return box;
    }

    protected <T> ComboBox addGeneralComboField(String title, List<T> items, String propertyId, GenericUtils.ToString<T> f, IValidator ... validators) {
        ComboBox comboBox = new ComboBox(title);
        comboBox.setImmediate(true);
        for (T item : items) {
            String caption = f == null ? item.toString() : f.toString(item);
            comboBox.addItem(item);
            comboBox.setItemCaption(item, caption);
        }
        this.binder.bind((Field)comboBox, (Object)propertyId);
        this.form.addComponent((Component)comboBox);
        this.validatorManager.add((AbstractField)comboBox, title, propertyId, validators);
        return comboBox;
    }

    protected PopupDateField addDateField(String title, String propertyId, IValidator ... validators) {
        return this.addDateField(title, propertyId, (String)null, validators);
    }

    protected PopupDateField addDateField(String title, String propertyId, String helpText, IValidator ... validators) {
        PopupDateField f = BaseUiTools.createDateField(this.binder, propertyId, null);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setCaption(title);
        hl.addComponent((Component)f);
        if (helpText != null) {
            Button aide = new Button();
            aide.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
            aide.addStyleName("borderless-colored");
            aide.addStyleName("question-mark");
            aide.addClickListener((Button.ClickListener & Serializable)e -> new MessagePopup("Aide", ContentMode.HTML, CorePopup.ColorStyle.GREEN, helpText).open());
            hl.addComponent((Component)aide);
        }
        this.form.addComponent((Component)hl);
        this.validatorManager.add((AbstractField)f, title, propertyId, validators);
        return f;
    }

    protected PasswordField addPasswordTextField(String title, Object propertyId) {
        PasswordField f = new PasswordField(title);
        this.binder.bind((Field)f, propertyId);
        f.setNullRepresentation("");
        f.setStyleName("big");
        f.setWidth("80%");
        this.form.addComponent((Component)f);
        return f;
    }

    protected TextField addIntegerField(String title, String propertyId, IValidator ... validators) {
        TextField f = BaseUiTools.createIntegerField(title);
        this.binder.bind((Field)f, (Object)propertyId);
        this.form.addComponent((Component)f);
        this.validatorManager.add((AbstractField)f, title, propertyId, validators);
        return f;
    }

    protected TextField addIntegerField(String title, String propertyId, String helpContent, IValidator ... validators) {
        TextField f = BaseUiTools.createIntegerField(null);
        this.binder.bind((Field)f, (Object)propertyId);
        this.validatorManager.add((AbstractField)f, title, propertyId, validators);
        Button aide = new Button();
        aide.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
        aide.addStyleName("borderless-colored");
        aide.addStyleName("question-mark");
        aide.addClickListener((Button.ClickListener & Serializable)e -> AbstractFormPopup.handleAide(helpContent));
        HorizontalLayout hl = new HorizontalLayout();
        hl.setCaption(title);
        hl.addComponent((Component)f);
        hl.addComponent((Component)aide);
        this.form.addComponent((Component)hl);
        return f;
    }

    protected TextField addDoubleField(String title, String propertyId, IValidator ... validators) {
        TextField f = BaseUiTools.createDoubleField(title);
        this.binder.bind((Field)f, (Object)propertyId);
        this.form.addComponent((Component)f);
        this.validatorManager.add((AbstractField)f, title, propertyId, validators);
        return f;
    }

    protected TextField addCurrencyField(String title, String propertyId, boolean allowNegativeNumber) {
        TextField f = BaseUiTools.createCurrencyField(title, allowNegativeNumber);
        this.binder.bind((Field)f, (Object)propertyId);
        this.form.addComponent((Component)f);
        return f;
    }

    protected CKEditorTextField addCKEditorFieldForLabel(String title, String propertyId) {
        CKEditorConfig config = new CKEditorConfig();
        config.disableElementsPath();
        config.disableSpellChecker();
        config.setWidth("100%");
        config.setFullPage(Boolean.valueOf(false));
        config.setAllowedContent("true");
        config.setForcePasteAsPlainText(Boolean.valueOf(true));
        config.setEnterMode("BR");
        config.setResizeEnabled(false);
        String contextPath = AppConfiguration.getConf().getContextPath();
        config.setContentsCss(new String[]{String.valueOf(contextPath) + "/VAADIN/ck_for_label.css"});
        config.setStylesSet("ck_for_label:" + contextPath + "/VAADIN/ck_for_label.js");
        config.addCustomToolbarLine("{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline' ] } , { name: 'styles', items : ['FontSize','TextColor','BGColor'] } ,{ name: 'links', items: [ 'Link'] }");
        CKEditorTextField ckEditorTextField = new CKEditorTextField(config);
        ckEditorTextField.setWidth("100%");
        ckEditorTextField.setHeight(4.0f, Sizeable.Unit.CM);
        ckEditorTextField.setCaption(title);
        this.binder.bind((Field)ckEditorTextField, (Object)propertyId);
        this.form.addComponent((Component)ckEditorTextField);
        return ckEditorTextField;
    }

    protected CKEditorTextField addCKEditorFieldForDocument(String propertyId) {
        CKEditorConfig config = new CKEditorConfig();
        config.useCompactTags();
        config.disableElementsPath();
        config.disableSpellChecker();
        config.setWidth("100%");
        config.setFullPage(Boolean.valueOf(true));
        config.setAllowedContent("true");
        config.setForcePasteAsPlainText(Boolean.valueOf(true));
        String contextPath = AppConfiguration.getConf().getContextPath();
        config.setStylesSet("engagement_style:" + contextPath + "/VAADIN/engagement_style.js");
        config.addCustomToolbarLine("{ name: 'clipboard', items: [ 'Cut', 'Copy', 'Paste', '-', 'Undo', 'Redo' ] } , { name: 'editing', items: [ 'Find' ] },{ name: 'basicstyles', items: [ 'Styles' , 'Bold', 'Italic', 'Underline' ] } , { name: 'paragraph', items: [ 'CreateDiv' , 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] } , { name: 'insert', items: [ 'Table', 'PageBreak' ,  'HorizontalRule'] },{ name: 'styles', items : ['FontSize','TextColor','BGColor','Maximize', 'ShowBlocks'] } , { name: 'document', items: [ 'Source'] } ");
        config.addExtraConfig("fontSize_sizes", "'6pt;7pt;8pt;9pt;10pt;11pt;12pt;13pt;14pt;15pt;16pt;18pt;20pt;22pt;24pt;26pt;28pt;32pt;36pt'");
        config.addExtraConfig("startupOutlineBlocks", "true");
        config.addToExtraPlugins("removeRedundantNBSP");
        CKEditorTextField ckEditorTextField = new CKEditorTextField(config);
        ckEditorTextField.setWidth("100%");
        ckEditorTextField.setHeight("16cm");
        this.binder.bind((Field)ckEditorTextField, (Object)propertyId);
        this.form.addComponent((Component)ckEditorTextField);
        return ckEditorTextField;
    }

    protected Button addHelpButton(String title, String helpContent) {
        Button aide = new Button(title);
        aide.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
        aide.addStyleName("borderless-colored");
        aide.addStyleName("question-mark");
        aide.addClickListener((Button.ClickListener & Serializable)e -> AbstractFormPopup.handleAide(helpContent));
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        hl.addComponent((Component)aide);
        hl.setComponentAlignment((Component)aide, Alignment.MIDDLE_RIGHT);
        this.form.addComponent((Component)hl);
        return aide;
    }

    private static void handleAide(String helpContent) {
        MessagePopup m = new MessagePopup("Aide", ContentMode.HTML, CorePopup.ColorStyle.GREEN, helpContent);
        MessagePopup.open(m);
    }

    protected <T> CollectionEditor<T> addCollectionEditorField(String title, Object propertyId, Class<T> beanType, IValidator ... validators) {
        this.currentCollectionEditor = new CollectionEditor<T>(title, (BeanItem)this.item, propertyId, beanType);
        this.binder.bind((Field)this.currentCollectionEditor, propertyId);
        this.form.addComponent((Component)this.currentCollectionEditor);
        this.validatorManager.add((AbstractField)this.currentCollectionEditor, title, propertyId, validators);
        return this.currentCollectionEditor;
    }

    protected void addColumnSearcher(String propertyId, String title, FieldType fieldType, Object defaultValue, SearcherDefinition searcher, Searcher linkedSearcher, IValidator ... validators) {
        this.currentCollectionEditor.addSearcherColumn(propertyId, title, fieldType, defaultValue, searcher, linkedSearcher);
        this.validatorManager.add((AbstractField)this.currentCollectionEditor, title, propertyId, validators);
    }

    protected void addColumn(String propertyId, String title, FieldType fieldType, Object defaultValue, IValidator ... validators) {
        this.currentCollectionEditor.addColumn(propertyId, title, fieldType, defaultValue);
        this.validatorManager.add((AbstractField)this.currentCollectionEditor, title, propertyId, validators);
    }

    protected <T> void addCollectionEditorFieldToForm(CollectionEditor<T> ce, String title, Object propertyId, IValidator ... validators) {
        this.currentCollectionEditor = ce;
        this.binder.bind((Field)this.currentCollectionEditor, propertyId);
        this.form.addComponent((Component)this.currentCollectionEditor);
        this.validatorManager.add((AbstractField)this.currentCollectionEditor, title, propertyId, validators);
    }

    protected void addValidatorColumnSearcher(String propertyId, String title, IValidator ... validators) {
        this.validatorManager.add((AbstractField)this.currentCollectionEditor, title, propertyId, validators);
    }

    protected void suppressElement(Field<?> c) {
        if (c.getParent() == this.form) {
            this.form.removeComponent(c);
        } else {
            this.form.removeComponent((Component)c.getParent());
        }
        this.binder.unbind(c);
    }
}

