/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup;

import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.GenericUtils;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.popup.formpopup.AbstractFormPopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.tools.BaseUiTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class WizardFormPopup
extends AbstractFormPopup {
    protected String nextButtonTitle = "Etape suivante ...";
    protected Button nextButton;
    protected String previousButtonTitle = "Etape pr\u00e9c\u00e9dente ...";
    protected Button previousButton;
    protected Button cancelButton;
    protected String saveButtonTitle = "Sauvegarder";
    private VerticalLayout contentLayout;
    protected Label hTitre;
    private int pageNumber;
    private List<DetailStepInfo> pages = new ArrayList<DetailStepInfo>();
    private boolean errorInInitialCondition = false;

    public WizardFormPopup() {
        this.setHeight("80%");
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        contentLayout.addStyleName("wizard-popup");
        this.configure();
        String str = this.checkInitialCondition();
        if (str != null) {
            this.errorInInitialCondition = true;
            this.displayErrorOnInitialCondition(str);
            return;
        }
        this.hTitre = new Label("");
        this.hTitre.addStyleName("wizard-popup-etape");
        contentLayout.addComponent((Component)this.hTitre);
        this.updateForm();
    }

    protected String checkInitialCondition() {
        return null;
    }

    private void displayErrorOnInitialCondition(String str) {
        Label label = new Label(str, ContentMode.HTML);
        label.setStyleName("big");
        this.contentLayout.addComponent((Component)label);
    }

    private void updateForm() {
        if (this.form != null) {
            this.contentLayout.removeComponent((Component)this.form);
        }
        this.form = new FormLayout();
        this.form.setWidth("100%");
        this.form.setImmediate(true);
        this.binder = new FieldGroup();
        this.binder.setBuffered(true);
        this.binder.setItemDataSource(this.getModelAsItem());
        this.validatorManager.reset();
        DetailStepInfo stepInfo = this.pages.get(this.pageNumber);
        stepInfo.drawScreen.action();
        this.contentLayout.addComponent((Component)this.form);
        this.contentLayout.setComponentAlignment((Component)this.form, Alignment.MIDDLE_LEFT);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        if (this.errorInInitialCondition) {
            this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.close());
            return;
        }
        this.cancelButton = this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.previousButton = this.addButton(this.previousButtonTitle, (Button.ClickListener & Serializable)e -> this.handlePrevious());
        this.previousButton.setEnabled(false);
        this.nextButton = this.addDefaultButton(this.nextButtonTitle, (Button.ClickListener & Serializable)e -> this.handleNext());
        if (this.pages.size() == 1) {
            this.previousButton.setVisible(false);
            this.nextButton.setCaption(this.saveButtonTitle);
        }
    }

    private void handleAnnuler() {
        this.close();
    }

    private void handlePrevious() {
        boolean ret = this.doCommit();
        if (!ret) {
            return;
        }
        --this.pageNumber;
        this.updateButtonStatus();
        this.updateForm();
    }

    private void updateButtonStatus() {
        if (this.pageNumber == this.pages.size() - 1) {
            this.nextButton.setCaption(this.saveButtonTitle);
        } else {
            this.nextButton.setCaption(this.nextButtonTitle);
        }
        this.nextButton.setEnabled(true);
        if (this.pageNumber == 0) {
            this.previousButton.setEnabled(false);
        } else {
            this.previousButton.setEnabled(true);
        }
    }

    private void handleNext() {
        String verifGlobal;
        boolean ret = this.doCommit();
        if (!ret) {
            return;
        }
        List<String> msg = this.validatorManager.validate();
        if (msg.size() > 0) {
            msg.add(0, "Merci de corriger les points suivants :");
            MessagePopup.open(new MessagePopup("Notification", msg));
            return;
        }
        DetailStepInfo stepInfo = this.pages.get(this.pageNumber);
        if (stepInfo.check != null && (verifGlobal = stepInfo.check.action()) != null) {
            MessagePopup.open(new MessagePopup("Notification", ContentMode.HTML, CorePopup.ColorStyle.RED, verifGlobal));
            return;
        }
        if (this.pageNumber == this.pages.size() - 1) {
            this.handleSauvegarder();
        } else {
            ++this.pageNumber;
            this.updateButtonStatus();
            this.updateForm();
        }
    }

    private void handleSauvegarder() {
        try {
            this.performSauvegarder();
        }
        catch (OnSaveException e) {
            ArrayList<String> msgs = new ArrayList<String>();
            msgs.add("Une erreur est survenue durant la sauvegarde.");
            msgs.addAll(e.getAllMessages());
            MessagePopup.open(new MessagePopup("Erreur", msgs));
            return;
        }
        catch (Exception e) {
            ErrorPopup.open(e);
            return;
        }
        this.close();
    }

    protected void setBackOnlyMode() {
        this.nextButton.setEnabled(false);
    }

    protected abstract void performSauvegarder() throws OnSaveException;

    protected abstract void configure();

    protected void add(GenericUtils.VoidAction drawScreen) {
        DetailStepInfo detail = new DetailStepInfo();
        detail.drawScreen = drawScreen;
        this.pages.add(detail);
    }

    protected void add(boolean actif, GenericUtils.VoidAction drawScreen) {
        if (actif) {
            this.add(drawScreen);
        }
    }

    public void add(GenericUtils.VoidAction drawScreen, GenericUtils.StringAction check) {
        DetailStepInfo detail = new DetailStepInfo();
        detail.drawScreen = drawScreen;
        detail.check = check;
        this.pages.add(detail);
    }

    public void add(boolean actif, GenericUtils.VoidAction drawScreen, GenericUtils.StringAction check) {
        if (actif) {
            this.add(drawScreen, check);
        }
    }

    protected void setStepTitle(String message) {
        this.hTitre.setValue("Etape " + (this.pageNumber + 1) + " : " + message);
    }

    protected void setStepTitleNoPrefix(String message) {
        this.hTitre.setValue(message);
    }

    protected void setNextButtonAsSave() {
        this.nextButton.setCaption(this.saveButtonTitle);
    }

    protected void setAllButtonsAsOK() {
        this.nextButton.setCaption("OK");
        this.previousButton.setVisible(false);
        this.cancelButton.setVisible(false);
    }

    protected void setReadOnlyAll() {
        BaseUiTools.setReadOnlyRecursively((HasComponents)this.form);
    }

    public static class DetailStepInfo {
        public GenericUtils.VoidAction drawScreen;
        public GenericUtils.StringAction check;
    }
}

