/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.tab;

import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.popup.formpopup.AbstractFormPopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.tab.TabDraw;
import fr.amapj.view.engine.popup.formpopup.tab.TabInfo;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.util.ArrayList;
import java.util.List;

public abstract class TabFormPopup
extends AbstractFormPopup
implements TabSheet.SelectedTabChangeListener {
    protected String saveButtonTitle = "Sauvegarder";
    protected String quitButtonTitle = "Quitter";
    protected Button saveButton;
    protected Button quitButton;
    private List<TabInfo> tabInfos = new ArrayList<TabInfo>();
    private TabSheet tabSheet;
    private boolean errorInInitialCondition = false;
    private VerticalLayout vLayout;
    private int selectedTab = -1;

    protected String checkInitialCondition() {
        return null;
    }

    protected abstract void performSauvegarder() throws OnSaveException;

    protected abstract void addTabInfo();

    public void addTab(String tabName, TabDraw tabDraw) {
        this.tabInfos.add(new TabInfo(tabName, tabDraw));
    }

    public TabFormPopup() {
        this.setHeight("80%");
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        contentLayout.addStyleName("wizard-popup");
        String str = this.checkInitialCondition();
        if (str != null) {
            this.errorInInitialCondition = true;
            Label label = new Label(str, ContentMode.HTML);
            label.setStyleName("big");
            contentLayout.addComponent((Component)label);
            return;
        }
        this.addTabInfo();
        this.tabSheet = new TabSheet();
        int i = 0;
        while (i < this.tabInfos.size()) {
            TabInfo tabInfo = this.tabInfos.get(i);
            tabInfo.verticalLayout = new VerticalLayout();
            tabInfo.verticalLayout.setData((Object)i);
            this.tabSheet.addTab((Component)tabInfo.verticalLayout, tabInfo.tabName);
            ++i;
        }
        this.tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
        contentLayout.addComponent((Component)this.tabSheet);
        this.vLayout = new VerticalLayout();
        contentLayout.addComponent((Component)this.vLayout);
        this.updateForm(this.tabInfos.get(0));
        this.selectedTab = 0;
    }

    public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
        int newTabIndex = this.getSelectedTabIndex();
        TabInfo tabInfo = this.tabInfos.get(newTabIndex);
        boolean ret = this.saveForm(tabInfo);
        if (ret) {
            this.updateForm(tabInfo);
            this.selectedTab = newTabIndex;
        } else {
            this.tabSheet.removeSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
            this.tabSheet.setSelectedTab(this.selectedTab);
            this.tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
        }
    }

    private int getSelectedTabIndex() {
        return (Integer)((VerticalLayout)this.tabSheet.getSelectedTab()).getData();
    }

    private void updateForm(TabInfo tabInfo) {
        this.vLayout.removeAllComponents();
        this.form = new FormLayout();
        this.form.setWidth("100%");
        this.form.setImmediate(true);
        this.binder = new FieldGroup();
        this.binder.setBuffered(true);
        this.binder.setItemDataSource(this.getModelAsItem());
        this.validatorManager.reset();
        tabInfo.tabDraw.drawTab();
        this.vLayout.addComponent((Component)this.form);
        this.vLayout.setComponentAlignment((Component)this.form, Alignment.MIDDLE_LEFT);
    }

    private boolean saveForm(TabInfo tabInfo) {
        String str;
        boolean ret = this.doCommit();
        if (!ret) {
            return false;
        }
        List<String> msg = this.validatorManager.validate();
        if (msg.size() > 0) {
            msg.add(0, "Merci de corriger les points suivants :");
            MessagePopup.open(new MessagePopup("Notification", msg));
            return false;
        }
        if (tabInfo.tabValidate != null && (str = tabInfo.tabValidate.validate()) != null) {
            ArrayList<String> strs = new ArrayList<String>();
            strs.add(str);
            MessagePopup.open(new MessagePopup("Notification", strs));
            return false;
        }
        return true;
    }

    @Override
    protected void createButtonBar() {
        if (this.errorInInitialCondition) {
            this.addButton("OK", new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    TabFormPopup.this.close();
                }
            });
            return;
        }
        this.addButton("Annuler", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                TabFormPopup.this.handleAnnuler();
            }
        });
        this.saveButton = this.addDefaultButton(this.saveButtonTitle, new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                TabFormPopup.this.handleSave();
            }
        });
    }

    private void handleAnnuler() {
        this.binder.discard();
        this.close();
    }

    private void handleSave() {
        TabInfo tabInfo = this.tabInfos.get(this.selectedTab);
        boolean ret = this.saveForm(tabInfo);
        if (!ret) {
            return;
        }
        int i = 0;
        while (i < this.tabInfos.size()) {
            if (i != this.selectedTab && !(ret = this.saveForm(tabInfo = this.tabInfos.get(i)))) {
                this.tabSheet.removeSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
                this.tabSheet.setSelectedTab(i);
                this.tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener)this);
                return;
            }
            ++i;
        }
        try {
            this.performSauvegarder();
        }
        catch (OnSaveException e) {
            MessagePopup.open(new MessagePopup("Erreur", e.getAllMessages()));
            return;
        }
        catch (Exception e) {
            ErrorPopup.open(e);
            return;
        }
        this.close();
    }

    protected void setEmptyTitle() {
    }

    protected void setStepTitle(String message) {
    }
}

