/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.validator;

import com.vaadin.ui.AbstractField;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.ObjectUtils;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ValidatorHolder;
import java.util.Date;
import java.util.List;

public class CollectionNoDuplicates<T>
implements IValidator {
    private GenericUtils.GetField<T> field;
    private CollectionUtils.ToString<T> toString;

    public CollectionNoDuplicates(GenericUtils.GetField<T> field, CollectionUtils.ToString<T> toString) {
        this.field = field;
        this.toString = toString;
    }

    public CollectionNoDuplicates(GenericUtils.GetField<T> field) {
        this(field, null);
    }

    @Override
    public void performValidate(Object value, ValidatorHolder a) {
        List val = (List)value;
        for (Object t : val) {
            int nb = this.count(val, t);
            if (nb == 1) continue;
            String lib = this.toString == null ? this.prettyString(t) : this.toString.toString(t);
            a.addMessage("Le champ \"" + a.title + "\" contient plusieurs fois " + lib + "( " + nb + " fois) ");
            break;
        }
    }

    private String prettyString(T t) {
        Object ref = this.field.getField(t);
        if (ref instanceof Date) {
            return "la date " + FormatUtils.getStdDate().format((Date)ref);
        }
        return "l'element " + ref;
    }

    private int count(List<T> val, T t) {
        int nb = 0;
        Object ref = this.field.getField(t);
        for (T t2 : val) {
            Object r2 = this.field.getField(t2);
            if (!ObjectUtils.equals(ref, r2)) continue;
            ++nb;
        }
        return nb;
    }

    @Override
    public boolean canCheckOnFly() {
        return false;
    }

    @Override
    public AbstractField[] revalidateOnChangeOf() {
        return null;
    }
}

