/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.validator;

import com.vaadin.ui.AbstractField;
import fr.amapj.common.DateUtils;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ValidatorHolder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateRangeValidator
implements IValidator {
    private Date dateMin = null;
    private Date dateMax = null;

    public DateRangeValidator(Date dateMin, Date dateMax) {
        this.dateMin = dateMin;
        this.dateMax = dateMax;
    }

    @Override
    public void performValidate(Object value, ValidatorHolder a) {
        SimpleDateFormat df;
        if (value == null) {
            return;
        }
        Date val = DateUtils.suppressTime((Date)value);
        if (this.dateMin != null && val.before(DateUtils.suppressTime(this.dateMin))) {
            df = new SimpleDateFormat("dd/MM/yy");
            a.addMessage("La date \"" + a.title + "\" est trop petite. Elle doit \u00eatre \u00e9gale ou apr\u00e8s  le " + df.format(this.dateMin));
        }
        if (this.dateMax != null && val.after(DateUtils.suppressTime(this.dateMax))) {
            df = new SimpleDateFormat("dd/MM/yy");
            a.addMessage("La date \"" + a.title + "\" est trop grande. Elle doit \u00eatre \u00e9gale ou avant le " + df.format(this.dateMax));
        }
    }

    @Override
    public boolean canCheckOnFly() {
        return true;
    }

    @Override
    public AbstractField[] revalidateOnChangeOf() {
        return null;
    }
}

