/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.messagepopup;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MessagePopup
extends CorePopup {
    protected Button okButton;
    List<String> messages = new ArrayList<String>();
    private ContentMode contentMode = ContentMode.TEXT;
    private CorePopup.ColorStyle colorStyle = CorePopup.ColorStyle.RED;

    public MessagePopup(String title, List<String> strs) {
        this(title, CorePopup.ColorStyle.RED, strs);
    }

    public MessagePopup(String title, ContentMode contentMode, CorePopup.ColorStyle colorStyle, List<String> strs) {
        this.setHeight("50%");
        this.colorStyle = colorStyle;
        this.contentMode = contentMode;
        this.popupTitle = title;
        this.messages.addAll(strs);
    }

    public MessagePopup(String title, CorePopup.ColorStyle colorStyle, List<String> strs) {
        this(title, ContentMode.TEXT, colorStyle, strs);
    }

    public MessagePopup(String title, CorePopup.ColorStyle colorStyle, String ... msgs) {
        this(title, ContentMode.TEXT, colorStyle, msgs);
    }

    public MessagePopup(String title, ContentMode contentMode, CorePopup.ColorStyle colorStyle, String ... msgs) {
        this.setHeight("50%");
        this.contentMode = contentMode;
        this.colorStyle = colorStyle;
        this.popupTitle = title;
        int i = 0;
        while (i < msgs.length) {
            this.messages.add(msgs[i]);
            ++i;
        }
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.okButton = this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.close());
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.setColorStyle(this.colorStyle);
        for (String message : this.messages) {
            Label la = new Label(message, this.contentMode);
            contentLayout.addComponent((Component)la);
        }
    }
}

