/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.swicthpopup;

import com.vaadin.data.Container;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.OptionGroup;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class SwitchPopup
extends CorePopup {
    private OptionGroup group;
    private int index;
    private List<SwitchPopupInfo> infos = new ArrayList<SwitchPopupInfo>();
    private String line1 = "Veuillez indiquer l'action que vous souhaitez r\u00e9aliser :";
    private String header;

    public SwitchPopup(String title, int width) {
        this.popupTitle = title;
        this.setWidth(width);
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void addLine(String lib, Supplier<CorePopup> popupSupplier) {
        this.infos.add(new SwitchPopupInfo(SwitchPopup.s(lib), popupSupplier));
    }

    public void addLineAction(String lib, Runnable runnable) {
        this.infos.add(new SwitchPopupInfo(SwitchPopup.s(lib), runnable));
    }

    public void addSeparator() {
        if (this.infos.size() == 0) {
            return;
        }
        SwitchPopupInfo info = this.infos.get(this.infos.size() - 1);
        info.lib = String.valueOf(info.lib) + "<br/><br/>";
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        contentLayout.addStyleName("popup-switch");
        if (this.header != null) {
            contentLayout.addComponent((Component)new Label(this.header, ContentMode.HTML));
        }
        this.group = new OptionGroup(this.line1);
        this.group.setHtmlContentAllowed(true);
        for (SwitchPopupInfo info : this.infos) {
            this.group.addItem((Object)info.lib);
        }
        contentLayout.addComponent((Component)this.group);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.addDefaultButton("Continuer ...", (Button.ClickListener & Serializable)e -> this.handleContinuer());
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleContinuer() {
        this.index = ((Container.Indexed)this.group.getContainerDataSource()).indexOfId(this.group.getValue());
        if (this.index == -1) {
            this.close();
            return;
        }
        SwitchPopupInfo info = this.infos.get(this.index);
        if (info.popupSupplier != null) {
            this.changeCloseListener((Window.CloseListener & Serializable)e -> this.swithToNextPopup(info));
            this.close();
        } else {
            info.runnable.run();
            this.close();
        }
    }

    protected void swithToNextPopup(SwitchPopupInfo info) {
        CorePopup popup = info.popupSupplier.get();
        popup.changeCloseListener(this.popupCloseListener);
        popup.open();
    }

    public static class SwitchPopupInfo {
        public String lib;
        public Supplier<CorePopup> popupSupplier;
        public Runnable runnable;

        public SwitchPopupInfo(String lib, Supplier<CorePopup> popupSupplier) {
            this.lib = lib;
            this.popupSupplier = popupSupplier;
        }

        public SwitchPopupInfo(String lib, Runnable runnable) {
            this.lib = lib;
            this.runnable = runnable;
        }
    }
}

