/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.statuspage;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.model.models.param.paramecran.PEExtendedParametres;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.statuspage.StatusPageBackupImporter;
import java.io.Serializable;

public class StatusPagePopupLoadBackup
extends CorePopup {
    private StatusPageBackupImporter backupImporter;
    private VerticalLayout contentLayout;
    private Button cancelButton;
    private Button saveButton;
    private Button continueAnywayButton;
    private StatusPageBackupImporter.Result r;

    public StatusPagePopupLoadBackup() {
        this.popupTitle = "Charger une sauvegarde";
        this.setWidth(70);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.cancelButton = this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.close());
        this.saveButton = this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.close());
        this.saveButton.setVisible(false);
        this.continueAnywayButton = this.addButton("Continuer malgr\u00e9 la diff\u00e9rence de version", (Button.ClickListener & Serializable)e -> this.doImport());
        this.continueAnywayButton.setVisible(false);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.contentLayout = contentLayout;
        String str = "Cet outil va vous permettre de charger la sauvegarde d'une base<br/>Pour cela, merci de cliquer sur le bouton ci dessous, puis de choisir le fichier que vous avez re\u00e7u par mail.<br/>Le nom du fichier est de type nom-de-votre-amap_V044_2025_02_28_05_02_03.tar.gz <br/><br/>";
        this.addHtml(str);
        this.backupImporter = new StatusPageBackupImporter();
        Upload upload = new Upload(null, (Upload.Receiver)this.backupImporter);
        upload.setImmediate(true);
        upload.setButtonCaption("Charger la sauvegarde de la base");
        upload.addSucceededListener((Upload.SucceededListener & Serializable)e -> this.handleEndImport());
        contentLayout.addComponent((Component)upload);
    }

    private void handleEndImport() {
        this.contentLayout.removeAllComponents();
        this.r = this.backupImporter.getResult();
        if (this.r.errorMessage != null) {
            this.addHtml("Une erreur est survenue.");
            this.addText(this.r.errorMessage);
            return;
        }
        if (!this.r.isVersionOK) {
            this.addHtml("ATTENTION !!! ");
            this.addHtml("Le fichier de sauvegarde contient une base de donn\u00e9es ayant pour version AMAPJ : " + this.r.version);
            this.addHtml("Vous avez install\u00e9 sur votre PC la version AMAPJ : " + new MaintenanceService().getShortVersion());
            this.addHtml("Il serait souhaitable d'installer sur votre PC la version d'AMAPJ qui correspond \u00e0 la version de cette sauvegarde.");
            this.addHtml("Vous risquez d'avoir des erreurs lors de l'utilisation d'AMAPJ");
            this.continueAnywayButton.setVisible(true);
            return;
        }
        this.doImport();
    }

    private void doImport() {
        this.contentLayout.removeAllComponents();
        DataBaseInfo dataBaseInfo = DbManager.get().findDataBaseFromName("amap1");
        DbManager.get().replaceDataBase(dataBaseInfo, this.r.fileProperties, this.r.fileScript);
        SpecificDbUtils.executeInMaster(() -> this.writePEstatusPage());
        this.addHtml("L'import a \u00e9t\u00e9 r\u00e9alis\u00e9e avec succ\u00e8s.");
        this.addText("D\u00e9tails de la base import\u00e9e : ");
        this.addHtml(this.r.content);
        this.cancelButton.setVisible(false);
        this.saveButton.setVisible(true);
        this.continueAnywayButton.setVisible(false);
    }

    private Object writePEstatusPage() {
        PEExtendedParametres pe = (PEExtendedParametres)new ParametresService().loadParamEcran(MenuList.EXTENDED_PARAMETRES);
        pe.masterDbLibAmap1 = this.r.content;
        new ParametresService().update(pe);
        return null;
    }

    private void addHtml(String str) {
        this.contentLayout.addComponent((Component)new Label(str, ContentMode.HTML));
    }

    private void addText(String str) {
        this.contentLayout.addComponent((Component)new Label(str));
    }
}

