/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.statuspage;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.models.param.paramecran.PEExtendedParametres;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.statuspage.StatusPagePopupLoadBackup;
import fr.amapj.view.engine.ui.AmapUI;
import java.io.Serializable;

public class StatusPageView {
    private AmapUI amapUI;
    private VerticalLayout vl = new VerticalLayout();

    public StatusPageView(AmapUI amapUI) {
        this.amapUI = amapUI;
    }

    public void open() {
        this.vl.removeAllComponents();
        PEExtendedParametres pe = SpecificDbUtils.executeInMaster(() -> (PEExtendedParametres)new ParametresService().loadParamEcran(MenuList.EXTENDED_PARAMETRES));
        this.addText("<center><b>Bienvenue dans le logiciel AMAPJ.</b></center>");
        this.addText("");
        this.addText("Vous avez install\u00e9 AMAPJ avec succ\u00e8s sur votre machine locale.");
        this.addText("Cette installation comprend une base de donn\u00e9es, dont voici les d\u00e9tails :");
        this.addText(pe.masterDbLibAmap1);
        this.addText("Si vous souhaitez acc\u00e9der \u00e0 cet AMAPJ , merci de cliquer sur le lien ci dessous : ");
        Link link = new Link("Acc\u00e8der \u00e0 AMAPJ install\u00e9 sur mon PC (local) ", (Resource)new ExternalResource("/amapj/amap1"));
        link.setTargetName("_blank");
        link.addStyleName("statuspage");
        this.vl.addComponent((Component)link);
        this.addText("");
        this.addText("");
        this.addText("Si vous le souhaitez, vous pouvez remplacer cette base de donn\u00e9es avec une de vos sauvegardes.");
        this.addText("Vous pourrez alors consulter vos donn\u00e9es comme elles \u00e9taient au moment de la sauvegarde.");
        this.addText("Pour lancer cette restauration, merci de cliquer sur le bouton ci dessous \"Restaurer une base de donn\u00e9es\"");
        Button b = new Button("Restaurer une base de donn\u00e9es");
        b.addClickListener((Button.ClickListener & Serializable)e -> this.handleRestore());
        this.vl.addComponent((Component)b);
        this.addText("");
        this.addText("");
        this.amapUI.setContent((Component)this.vl);
    }

    private void handleRestore() {
        new StatusPagePopupLoadBackup().open(() -> this.open());
    }

    private void addText(String text) {
        Label l = new Label(text, ContentMode.HTML);
        l.addStyleName("statuspage");
        this.vl.addComponent((Component)l);
    }
}

